/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.loot.LootPoolShell;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.IWishingWellBlock;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.IWishable;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

public class WealthItem
extends ModItem
implements IWishable {
    public WealthItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77625_d(TreasureConfig.WEALTH.wealthMaxStackSize);
        this.func_77637_a(Treasure.TREASURE_TAB);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"tooltip.label.wishable"));
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack entityItemStack = entityItem.func_92059_d();
        World world = entityItem.func_130014_f_();
        if (WorldInfo.isClientSide(world)) {
            return super.onEntityItemUpdate(entityItem);
        }
        Coords coords = new Coords(entityItem.func_180425_c());
        Cube cube = new Cube(world, coords);
        int numWishingWellBlocks = 0;
        if (cube.equalsBlock((Block)Blocks.field_150355_j)) {
            ICoords checkCoords = coords.add(-1, 0, -1);
            block0: for (int z = 0; z < 3; ++z) {
                for (int x = 0; x < 3; ++x) {
                    Cube checkCube = new Cube(world, checkCoords);
                    if (checkCube.toBlock() instanceof IWishingWellBlock) {
                        ++numWishingWellBlocks;
                    }
                    if (numWishingWellBlocks >= 2) continue block0;
                }
            }
            if (numWishingWellBlocks >= 2) {
                Treasure.LOGGER.debug("in a wishing well");
                Random random = new Random();
                for (int itemIndex = 0; itemIndex < entityItemStack.func_190916_E(); ++itemIndex) {
                    Optional<ItemStack> lootStack = this.generateLoot(world, random, entityItem.func_92059_d(), coords);
                    if (!lootStack.isPresent()) continue;
                    Treasure.LOGGER.debug("loot stack is present");
                    InventoryHelper.func_180173_a((World)world, (double)coords.getX(), (double)((double)coords.getY() + 1.0), (double)coords.getZ(), (ItemStack)lootStack.get());
                }
                entityItem.func_70106_y();
                return true;
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    @Override
    public Optional<ItemStack> generateLoot(World world, Random random, ItemStack itemStack, ICoords coords) {
        List lootTables = this.getLootTables();
        ItemStack outputStack = null;
        if (lootTables == null || lootTables.size() == 0) {
            outputStack = this.getDefaultLootKey(random);
        } else {
            LootTableShell tableShell;
            ItemStack wealthItem = itemStack;
            NBTTagCompound nbt = wealthItem.func_77978_p();
            Treasure.LOGGER.debug("item as a tag");
            EntityPlayer player = null;
            if (nbt != null && nbt.func_74764_b("droppedBy")) {
                player = Optional.of(world.func_152378_a(UUID.fromString(nbt.func_74779_i("droppedBy")))).orElseGet(() -> {
                    Treasure.LOGGER.debug("getting player by name");
                    return world.func_72924_a(nbt.func_74779_i("droppedBy"));
                });
                if (player != null && Treasure.LOGGER.isDebugEnabled()) {
                    Treasure.LOGGER.debug("wealth item dropped by player -> {}", (Object)player.func_70005_c_());
                } else {
                    Treasure.LOGGER.debug("can't find player!");
                }
            }
            if ((tableShell = (LootTableShell)lootTables.get(RandomHelper.randomInt(random, 0, lootTables.size() - 1))).getResourceLocation() == null) {
                return Optional.empty();
            }
            LootTable table = world.func_184146_ak().func_186521_a(tableShell.getResourceLocation());
            List<LootPoolShell> lootPoolShells = tableShell.getPools();
            LootContext lootContext = this.getLootContext(world, player);
            ArrayList itemStacks = new ArrayList();
            for (LootPoolShell pool : lootPoolShells) {
                Treasure.LOGGER.debug("processing pool -> {}", (Object)pool.getName());
                LootPool lootPool = table.getPool(pool.getName());
                lootPool.func_186449_b(itemStacks, random, lootContext);
            }
            Rarity effectiveRarity = TreasureLootTableRegistry.getLootTableMaster().getEffectiveRarity(tableShell, this.getDefaultEffectiveRarity(random));
            Treasure.LOGGER.debug("using effective rarity -> {}", (Object)effectiveRarity);
            this.injectLoot(world, random, itemStacks, tableShell.getCategory(), effectiveRarity, lootContext);
            for (ItemStack stack : itemStacks) {
                Treasure.LOGGER.debug("possible loot item -> {}", (Object)stack.func_77973_b().getRegistryName().toString());
            }
            outputStack = (ItemStack)itemStacks.get(RandomHelper.randomInt(0, itemStacks.size() - 1));
            Treasure.LOGGER.debug("loot item output stack -> {}", (Object)outputStack.func_77973_b().getRegistryName().toString());
        }
        return Optional.of(outputStack);
    }
}

