/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.someguyssoftware.gottschcore.armor.ModArmorBuilder;
import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.item.ModSwordBuilder;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.AdornmentSize;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.capability.AdornmentCapabilityProvider;
import com.someguyssoftware.treasure2.capability.CharmableCapability;
import com.someguyssoftware.treasure2.capability.CharmableCapabilityProvider;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.RunestonesCapability;
import com.someguyssoftware.treasure2.capability.RunestonesCapabilityProvider;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.capability.modifier.GreatAdornmentLevelModifier;
import com.someguyssoftware.treasure2.capability.modifier.ILevelModifier;
import com.someguyssoftware.treasure2.capability.modifier.LordsAdornmentLevelModifier;
import com.someguyssoftware.treasure2.capability.modifier.NoLevelModifier;
import com.someguyssoftware.treasure2.charm.AegisCharm;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.CheatDeathCharm;
import com.someguyssoftware.treasure2.charm.GreaterHealingCharm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.IlluminationCharm;
import com.someguyssoftware.treasure2.charm.LifeStrikeCharm;
import com.someguyssoftware.treasure2.charm.ReflectionCharm;
import com.someguyssoftware.treasure2.charm.ShieldingCharm;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.AdornmentType;
import com.someguyssoftware.treasure2.enums.Category;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.integration.baubles.BaublesIntegration;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.item.CharmBook;
import com.someguyssoftware.treasure2.item.CharmItem;
import com.someguyssoftware.treasure2.item.EmberKey;
import com.someguyssoftware.treasure2.item.EmberLock;
import com.someguyssoftware.treasure2.item.GemItem;
import com.someguyssoftware.treasure2.item.JewelledKey;
import com.someguyssoftware.treasure2.item.KeyItem;
import com.someguyssoftware.treasure2.item.KeyRingItem;
import com.someguyssoftware.treasure2.item.LightningKey;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.MetallurgistsKey;
import com.someguyssoftware.treasure2.item.NamedAdornment;
import com.someguyssoftware.treasure2.item.PaintingItem;
import com.someguyssoftware.treasure2.item.PilferersLockPick;
import com.someguyssoftware.treasure2.item.PouchItem;
import com.someguyssoftware.treasure2.item.RunestoneItem;
import com.someguyssoftware.treasure2.item.SkeletonItem;
import com.someguyssoftware.treasure2.item.SkeletonKey;
import com.someguyssoftware.treasure2.item.SpanishMossItem;
import com.someguyssoftware.treasure2.item.ThiefsLockPick;
import com.someguyssoftware.treasure2.item.TreasureToolItem;
import com.someguyssoftware.treasure2.item.WealthItem;
import com.someguyssoftware.treasure2.item.WitherRootItem;
import com.someguyssoftware.treasure2.item.WitherStickItem;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import com.someguyssoftware.treasure2.material.CharmableMaterial;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import com.someguyssoftware.treasure2.rune.AngelsRune;
import com.someguyssoftware.treasure2.rune.DoubleChargeRune;
import com.someguyssoftware.treasure2.rune.GreaterManaRune;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.TreasureRunes;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreasureItems {
    public static Item TREASURE_TAB;
    public static Item ADORNMENTS_TAB;
    public static KeyItem WOOD_KEY;
    public static KeyItem STONE_KEY;
    public static KeyItem EMBER_KEY;
    public static KeyItem LEAF_KEY;
    public static KeyItem LIGHTNING_KEY;
    public static KeyItem IRON_KEY;
    public static KeyItem GOLD_KEY;
    public static KeyItem METALLURGISTS_KEY;
    public static KeyItem DIAMOND_KEY;
    public static KeyItem EMERALD_KEY;
    public static KeyItem RUBY_KEY;
    public static KeyItem SAPPHIRE_KEY;
    public static KeyItem JEWELLED_KEY;
    public static KeyItem WITHER_KEY;
    public static KeyItem BONE_KEY;
    public static KeyItem SKELETON_KEY;
    public static KeyItem SPIDER_KEY;
    public static KeyItem DRAGON_KEY;
    public static KeyItem MASTER_KEY;
    public static KeyItem PILFERERS_LOCK_PICK;
    public static KeyItem THIEFS_LOCK_PICK;
    public static KeyRingItem KEY_RING;
    public static PouchItem POUCH;
    public static LockItem WOOD_LOCK;
    public static LockItem STONE_LOCK;
    public static LockItem EMBER_LOCK;
    public static LockItem LEAF_LOCK;
    public static LockItem IRON_LOCK;
    public static LockItem GOLD_LOCK;
    public static LockItem DIAMOND_LOCK;
    public static LockItem EMERALD_LOCK;
    public static LockItem RUBY_LOCK;
    public static LockItem SAPPHIRE_LOCK;
    public static LockItem SPIDER_LOCK;
    public static LockItem WITHER_LOCK;
    public static WealthItem COPPER_COIN;
    public static WealthItem SILVER_COIN;
    public static WealthItem GOLD_COIN;
    public static Adornment FOOLS_COIN;
    public static Adornment ANGELS_RING;
    public static Adornment RING_OF_FORTITUDE;
    public static Adornment PEASANTS_FORTUNE;
    public static Adornment GOTTSCHS_RING_OF_MOON;
    public static Adornment GOTTSCHS_AMULET_OF_HEAVENS;
    public static Adornment CASTLE_RING;
    public static Adornment SHADOWS_GIFT;
    public static Adornment BRACELET_OF_WONDER;
    public static Adornment RING_OF_LIFE_DEATH;
    public static Adornment MEDICS_TOKEN;
    public static Adornment SALANDAARS_WARD;
    public static Adornment ADEPHAGIAS_BOUNTY;
    public static Adornment MIRTHAS_TORCH;
    public static Adornment DWARVEN_TALISMAN;
    public static Adornment MINERS_FRIEND;
    public static Adornment POCKET_WATCH;
    public static Item AMETHYST;
    public static Item ONYX;
    public static Item SAPPHIRE;
    public static Item RUBY;
    public static Item WHITE_PEARL;
    public static Item BLACK_PEARL;
    public static CharmItem CHARM_BOOK;
    public static RunestoneItem MANA_RUNESTONE;
    public static RunestoneItem GREATER_MANA_RUNESTONE;
    public static RunestoneItem DURABILITY_RUNESTONE;
    public static RunestoneItem QUALITY_RUNESTONE;
    public static RunestoneItem EQUIP_MANA_RUNESTONE;
    public static RunestoneItem ANVIL_RUNESTONE;
    public static RunestoneItem ANGELS_RUNESTONE;
    public static RunestoneItem PERSISTENCE_RUNESTONE;
    public static RunestoneItem SOCKETS_RUNESTONE;
    public static RunestoneItem DOUBLE_CHARGE_RUNESTONE;
    public static Item WITHER_STICK_ITEM;
    public static Item WITHER_ROOT_ITEM;
    public static Item SKULL_SWORD;
    public static Item EYE_PATCH;
    public static PotionType EXTRA_STRONG_HEALING;
    public static PotionType EXTRA_STRONG_STRENGTH;
    public static PotionType EXTRA_STRONG_LEAPING;
    public static PotionType EXTRA_STRONG_SWIFTNESS;
    public static PotionType EXTRA_STRONG_REGENERATION;
    public static PotionType EXTRA_STRONG_POISON;
    public static Item PAINTING_BLOCKS_BRICKS;
    public static Item PAINTING_BLOCKS_COBBLESTONE;
    public static Item PAINTING_BLOCKS_DIRT;
    public static Item PAINTING_BLOCKS_LAVA;
    public static Item PAINTING_BLOCKS_SAND;
    public static Item PAINTING_BLOCKS_WATER;
    public static Item PAINTING_BLOCKS_WOOD;
    public static Item SPANISH_MOSS;
    public static Item TREASURE_TOOL;
    public static Item SKELETON;
    public static final Item.ToolMaterial SKULL_TOOL_MATERIAL;
    public static Multimap<Rarity, KeyItem> keys;
    public static Multimap<Rarity, LockItem> locks;
    public static final Map<ResourceLocation, Item> ITEMS;
    public static final Map<ResourceLocation, CharmItem> CHARM_ITEMS;
    public static final Map<ResourceLocation, Adornment> ADORNMENT_ITEMS;
    public static Comparator<CharmItem> charmLevelComparator;

    private static CharmItem createCharm(final CharmableMaterial material, final Item source) {
        String name = (source == Items.field_190931_a ? material.getName().func_110623_a() : source.getRegistryName().func_110623_a()) + "_charm";
        Treasure.LOGGER.debug("creating charmItem -> {}", (Object)name);
        CharmItem charm = new CharmItem("treasure2", name){

            @Override
            public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                    $.innate = true;
                    $.bindable = true;
                    $.source = true;
                    $.executing = true;
                    $.namedByMaterial = true;
                    $.baseMaterial = material.getName();
                    $.sourceItem = source.getRegistryName();
                }).build();
                cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 1))).get().createEntity());
                return new CharmableCapabilityProvider(cap);
            }
        };
        return charm;
    }

    public static CharmItem getCharmItemByLevel(int level) {
        CharmItem resultItem = null;
        ArrayList<CharmItem> charms = new ArrayList<CharmItem>(CHARM_ITEMS.values());
        Collections.sort(charms, charmLevelComparator);
        for (Item item : charms) {
            Treasure.LOGGER.debug("charm item -> {}", (Object)((CharmItem)item).getRegistryName());
            ItemStack itemStack = new ItemStack(item);
            ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
            if (cap == null) continue;
            Treasure.LOGGER.debug("name -> {}, charm level -> {}, level -> {}", (Object)itemStack.func_82833_r(), (Object)cap.getMaxCharmLevel(), (Object)level);
            if (cap.getMaxCharmLevel() < level) continue;
            resultItem = (CharmItem)item;
            break;
        }
        return resultItem;
    }

    public static Optional<ItemStack> getCharm(String charmName, int level, int itemType) {
        CharmItem charmItem = null;
        charmItem = itemType == 1 ? CHARM_BOOK : TreasureItems.getCharmItemByLevel(level);
        Optional<ICharm> charm = TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(charmName, level)));
        if (!charm.isPresent()) {
            return Optional.empty();
        }
        ItemStack charmStack = new ItemStack((Item)charmItem);
        ICharmableCapability cap = (ICharmableCapability)charmStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        cap.clearCharms();
        cap.add(InventoryType.INNATE, charm.get().createEntity());
        return Optional.of(charmStack);
    }

    static {
        SKULL_TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"SKULL", (int)2, (int)1800, (float)9.0f, (float)4.0f, (int)25);
        ITEMS = new HashMap<ResourceLocation, Item>();
        CHARM_ITEMS = new HashMap<ResourceLocation, CharmItem>();
        ADORNMENT_ITEMS = new HashMap<ResourceLocation, Adornment>();
        charmLevelComparator = new Comparator<CharmItem>(){

            @Override
            public int compare(CharmItem p1, CharmItem p2) {
                ItemStack stack1 = new ItemStack((Item)p1);
                ItemStack stack2 = new ItemStack((Item)p2);
                if (((ICharmableCapability)stack1.getCapability(TreasureCapabilities.CHARMABLE, null)).getMaxCharmLevel() > ((ICharmableCapability)stack2.getCapability(TreasureCapabilities.CHARMABLE, null)).getMaxCharmLevel()) {
                    return 1;
                }
                return -1;
            }
        };
    }

    public static class SetupItems {
        List<AdornmentType> types = Arrays.asList(AdornmentType.BRACELET, AdornmentType.NECKLACE, AdornmentType.RING);
        List<AdornmentSize> sizes = Arrays.asList(TreasureAdornmentRegistry.STANDARD);
        List<CharmableMaterial> materials = Arrays.asList(TreasureCharmableMaterials.IRON, TreasureCharmableMaterials.COPPER, TreasureCharmableMaterials.SILVER, TreasureCharmableMaterials.GOLD);
        List<ResourceLocation> sources = Arrays.asList(Items.field_151045_i.getRegistryName(), Items.field_151166_bC.getRegistryName(), AMETHYST.getRegistryName(), ONYX.getRegistryName(), RUBY.getRegistryName(), SAPPHIRE.getRegistryName(), WHITE_PEARL.getRegistryName(), BLACK_PEARL.getRegistryName());
        Map<CharmableMaterial, Integer> materialInnates = Maps.newHashMap();
        Map<AdornmentSize, ILevelModifier> levelModifiers = Maps.newHashMap();

        public SetupItems() {
            this.materialInnates.put(TreasureCharmableMaterials.IRON, 0);
            this.materialInnates.put(TreasureCharmableMaterials.COPPER, 1);
            this.materialInnates.put(TreasureCharmableMaterials.SILVER, 2);
            this.materialInnates.put(TreasureCharmableMaterials.GOLD, 3);
            this.levelModifiers.put(TreasureAdornmentRegistry.STANDARD, new NoLevelModifier());
            this.levelModifiers.put(TreasureAdornmentRegistry.GREAT, new GreatAdornmentLevelModifier());
            this.levelModifiers.put(TreasureAdornmentRegistry.LORDS, new LordsAdornmentLevelModifier());
        }

        public List<Item> createAdornments() {
            ArrayList<Item> adornments = new ArrayList<Item>();
            this.types.forEach(type -> this.sizes.forEach(size -> this.materials.forEach(material -> {
                Adornment a = this.createAdornment((AdornmentType)type, (CharmableMaterial)material, (AdornmentSize)size, Items.field_190931_a.getRegistryName());
                a.func_77637_a(Treasure.ADORNMENTS_TAB);
                adornments.add(a);
                TreasureAdornmentRegistry.register(material.getName(), Items.field_190931_a.getRegistryName(), a);
            })));
            this.types.forEach(type -> this.sizes.forEach(size -> this.materials.forEach(material -> this.sources.forEach(source -> {
                Adornment a = this.createAdornment((AdornmentType)type, (CharmableMaterial)material, (AdornmentSize)size, (ResourceLocation)source);
                a.func_77637_a(Treasure.ADORNMENTS_TAB);
                adornments.add(a);
                TreasureAdornmentRegistry.register(material.getName(), source, a);
            }))));
            AdornmentSize size = TreasureAdornmentRegistry.GREAT;
            List<CharmableMaterial> materials2 = Arrays.asList(TreasureCharmableMaterials.IRON, TreasureCharmableMaterials.COPPER, TreasureCharmableMaterials.SILVER, TreasureCharmableMaterials.GOLD, TreasureCharmableMaterials.BLOOD, TreasureCharmableMaterials.BLACK);
            this.materialInnates.put(TreasureCharmableMaterials.BLOOD, 2);
            this.materialInnates.put(TreasureCharmableMaterials.BLACK, 3);
            ResourceLocation source = Items.field_190931_a.getRegistryName();
            materials2.forEach(material -> this.types.forEach(type -> {
                Adornment a = this.createAdornment((AdornmentType)type, (CharmableMaterial)material, size, source);
                a.func_77637_a(Treasure.ADORNMENTS_TAB);
                Treasure.LOGGER.debug("adding adornment item -> {}", (Object)a.getRegistryName());
                adornments.add(a);
                TreasureAdornmentRegistry.register(material.getName(), source, a);
            }));
            materials2 = Arrays.asList(TreasureCharmableMaterials.IRON, TreasureCharmableMaterials.COPPER, TreasureCharmableMaterials.SILVER, TreasureCharmableMaterials.GOLD, TreasureCharmableMaterials.BLOOD, TreasureCharmableMaterials.BLACK);
            materials2.forEach(material -> this.sources.forEach(s -> this.types.forEach(type -> {
                Adornment a = this.createAdornment((AdornmentType)type, (CharmableMaterial)material, size, (ResourceLocation)s);
                a.func_77637_a(Treasure.ADORNMENTS_TAB);
                adornments.add(a);
                TreasureAdornmentRegistry.register(material.getName(), s, a);
            })));
            return adornments;
        }

        private Adornment createAdornment(final AdornmentType type, final CharmableMaterial material, final AdornmentSize size, final ResourceLocation source) {
            String name = (size == TreasureAdornmentRegistry.STANDARD ? "" : size.getName() + "_") + (source == Items.field_190931_a.getRegistryName() ? "" : source.func_110623_a() + "_") + material.getName().func_110623_a() + "_" + type.toString();
            Adornment a = new Adornment("treasure2", name, type, size){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    int innateSize = materialInnates.get(material);
                    if (size == TreasureAdornmentRegistry.GREAT && material == TreasureCharmableMaterials.IRON) {
                        ++innateSize;
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(innateSize, 1, 1).with($ -> {
                        $.innate = material != TreasureCharmableMaterials.IRON;
                        $.imbuable = material != TreasureCharmableMaterials.IRON && material != TreasureCharmableMaterials.COPPER;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = true;
                        $.namedByMaterial = true;
                        $.baseMaterial = material.getName();
                        $.levelModifier = levelModifiers.get(size);
                        $.sourceItem = source;
                    }).build();
                    IRunestonesCapability runestonesCap = new RunestonesCapability(0, 0, 0);
                    if (cap.getMaxCharmLevel() >= 8) {
                        runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                            $.socketable = true;
                        }).build();
                    }
                    int durability = (innateSize + 2) * material.getMaxLevel() * material.getDurability();
                    DurabilityCapability durabilityCap = new DurabilityCapability(durability, durability);
                    durabilityCap.setMaxRepairs(material.getMaxRepairs());
                    durabilityCap.setRepairs(durabilityCap.getMaxRepairs());
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(type, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            return a;
        }
    }

    @Mod.EventBusSubscriber(modid="treasure2")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            TREASURE_TAB = new ModItem().setItemName("treasure2", "treasure_tab");
            ADORNMENTS_TAB = new ModItem().setItemName("treasure2", "adornments_tab");
            WOOD_KEY = new KeyItem("treasure2", "wood_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.COMMON).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.woodKeyMaxUses);
            STONE_KEY = new KeyItem("treasure2", "stone_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.COMMON).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.stoneKeyMaxUses);
            EMBER_KEY = new EmberKey("treasure2", "ember_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.SCARCE).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.emberKeyMaxUses);
            LEAF_KEY = new KeyItem("treasure2", "leaf_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.UNCOMMON).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.leafKeyMaxUses);
            LIGHTNING_KEY = new LightningKey("treasure2", "lightning_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.SCARCE).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.lightningKeyMaxUses);
            IRON_KEY = new KeyItem("treasure2", "iron_key").setCategory(Category.METALS).setRarity(Rarity.UNCOMMON).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.ironKeyMaxUses);
            GOLD_KEY = new KeyItem("treasure2", "gold_key").setCategory(Category.METALS).setRarity(Rarity.SCARCE).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.goldKeyMaxUses);
            DIAMOND_KEY = new KeyItem("treasure2", "diamond_key").setCategory(Category.GEMS).setRarity(Rarity.RARE).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.diamondKeyMaxUses);
            EMERALD_KEY = new KeyItem("treasure2", "emerald_key").setCategory(Category.GEMS).setRarity(Rarity.RARE).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.emeraldKeyMaxUses);
            RUBY_KEY = new KeyItem("treasure2", "ruby_key").setCategory(Category.GEMS).setRarity(Rarity.EPIC).setBreakable(false).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.rubyKeyMaxUses);
            SAPPHIRE_KEY = new KeyItem("treasure2", "sapphire_key").setCategory(Category.GEMS).setRarity(Rarity.EPIC).setBreakable(false).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.sapphireKeyMaxUses);
            JEWELLED_KEY = new JewelledKey("treasure2", "jewelled_key").setCategory(Category.GEMS).setRarity(Rarity.EPIC).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.jewelledKeyMaxUses);
            METALLURGISTS_KEY = new MetallurgistsKey("treasure2", "metallurgists_key").setCategory(Category.METALS).setRarity(Rarity.RARE).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.metallurgistsKeyMaxUses);
            SKELETON_KEY = new SkeletonKey("treasure2", "skeleton_key").setCategory(Category.ELEMENTAL).setRarity(Rarity.RARE).setBreakable(false).setCraftable(false).setMaxDamage(TreasureConfig.KEYS_LOCKS.skeletonKeyMaxUses);
            SPIDER_KEY = new KeyItem("treasure2", "spider_key").setCategory(Category.MOB).setRarity(Rarity.SCARCE).setBreakable(true).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.spiderKeyMaxUses);
            WITHER_KEY = new KeyItem("treasure2", "wither_key").setCategory(Category.WITHER).setRarity(Rarity.RARE).setBreakable(false).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.witherKeyMaxUses);
            PILFERERS_LOCK_PICK = new PilferersLockPick("treasure2", "pilferers_lock_pick").setCategory(Category.ELEMENTAL).setRarity(Rarity.COMMON).setBreakable(true).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.pilferersLockPickMaxUses).setSuccessProbability(32.0);
            THIEFS_LOCK_PICK = new ThiefsLockPick("treasure2", "thiefs_lock_pick").setCategory(Category.ELEMENTAL).setRarity(Rarity.UNCOMMON).setBreakable(true).setCraftable(true).setMaxDamage(TreasureConfig.KEYS_LOCKS.thiefsLockPickMaxUses).setSuccessProbability(48.0);
            KEY_RING = new KeyRingItem("treasure2", "key_ring");
            keys = ArrayListMultimap.create();
            keys.put((Object)WOOD_KEY.getRarity(), (Object)WOOD_KEY);
            keys.put((Object)STONE_KEY.getRarity(), (Object)STONE_KEY);
            keys.put((Object)EMBER_KEY.getRarity(), (Object)EMBER_KEY);
            keys.put((Object)LEAF_KEY.getRarity(), (Object)LEAF_KEY);
            keys.put((Object)LIGHTNING_KEY.getRarity(), (Object)LIGHTNING_KEY);
            keys.put((Object)IRON_KEY.getRarity(), (Object)IRON_KEY);
            keys.put((Object)GOLD_KEY.getRarity(), (Object)GOLD_KEY);
            keys.put((Object)DIAMOND_KEY.getRarity(), (Object)DIAMOND_KEY);
            keys.put((Object)EMERALD_KEY.getRarity(), (Object)EMERALD_KEY);
            keys.put((Object)RUBY_KEY.getRarity(), (Object)RUBY_KEY);
            keys.put((Object)SAPPHIRE_KEY.getRarity(), (Object)SAPPHIRE_KEY);
            keys.put((Object)JEWELLED_KEY.getRarity(), (Object)JEWELLED_KEY);
            keys.put((Object)METALLURGISTS_KEY.getRarity(), (Object)METALLURGISTS_KEY);
            keys.put((Object)SKELETON_KEY.getRarity(), (Object)SKELETON_KEY);
            keys.put((Object)SPIDER_KEY.getRarity(), (Object)SPIDER_KEY);
            keys.put((Object)WITHER_KEY.getRarity(), (Object)WITHER_KEY);
            WOOD_LOCK = new LockItem("treasure2", "wood_lock", new KeyItem[]{WOOD_KEY, LIGHTNING_KEY}).setCategory(Category.ELEMENTAL).setRarity(Rarity.COMMON);
            STONE_LOCK = new LockItem("treasure2", "stone_lock", new KeyItem[]{STONE_KEY, LIGHTNING_KEY}).setCategory(Category.ELEMENTAL).setRarity(Rarity.COMMON);
            EMBER_LOCK = new EmberLock("treasure2", "ember_lock", new KeyItem[]{EMBER_KEY, LIGHTNING_KEY}).setCategory(Category.ELEMENTAL).setRarity(Rarity.SCARCE);
            LEAF_LOCK = new LockItem("treasure2", "leaf_lock", new KeyItem[]{LEAF_KEY, LIGHTNING_KEY}).setCategory(Category.ELEMENTAL).setRarity(Rarity.UNCOMMON);
            IRON_LOCK = new LockItem("treasure2", "iron_lock", new KeyItem[]{IRON_KEY, METALLURGISTS_KEY}).setCategory(Category.METALS).setRarity(Rarity.UNCOMMON);
            GOLD_LOCK = new LockItem("treasure2", "gold_lock", new KeyItem[]{GOLD_KEY, METALLURGISTS_KEY}).setCategory(Category.METALS).setRarity(Rarity.SCARCE);
            DIAMOND_LOCK = new LockItem("treasure2", "diamond_lock", new KeyItem[]{DIAMOND_KEY, JEWELLED_KEY}).setCategory(Category.GEMS).setRarity(Rarity.RARE);
            EMERALD_LOCK = new LockItem("treasure2", "emerald_lock", new KeyItem[]{EMERALD_KEY, JEWELLED_KEY}).setCategory(Category.GEMS).setRarity(Rarity.RARE);
            RUBY_LOCK = new LockItem("treasure2", "ruby_lock", new KeyItem[]{RUBY_KEY, JEWELLED_KEY}).setCategory(Category.GEMS).setRarity(Rarity.EPIC);
            SAPPHIRE_LOCK = new LockItem("treasure2", "sapphire_lock", new KeyItem[]{SAPPHIRE_KEY, JEWELLED_KEY}).setCategory(Category.GEMS).setRarity(Rarity.EPIC);
            SPIDER_LOCK = new LockItem("treasure2", "spider_lock", new KeyItem[]{SPIDER_KEY}).setCategory(Category.POTION).setRarity(Rarity.SCARCE);
            WITHER_LOCK = new LockItem("treasure2", "wither_lock", new KeyItem[]{WITHER_KEY}).setCategory(Category.WITHER).setRarity(Rarity.SCARCE);
            locks = ArrayListMultimap.create();
            locks.put((Object)WOOD_LOCK.getRarity(), (Object)WOOD_LOCK);
            locks.put((Object)STONE_LOCK.getRarity(), (Object)STONE_LOCK);
            locks.put((Object)EMBER_LOCK.getRarity(), (Object)EMBER_LOCK);
            locks.put((Object)LEAF_LOCK.getRarity(), (Object)LEAF_LOCK);
            locks.put((Object)IRON_LOCK.getRarity(), (Object)IRON_LOCK);
            locks.put((Object)GOLD_LOCK.getRarity(), (Object)GOLD_LOCK);
            locks.put((Object)DIAMOND_LOCK.getRarity(), (Object)DIAMOND_LOCK);
            locks.put((Object)EMERALD_LOCK.getRarity(), (Object)EMERALD_LOCK);
            locks.put((Object)RUBY_LOCK.getRarity(), (Object)RUBY_LOCK);
            locks.put((Object)SAPPHIRE_LOCK.getRarity(), (Object)SAPPHIRE_LOCK);
            locks.put((Object)SPIDER_LOCK.getRarity(), (Object)SPIDER_LOCK);
            COPPER_COIN = new WealthItem("treasure2", "copper_coin");
            SILVER_COIN = new WealthItem("treasure2", "silver_coin"){

                @Override
                public List<LootTableShell> getLootTables() {
                    Treasure.LOGGER.debug("getting silver loot tables");
                    ArrayList<LootTableShell> lootTables = new ArrayList<LootTableShell>();
                    lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.UNCOMMON));
                    lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.SCARCE));
                    return lootTables;
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.UNCOMMON));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            GOLD_COIN = new WealthItem("treasure2", "gold_coin"){

                @Override
                public List<LootTableShell> getLootTables() {
                    ArrayList<LootTableShell> lootTables = new ArrayList<LootTableShell>();
                    lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.SCARCE));
                    lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.RARE));
                    return lootTables;
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.SCARCE));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            AMETHYST = new GemItem("treasure2", "amethyst"){

                @Override
                public List<LootTableShell> getLootTables() {
                    return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.SCARCE);
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.SCARCE));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            ONYX = new GemItem("treasure2", "onyx"){

                @Override
                public List<LootTableShell> getLootTables() {
                    return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.RARE);
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.RARE));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            RUBY = new GemItem("treasure2", "ruby"){

                @Override
                public List<LootTableShell> getLootTables() {
                    return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.RARE);
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.RARE));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            SAPPHIRE = new GemItem("treasure2", "sapphire"){

                @Override
                public List<LootTableShell> getLootTables() {
                    return TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.EPIC);
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    ArrayList keys = new ArrayList(TreasureItems.keys.get((Object)Rarity.EPIC));
                    return new ItemStack((Item)keys.get(random.nextInt(keys.size())));
                }
            };
            WHITE_PEARL = new GemItem("treasure2", "white_pearl"){

                @Override
                public List<LootTableShell> getLootTables() {
                    ArrayList<LootTableShell> lootTables = new ArrayList<LootTableShell>();
                    lootTables.add(TreasureLootTableRegistry.getLootTableMaster().getSpecialLootTable(TreasureLootTableMaster2.SpecialLootTables.WHITE_PEARL_WELL));
                    return lootTables;
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    return new ItemStack(Items.field_151045_i);
                }
            };
            BLACK_PEARL = new GemItem("treasure2", "black_pearl"){

                @Override
                public List<LootTableShell> getLootTables() {
                    ArrayList<LootTableShell> lootTables = new ArrayList<LootTableShell>();
                    lootTables.add(TreasureLootTableRegistry.getLootTableMaster().getSpecialLootTable(TreasureLootTableMaster2.SpecialLootTables.BLACK_PEARL_WELL));
                    return lootTables;
                }

                @Override
                public ItemStack getDefaultLootKey(Random random) {
                    return new ItemStack(Items.field_151166_bC);
                }
            };
            CHARM_BOOK = new CharmBook("treasure2", "charm_book"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuing = true;
                        $.source = true;
                        $.executing = false;
                        $.baseMaterial = TreasureCharmableMaterials.CHARM_BOOK.getName();
                        $.sourceItem = Items.field_190931_a.getRegistryName();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 1))).get().createEntity());
                    return new CharmableCapabilityProvider(cap);
                }
            };
            POUCH = new PouchItem("treasure2", "pouch");
            List<Item> adornments = new SetupItems().createAdornments();
            ANGELS_RING = new NamedAdornment("treasure2", "angels_ring", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(3, 1, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = false;
                        $.namedByMaterial = false;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = WHITE_PEARL.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(AegisCharm.AEGIS_TYPE, 16))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(GreaterHealingCharm.HEALING_TYPE, 16))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName("fire_immunity", 16))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability(1000, 1000);
                    durabilityCap.setMaxRepairs(1);
                    durabilityCap.setRepairs(1);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.socketable = false;
                    }).build();
                    IRuneEntity runeEntity = TreasureRunes.RUNE_OF_ANGELS.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((AngelsRune)runeEntity.getRunestone()).initCapabilityApply(cap, durabilityCap, runeEntity);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            RING_OF_FORTITUDE = new NamedAdornment("treasure2", "ring_of_fortitude", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(2, 1, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = false;
                        $.namedByMaterial = false;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = BLACK_PEARL.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(AegisCharm.AEGIS_TYPE, 16))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ReflectionCharm.REFLECTION_TYPE, 16))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            SHADOWS_GIFT = new NamedAdornment("treasure2", "shadows_gift", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = false;
                        $.namedByMaterial = false;
                        $.baseMaterial = TreasureCharmableMaterials.BLACK.getName();
                        $.sourceItem = BLACK_PEARL.getRegistryName();
                        $.levelModifier = new NoLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName("drain", 25))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability(500, 500, TreasureCharmableMaterials.BLACK);
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            RING_OF_LIFE_DEATH = new NamedAdornment("treasure2", "ring_of_life_death", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(3, 1, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = false;
                        $.namedByMaterial = false;
                        $.baseMaterial = TreasureCharmableMaterials.BLOOD.getName();
                        $.sourceItem = WHITE_PEARL.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(LifeStrikeCharm.LIFE_STRIKE_TYPE, 25))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(CheatDeathCharm.TYPE, 25))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName("ruin", 15))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability(500, 500, TreasureCharmableMaterials.BLOOD);
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            CASTLE_RING = new NamedAdornment("treasure2", "castle_ring", AdornmentType.RING){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(2, 1, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.namedByCharm = false;
                        $.namedByMaterial = false;
                        $.baseMaterial = TreasureCharmableMaterials.SILVER.getName();
                        $.sourceItem = SAPPHIRE.getRegistryName();
                        $.levelModifier = new NoLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ShieldingCharm.SHIELDING_TYPE, 10))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ReflectionCharm.REFLECTION_TYPE, 10))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability(1000, 1000, TreasureCharmableMaterials.SILVER);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            PEASANTS_FORTUNE = new NamedAdornment("treasure2", "peasants_fortune", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(0, 0, 2).with($ -> {
                        $.innate = false;
                        $.imbuable = false;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.IRON.getName();
                        $.sourceItem = Item.func_150898_a((Block)Blocks.field_150348_b).getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    DurabilityCapability durabilityCap = new DurabilityCapability(500, 500, TreasureCharmableMaterials.IRON);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            GOTTSCHS_RING_OF_MOON = new NamedAdornment("treasure2", "gottschs_ring_of_moon", AdornmentType.RING, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(4, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = false;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.BLACK.getName();
                        $.sourceItem = SAPPHIRE.getRegistryName();
                        $.levelModifier = new NoLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(HealingCharm.TYPE, 21))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName("drain", 21))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ReflectionCharm.REFLECTION_TYPE, 21))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(LifeStrikeCharm.LIFE_STRIKE_TYPE, 21))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.RING, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            GOTTSCHS_AMULET_OF_HEAVENS = new NamedAdornment("treasure2", "gottschs_amulet_of_heavens", AdornmentType.NECKLACE, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(0, 0, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = SAPPHIRE.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.SOCKET).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(GreaterHealingCharm.HEALING_TYPE, 25))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(2, 0, 0).with($ -> {
                        $.socketable = false;
                    }).build();
                    IRuneEntity runeEntity = TreasureRunes.RUNE_OF_DOUBLE_CHARGE.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((DoubleChargeRune)runeEntity.getRunestone()).initCapabilityApply(cap, runeEntity);
                    runeEntity = TreasureRunes.RUNE_OF_ANGELS.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((AngelsRune)runeEntity.getRunestone()).initCapabilityApply(cap, durabilityCap, runeEntity);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.NECKLACE, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            BRACELET_OF_WONDER = new NamedAdornment("treasure2", "bracelet_of_wonder", AdornmentType.BRACELET, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    if (!EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    ICharmableCapability cap = new CharmableCapability.Builder(2, 1, 1).with($ -> {
                        $.innate = true;
                        $.imbuable = true;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = BLACK_PEARL.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ShieldingCharm.SHIELDING_TYPE, 24))).get().createEntity());
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ReflectionCharm.REFLECTION_TYPE, 24))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 1).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.BRACELET, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            MEDICS_TOKEN = new NamedAdornment("treasure2", "medics_token", AdornmentType.NECKLACE, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = false;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = SAPPHIRE.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(GreaterHealingCharm.HEALING_TYPE, 20))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.socketable = false;
                    }).build();
                    IRuneEntity runeEntity = TreasureRunes.RUNE_OF_GREATER_MANA.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((GreaterManaRune)runeEntity.getRunestone()).initCapabilityApply(cap, runeEntity);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.NECKLACE, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            ADEPHAGIAS_BOUNTY = new NamedAdornment("treasure2", "adephagias_bounty", AdornmentType.BRACELET, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = false;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = Items.field_151166_bC.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName("satiety", 20))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.socketable = false;
                    }).build();
                    IRuneEntity runeEntity = TreasureRunes.RUNE_OF_GREATER_MANA.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((GreaterManaRune)runeEntity.getRunestone()).initCapabilityApply(cap, runeEntity);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.BRACELET, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            SALANDAARS_WARD = new NamedAdornment("treasure2", "salandaars_ward", AdornmentType.NECKLACE, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = false;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = RUBY.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(ShieldingCharm.SHIELDING_TYPE, 20))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.socketable = false;
                    }).build();
                    IRuneEntity runeEntity = TreasureRunes.RUNE_OF_GREATER_MANA.createEntity();
                    runestonesCap.add(InventoryType.INNATE, runeEntity);
                    ((GreaterManaRune)runeEntity.getRunestone()).initCapabilityApply(cap, runeEntity);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.NECKLACE, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            MIRTHAS_TORCH = new NamedAdornment("treasure2", "mirthas_torch", AdornmentType.BRACELET, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(1, 0, 0).with($ -> {
                        $.innate = true;
                        $.imbuable = false;
                        $.socketable = false;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = WHITE_PEARL.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    cap.getCharmEntities().get((Object)InventoryType.INNATE).add(TreasureCharmRegistry.get(ResourceLocationUtil.create(Charm.Builder.makeName(IlluminationCharm.ILLUMINATION_TYPE, 20))).get().createEntity());
                    DurabilityCapability durabilityCap = new DurabilityCapability();
                    durabilityCap.setInfinite(true);
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.BRACELET, cap, durabilityCap) : new AdornmentCapabilityProvider(cap, durabilityCap);
                }
            };
            POCKET_WATCH = new NamedAdornment("treasure2", "pocket_watch", AdornmentType.POCKET, TreasureAdornmentRegistry.GREAT){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    ICharmableCapability cap = new CharmableCapability.Builder(0, 0, 2).with($ -> {
                        $.innate = false;
                        $.imbuable = false;
                        $.socketable = true;
                        $.source = false;
                        $.executing = true;
                        $.baseMaterial = TreasureCharmableMaterials.GOLD.getName();
                        $.sourceItem = AMETHYST.getRegistryName();
                        $.levelModifier = new GreatAdornmentLevelModifier();
                    }).build();
                    DurabilityCapability durabilityCap = new DurabilityCapability(1000, 1000, TreasureCharmableMaterials.GOLD);
                    IRunestonesCapability runestonesCap = new RunestonesCapability.Builder(0, 0, 2).with($ -> {
                        $.socketable = true;
                    }).build();
                    return BaublesIntegration.isEnabled() ? new BaublesIntegration.BaubleAdornmentCapabilityProvider(AdornmentType.POCKET, cap, runestonesCap, durabilityCap) : new AdornmentCapabilityProvider(cap, runestonesCap, durabilityCap);
                }
            };
            adornments.add(POCKET_WATCH);
            TreasureAdornmentRegistry.register(TreasureCharmableMaterials.GOLD.getName(), AMETHYST.getRegistryName(), POCKET_WATCH);
            ArrayList<CharmItem> charms = new ArrayList<CharmItem>();
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.COPPER, Items.field_190931_a));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.SILVER, Items.field_190931_a));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, Items.field_190931_a));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, AMETHYST));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, ONYX));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, Items.field_151045_i));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, Items.field_151166_bC));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, RUBY));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.GOLD, SAPPHIRE));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.LEGENDARY, Items.field_190931_a));
            charms.add(TreasureItems.createCharm(TreasureCharmableMaterials.MYTHICAL, Items.field_190931_a));
            MANA_RUNESTONE = new RunestoneItem("treasure2", "mana_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_MANA.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_MANA, MANA_RUNESTONE);
            GREATER_MANA_RUNESTONE = new RunestoneItem("treasure2", "greater_mana_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_GREATER_MANA.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_GREATER_MANA, GREATER_MANA_RUNESTONE);
            DURABILITY_RUNESTONE = new RunestoneItem("treasure2", "durability_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_DURABILITY.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_DURABILITY, DURABILITY_RUNESTONE);
            QUALITY_RUNESTONE = new RunestoneItem("treasure2", "quality_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_QUALITY.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_QUALITY, QUALITY_RUNESTONE);
            EQUIP_MANA_RUNESTONE = new RunestoneItem("treasure2", "equip_mana_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_EQUIP_AS_MANA.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_EQUIP_AS_MANA, EQUIP_MANA_RUNESTONE);
            ANVIL_RUNESTONE = new RunestoneItem("treasure2", "anvil_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_ANVIL.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_ANVIL, ANVIL_RUNESTONE);
            ANGELS_RUNESTONE = new RunestoneItem("treasure2", "angels_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_ANGELS.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_ANGELS, ANGELS_RUNESTONE);
            PERSISTENCE_RUNESTONE = new RunestoneItem("treasure2", "persistence_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_PERSISTENCE.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_PERSISTENCE, PERSISTENCE_RUNESTONE);
            SOCKETS_RUNESTONE = new RunestoneItem("treasure2", "sockets_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_SOCKETS.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_SOCKETS, SOCKETS_RUNESTONE);
            DOUBLE_CHARGE_RUNESTONE = new RunestoneItem("treasure2", "double_charge_runestone"){

                @Override
                public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
                    IRunestonesCapability cap = new RunestonesCapability.Builder(1, 0, 0).with($ -> {
                        $.bindable = true;
                    }).build();
                    cap.add(InventoryType.INNATE, TreasureRunes.RUNE_OF_DOUBLE_CHARGE.createEntity());
                    return new RunestonesCapabilityProvider(cap);
                }
            };
            TreasureRunes.register(TreasureRunes.RUNE_OF_DOUBLE_CHARGE, DOUBLE_CHARGE_RUNESTONE);
            ModSwordBuilder builder = new ModSwordBuilder();
            SKULL_SWORD = builder.withModID("treasure2").withName("skull_sword").withMaterial(SKULL_TOOL_MATERIAL).withRepairItem(Items.field_151103_aS).withCreativeTab(Treasure.TREASURE_TAB).build();
            ModArmorBuilder armorBuilder = new ModArmorBuilder();
            EYE_PATCH = armorBuilder.withModID("treasure2").withName("eye_patch").withMaterial(ItemArmor.ArmorMaterial.LEATHER).withRenderIndex(2).withSlot(EntityEquipmentSlot.HEAD).withTexture("textures/models/armor/eye_patch.png").withRepairItem(Items.field_151116_aA).withCreativeTab(Treasure.TREASURE_TAB).build();
            WITHER_STICK_ITEM = new WitherStickItem("treasure2", "wither_stick_item");
            WITHER_ROOT_ITEM = new WitherRootItem("treasure2", "wither_root_item");
            EXTRA_STRONG_HEALING = (PotionType)new PotionType("healing", new PotionEffect[]{new PotionEffect(MobEffects.field_76432_h, 1, 2)}).setRegistryName("treasure2", "extra_strong_healing");
            EXTRA_STRONG_STRENGTH = (PotionType)new PotionType("strength", new PotionEffect[]{new PotionEffect(MobEffects.field_76420_g, 1800, 2)}).setRegistryName("treasure2", "extra_strong_strength");
            EXTRA_STRONG_LEAPING = (PotionType)new PotionType("leaping", new PotionEffect[]{new PotionEffect(MobEffects.field_76430_j, 1800, 2)}).setRegistryName("treasure2", "extra_strong_leaping");
            EXTRA_STRONG_SWIFTNESS = (PotionType)new PotionType("swiftness", new PotionEffect[]{new PotionEffect(MobEffects.field_76424_c, 1800, 2)}).setRegistryName("treasure2", "extra_strong_swiftness");
            EXTRA_STRONG_REGENERATION = (PotionType)new PotionType("regeneration", new PotionEffect[]{new PotionEffect(MobEffects.field_76428_l, 450, 2)}).setRegistryName("treasure2", "extra_strong_regeneration");
            EXTRA_STRONG_POISON = (PotionType)new PotionType("poison", new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 432, 2)}).setRegistryName("treasure2", "extra_strong_poison");
            SPANISH_MOSS = new SpanishMossItem("treasure2", "spanish_moss");
            PAINTING_BLOCKS_DIRT = new PaintingItem("treasure2", "painting_blocks_dirt", Rarity.SCARCE).setPaintingName("Dirt").setCollectionName("Blocks").setCollectionIssue("1").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_COBBLESTONE = new PaintingItem("treasure2", "painting_blocks_cobblestone", Rarity.SCARCE).setPaintingName("Cobblestone").setCollectionName("Blocks").setCollectionIssue("2").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_WATER = new PaintingItem("treasure2", "painting_blocks_water", Rarity.SCARCE).setPaintingName("Water").setCollectionName("Blocks").setCollectionIssue("3").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_SAND = new PaintingItem("treasure2", "painting_blocks_sand", Rarity.RARE).setPaintingName("Sand").setCollectionName("Blocks").setCollectionIssue("4").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_WOOD = new PaintingItem("treasure2", "painting_blocks_wood", Rarity.RARE).setPaintingName("Wood").setCollectionName("Blocks").setCollectionIssue("5").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_BRICKS = new PaintingItem("treasure2", "painting_blocks_bricks", Rarity.EPIC).setPaintingName("Bricks").setCollectionName("Blocks").setCollectionIssue("6").setCollectionSize("7").setArtist("o2xygeno");
            PAINTING_BLOCKS_LAVA = new PaintingItem("treasure2", "painting_blocks_lava", Rarity.EPIC).setPaintingName("Lava").setCollectionName("Blocks").setCollectionIssue("7").setCollectionSize("7").setArtist("o2xygeno");
            SKELETON = new SkeletonItem("treasure2", "skeleton");
            TREASURE_TOOL = new TreasureToolItem("treasure2", "treasure_tool");
            IForgeRegistry registry = event.getRegistry();
            Item[] items = new Item[]{TREASURE_TAB, ADORNMENTS_TAB, COPPER_COIN, SILVER_COIN, GOLD_COIN, MEDICS_TOKEN, SALANDAARS_WARD, ADEPHAGIAS_BOUNTY, MIRTHAS_TORCH, ANGELS_RING, RING_OF_FORTITUDE, BRACELET_OF_WONDER, GOTTSCHS_RING_OF_MOON, GOTTSCHS_AMULET_OF_HEAVENS, SHADOWS_GIFT, RING_OF_LIFE_DEATH, CASTLE_RING, PEASANTS_FORTUNE, WHITE_PEARL, BLACK_PEARL, WOOD_LOCK, STONE_LOCK, EMBER_LOCK, LEAF_LOCK, IRON_LOCK, GOLD_LOCK, DIAMOND_LOCK, EMERALD_LOCK, RUBY_LOCK, SAPPHIRE_LOCK, SPIDER_LOCK, WITHER_LOCK, WOOD_KEY, STONE_KEY, EMBER_KEY, LEAF_KEY, LIGHTNING_KEY, IRON_KEY, GOLD_KEY, DIAMOND_KEY, EMERALD_KEY, RUBY_KEY, SAPPHIRE_KEY, JEWELLED_KEY, METALLURGISTS_KEY, SKELETON_KEY, SPIDER_KEY, WITHER_KEY, PILFERERS_LOCK_PICK, THIEFS_LOCK_PICK, KEY_RING, POUCH, SKULL_SWORD, EYE_PATCH, WITHER_STICK_ITEM, WITHER_ROOT_ITEM, SPANISH_MOSS, TREASURE_TOOL, PAINTING_BLOCKS_BRICKS, PAINTING_BLOCKS_COBBLESTONE, PAINTING_BLOCKS_DIRT, PAINTING_BLOCKS_LAVA, PAINTING_BLOCKS_SAND, PAINTING_BLOCKS_WATER, PAINTING_BLOCKS_WOOD, AMETHYST, ONYX, SAPPHIRE, RUBY, CHARM_BOOK, MANA_RUNESTONE, GREATER_MANA_RUNESTONE, DURABILITY_RUNESTONE, QUALITY_RUNESTONE, EQUIP_MANA_RUNESTONE, ANVIL_RUNESTONE, ANGELS_RUNESTONE, PERSISTENCE_RUNESTONE, SOCKETS_RUNESTONE, DOUBLE_CHARGE_RUNESTONE, SKELETON};
            registry.registerAll((IForgeRegistryEntry[])items);
            charms.forEach(charm -> {
                ITEMS.put(charm.getRegistryName(), (Item)charm);
                CHARM_ITEMS.put(charm.getRegistryName(), (CharmItem)((Object)charm));
                registry.register((IForgeRegistryEntry)charm);
            });
            adornments.forEach(a -> {
                ITEMS.put(a.getRegistryName(), (Item)a);
                ADORNMENT_ITEMS.put(a.getRegistryName(), (Adornment)((Object)a));
                registry.register((IForgeRegistryEntry)a);
            });
            OreDictionary.registerOre((String)"amethyst", (Item)AMETHYST);
            OreDictionary.registerOre((String)"onyx", (Item)ONYX);
            OreDictionary.registerOre((String)"gemAmethyst", (Item)AMETHYST);
            OreDictionary.registerOre((String)"gemOnyx", (Item)ONYX);
            OreDictionary.registerOre((String)"sapphire", (Item)SAPPHIRE);
            OreDictionary.registerOre((String)"ruby", (Item)RUBY);
            OreDictionary.registerOre((String)"gemSapphire", (Item)SAPPHIRE);
            OreDictionary.registerOre((String)"gemRuby", (Item)RUBY);
        }
    }

    @Mod.EventBusSubscriber(modid="treasure2")
    public static class PotionRegistrationHandler {
        @SubscribeEvent
        public static void registerPotions(RegistryEvent.Register<PotionType> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_HEALING);
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_LEAPING);
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_POISON);
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_REGENERATION);
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_STRENGTH);
            registry.register((IForgeRegistryEntry)EXTRA_STRONG_SWIFTNESS);
        }
    }
}

