/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class PaintingItem
extends ModItem {
    private String paintingName;
    private String collectionName;
    private String collectionIssue;
    private String collectionSize;
    private String artist;
    private Rarity rarity;
    private Block paintingBlock;

    public PaintingItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.setRarity(Rarity.SCARCE);
    }

    public PaintingItem(String modID, String name, Rarity rarity) {
        this(modID, name);
        this.setRarity(rarity);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.rarity", (Object[])new Object[]{TextFormatting.DARK_BLUE + this.getRarity().toString()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.painting.collection", (Object[])new Object[]{TextFormatting.GOLD + this.getCollectionName()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.painting.issue", (Object[])new Object[]{this.getCollectionIssue(), this.getCollectionSize()}));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (WorldInfo.isClientSide(worldIn)) {
            return EnumActionResult.PASS;
        }
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return EnumActionResult.PASS;
        }
        Block block = this.getPaintingBlock();
        BlockPos p = null;
        switch (facing) {
            case SOUTH: {
                p = pos.func_177968_d();
                break;
            }
            case WEST: {
                p = pos.func_177976_e();
                break;
            }
            case NORTH: {
                p = pos.func_177978_c();
                break;
            }
            case EAST: {
                p = pos.func_177974_f();
                break;
            }
            default: {
                p = pos.func_177978_c();
            }
        }
        ItemStack heldItem = player.func_184586_b(hand);
        this.placeBlock(worldIn, p, block, player, heldItem);
        heldItem.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    public void placeBlock(World world, BlockPos pos, Block block, EntityPlayer player, ItemStack itemStack) {
        if (block.func_176196_c(world, pos)) {
            world.func_175656_a(pos, block.func_176223_P());
            block.func_180633_a(world, pos, block.func_176223_P(), (EntityLivingBase)player, itemStack);
        }
    }

    public Block getPaintingBlock() {
        return this.paintingBlock;
    }

    public PaintingItem setPaintingBlock(Block paintingBlock) {
        this.paintingBlock = paintingBlock;
        return this;
    }

    public String getPaintingName() {
        return this.paintingName;
    }

    public PaintingItem setPaintingName(String paintingName) {
        this.paintingName = paintingName;
        return this;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public PaintingItem setCollectionName(String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    public String getCollectionIssue() {
        return this.collectionIssue;
    }

    public PaintingItem setCollectionIssue(String collectionIssue) {
        this.collectionIssue = collectionIssue;
        return this;
    }

    public String getCollectionSize() {
        return this.collectionSize;
    }

    public PaintingItem setCollectionSize(String collectionSize) {
        this.collectionSize = collectionSize;
        return this;
    }

    public String getArtist() {
        return this.artist;
    }

    public PaintingItem setArtist(String artist) {
        this.artist = artist;
        return this;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }
}

