/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.loot.LootPoolShell;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.IWishingWellBlock;
import com.someguyssoftware.treasure2.enums.Coins;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.wish.IWishable;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

@Deprecated
public class CoinItem
extends ModItem
implements IWishable {
    private static final int MAX_CUSTOM_STACK_SIZE = 64;
    public static final int MAX_STACK_SIZE = 8;
    private Coins coin;

    public CoinItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.coin = Coins.GOLD;
    }

    public CoinItem(String modID, String name, Coins coin) {
        this(modID, name);
        this.setCoin(coin);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.GOLD + "" + TextFormatting.ITALIC + I18n.func_74838_a((String)"tooltip.label.coin"));
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        ItemStack entityItemStack = entityItem.func_92059_d();
        World world = entityItem.func_130014_f_();
        if (WorldInfo.isClientSide(world)) {
            return super.onEntityItemUpdate(entityItem);
        }
        Coords coords = new Coords(entityItem.func_180425_c());
        Cube cube = new Cube(world, coords);
        int numWishingWellBlocks = 0;
        if (cube.equalsBlock((Block)Blocks.field_150355_j)) {
            ICoords checkCoords = coords.add(-1, 0, -1);
            block0: for (int z = 0; z < 3; ++z) {
                for (int x = 0; x < 3; ++x) {
                    Cube checkCube = new Cube(world, checkCoords);
                    if (checkCube.toBlock() instanceof IWishingWellBlock) {
                        ++numWishingWellBlocks;
                    }
                    if (numWishingWellBlocks >= 2) continue block0;
                }
            }
            if (numWishingWellBlocks >= 2) {
                Random random = new Random();
                for (int itemIndex = 0; itemIndex < entityItemStack.func_190916_E(); ++itemIndex) {
                    this.generateLootItem(world, random, entityItem, coords);
                }
                return true;
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    private void generateLootItem(World world, Random random, EntityItem entityItem, ICoords coords) {
        ItemStack coinItem = entityItem.func_92059_d();
        NBTTagCompound nbt = coinItem.func_77978_p();
        ArrayList<LootTableShell> lootTables = new ArrayList<LootTableShell>();
        if (this.getCoin() == Coins.SILVER) {
            lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.UNCOMMON));
            lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.SCARCE));
        } else if (this.getCoin() == Coins.GOLD) {
            lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.SCARCE));
            lootTables.addAll(TreasureLootTableRegistry.getLootTableMaster().getLootTableByRarity(Rarity.RARE));
        }
        ItemStack stack = null;
        if (lootTables == null || lootTables.size() == 0) {
            stack = new ItemStack(Items.field_151034_e);
        } else {
            EntityPlayer player = null;
            if (nbt != null && nbt.func_74764_b("droppedBy")) {
                Treasure.LOGGER.debug("dropped by key ->{}", (Object)nbt.func_74779_i("droppedBy"));
                player = Optional.of(world.func_152378_a(UUID.fromString(nbt.func_74779_i("droppedBy")))).orElseGet(() -> {
                    Treasure.LOGGER.debug("getting player by name");
                    return world.func_72924_a(nbt.func_74779_i("droppedBy"));
                });
                if (player != null && Treasure.LOGGER.isDebugEnabled()) {
                    Treasure.LOGGER.debug("coin dropped by player -> {}", (Object)player.func_70005_c_());
                }
            }
            LootContext lootContext = this.getLootContext(world, player);
            LootTableShell tableShell = (LootTableShell)lootTables.get(RandomHelper.randomInt(random, 0, lootTables.size() - 1));
            if (tableShell.getResourceLocation() == null) {
                return;
            }
            LootTable table = world.func_184146_ak().func_186521_a(tableShell.getResourceLocation());
            List<LootPoolShell> lootPoolShells = tableShell.getPools();
            ArrayList itemStacks = new ArrayList();
            for (LootPoolShell pool : lootPoolShells) {
                Treasure.LOGGER.debug("coin: processing pool -> {}", (Object)pool.getName());
                LootPool lootPool = table.getPool(pool.getName());
                lootPool.func_186449_b(itemStacks, random, lootContext);
            }
            Rarity effectiveRarity = TreasureLootTableRegistry.getLootTableMaster().getEffectiveRarity(tableShell, this.getCoin() == Coins.SILVER ? Rarity.UNCOMMON : Rarity.SCARCE);
            Treasure.LOGGER.debug("coin: using effective rarity -> {}", (Object)effectiveRarity);
            Treasure.LOGGER.debug("coin: searching for injectable tables for category ->{}, rarity -> {}", (Object)tableShell.getCategory(), (Object)effectiveRarity);
            Optional injectLootTableShells = this.buildInjectedLootTableList(tableShell.getCategory(), effectiveRarity);
            if (injectLootTableShells.isPresent()) {
                Treasure.LOGGER.debug("coin: found injectable tables for category ->{}, rarity -> {}", (Object)tableShell.getCategory(), (Object)effectiveRarity);
                Treasure.LOGGER.debug("coin: size of injectable tables -> {}", (Object)((List)injectLootTableShells.get()).size());
                itemStacks.addAll(this.getLootItems(world, random, (List)injectLootTableShells.get(), lootContext));
            }
            stack = (ItemStack)itemStacks.get(RandomHelper.randomInt(0, itemStacks.size() - 1));
        }
        if (stack != null) {
            InventoryHelper.func_180173_a((World)world, (double)coords.getX(), (double)((double)coords.getY() + 1.0), (double)coords.getZ(), (ItemStack)stack);
        }
        entityItem.func_70106_y();
    }

    public Coins getCoin() {
        return this.coin;
    }

    public CoinItem setCoin(Coins coin) {
        this.coin = coin;
        return this;
    }
}

