/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class StandardChestContainer
extends Container {
    private IInventory inventory;
    private final int HOTBAR_SLOT_COUNT = 9;
    private final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private final int VANILLA_SLOT_COUNT = 36;
    private final int VANILLA_FIRST_SLOT_INDEX = 0;
    private final int CONTAINER_INVENTORY_FIRST_SLOT_INDEX = 36;
    private final int CONTAINER_INVENTORY_ROW_COUNT = 3;
    private final int CONTAINER_INVENTORY_COLUMN_COUNT = 9;
    private final int CONTAINER_INVENTORY_SLOT_COUNT = 27;

    public StandardChestContainer(InventoryPlayer invPlayer, IInventory inventory) {
        this.inventory = inventory;
        inventory.func_174889_b(invPlayer.field_70458_d);
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 8;
        int HOTBAR_YPOS = 142;
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, 8 + 18 * x, 142));
        }
        int PLAYER_INVENTORY_XPOS = 8;
        int PLAYER_INVENTORY_YPOS = 84;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.func_75146_a(new Slot((IInventory)invPlayer, slotNumber, xpos, ypos));
            }
        }
        if (27 != inventory.func_70302_i_()) {
            System.err.println("Mismatched slot count in ContainerBasic(27) and TileInventory (" + inventory.func_70302_i_() + ")");
        }
        int TILE_INVENTORY_XPOS = 8;
        int TILE_INVENTORY_YPOS = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 18 + y * 18;
                this.func_75146_a(new Slot(inventory, slotNumber, xpos, ypos));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.inventory.func_94041_b(sourceSlotIndex, sourceStack)) {
                return ItemStack.field_190927_a;
            }
            if (!this.func_75135_a(sourceStack, 36, 63, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 63) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            System.err.print("Invalid slotIndex:" + sourceSlotIndex);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public IInventory getChestInventory() {
        return this.inventory;
    }

    public void setChestInventory(IInventory inventory) {
        this.inventory = inventory;
    }
}

