/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class JewelerBenchContainer
extends Container {
    private final IInventory outputSlot = new InventoryCraftResult();
    private final IInventory removeGemOutputSlot = new InventoryCraftResult();
    private final IInventory removeAdornmentOutputSlot = new InventoryCraftResult();
    private final IInventory inputSlots = new InventoryBasic("Repair", true, 4){

        public void func_70296_d() {
            super.func_70296_d();
            JewelerBenchContainer.this.func_75130_a((IInventory)this);
        }
    };
    private BlockPos selfPosition;
    private World world;
    private EntityPlayer player;
    public int maximumCost;
    public int materialCost;
    private String repairedItemName;

    public JewelerBenchContainer(InventoryPlayer playerInventory, World world, EntityPlayer player) {
        this(playerInventory, world, BlockPos.field_177992_a, player);
    }

    public JewelerBenchContainer(InventoryPlayer playerInventory, World world, BlockPos pos, EntityPlayer player) {
        this.selfPosition = pos;
        this.world = world;
        this.player = player;
        this.func_75146_a(new Slot(this.inputSlots, 0, 38, 18){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof Adornment;
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, 1, 87, 18){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof Adornment || TreasureCharmableMaterials.isSourceItemRegistered(stack.func_77973_b().getRegistryName());
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, 2, 38, 37){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof Adornment;
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, 3, 38, 56){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof Adornment;
            }
        });
        this.func_75146_a(new Slot(this.outputSlot, 4, 145, 18){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= JewelerBenchContainer.this.maximumCost) && JewelerBenchContainer.this.maximumCost > 0 && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-JewelerBenchContainer.this.maximumCost);
                }
                JewelerBenchContainer.this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
                if (JewelerBenchContainer.this.materialCost > 0) {
                    ItemStack itemStack = JewelerBenchContainer.this.inputSlots.func_70301_a(1);
                    if (!itemStack.func_190926_b() && itemStack.func_190916_E() > JewelerBenchContainer.this.materialCost) {
                        itemStack.func_190918_g(JewelerBenchContainer.this.materialCost);
                        JewelerBenchContainer.this.inputSlots.func_70299_a(1, itemStack);
                    } else {
                        JewelerBenchContainer.this.inputSlots.func_70299_a(1, ItemStack.field_190927_a);
                    }
                } else {
                    JewelerBenchContainer.this.inputSlots.func_70299_a(1, ItemStack.field_190927_a);
                }
                JewelerBenchContainer.this.maximumCost = 0;
                JewelerBenchContainer.this.playUseSound();
                return stack;
            }
        });
        this.func_75146_a(new Slot(this.removeGemOutputSlot, 5, 145, 37){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= JewelerBenchContainer.this.maximumCost) && JewelerBenchContainer.this.maximumCost > 0 && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-JewelerBenchContainer.this.maximumCost);
                }
                JewelerBenchContainer.this.inputSlots.func_70299_a(2, ItemStack.field_190927_a);
                JewelerBenchContainer.this.maximumCost = 0;
                JewelerBenchContainer.this.playUseSound();
                return stack;
            }
        });
        this.func_75146_a(new Slot(this.removeAdornmentOutputSlot, 6, 145, 56){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= JewelerBenchContainer.this.maximumCost) && JewelerBenchContainer.this.maximumCost > 0 && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-JewelerBenchContainer.this.maximumCost);
                }
                JewelerBenchContainer.this.inputSlots.func_70299_a(3, ItemStack.field_190927_a);
                JewelerBenchContainer.this.maximumCost = 0;
                JewelerBenchContainer.this.playUseSound();
                return stack;
            }
        });
        for (int yIndex = 0; yIndex < 3; ++yIndex) {
            for (int xIndex = 0; xIndex < 9; ++xIndex) {
                this.func_75146_a(new Slot((IInventory)playerInventory, xIndex + yIndex * 9 + 9, 7 + xIndex * 18, 84 + yIndex * 18));
            }
        }
        for (int xIndex = 0; xIndex < 9; ++xIndex) {
            this.func_75146_a(new Slot((IInventory)playerInventory, xIndex, 7 + xIndex * 18, 142));
        }
    }

    protected void playUseSound() {
        this.world.func_184148_a((EntityPlayer)null, (double)this.selfPosition.func_177958_n() + 0.5, (double)this.selfPosition.func_177956_o() + 0.5, (double)this.selfPosition.func_177952_p() + 0.5, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, this.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory == this.inputSlots) {
            this.updateOutput();
        }
    }

    public void updateOutput() {
        this.maximumCost = 0;
        ItemStack itemStack = this.inputSlots.func_70301_a(0);
        if (itemStack.func_190926_b()) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            ICharmableCapability cap;
            this.maximumCost = 1;
            ItemStack itemStack2 = this.inputSlots.func_70301_a(1);
            if (itemStack2.func_190926_b()) {
                this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            } else if (itemStack.func_77973_b() instanceof Adornment && itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && TreasureCharmableMaterials.isSourceItemRegistered(itemStack2.func_77973_b().getRegistryName()) && (cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem().equals((Object)Items.field_190931_a.getRegistryName())) {
                this.materialCost = 1;
                Optional<Adornment> adornment = TreasureAdornmentRegistry.getAdornment(itemStack, itemStack2);
                Treasure.LOGGER.debug("adornment -> {}", (Object)adornment.get().getRegistryName());
                if (adornment.isPresent()) {
                    ItemStack outputStack = TreasureAdornmentRegistry.copyStack(itemStack, new ItemStack((Item)adornment.get()));
                    ICharmableCapability outputCap = (ICharmableCapability)outputStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                    outputCap.setHighestLevel(cap.getHighestLevel());
                    this.outputSlot.func_70299_a(0, outputStack);
                }
            }
        }
        ItemStack removeGemItemStack = this.inputSlots.func_70301_a(2);
        if (removeGemItemStack.func_190926_b()) {
            this.removeGemOutputSlot.func_70299_a(0, ItemStack.field_190927_a);
        } else if (removeGemItemStack.func_77973_b() instanceof Adornment && removeGemItemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && TreasureCharmableMaterials.isSourceItemRegistered(((ICharmableCapability)removeGemItemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem())) {
            this.maximumCost = 1;
            Adornment adornment = (Adornment)removeGemItemStack.func_77973_b();
            Optional<Adornment> baseAdornment = TreasureAdornmentRegistry.get(adornment.getType(), adornment.getSize(), ((ICharmableCapability)removeGemItemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getBaseMaterial(), Items.field_190931_a.getRegistryName());
            if (baseAdornment.isPresent()) {
                this.removeGemOutputSlot.func_70299_a(0, new ItemStack((Item)baseAdornment.get()));
            }
        }
        ItemStack removeAdornmentItemStack = this.inputSlots.func_70301_a(3);
        if (removeAdornmentItemStack.func_190926_b()) {
            this.removeAdornmentOutputSlot.func_70299_a(0, ItemStack.field_190927_a);
        } else if (removeAdornmentItemStack.func_77973_b() instanceof Adornment && removeAdornmentItemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && TreasureCharmableMaterials.isSourceItemRegistered(((ICharmableCapability)removeAdornmentItemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem())) {
            this.maximumCost = 1;
            Item gem = (Item)ForgeRegistries.ITEMS.getValue(((ICharmableCapability)removeAdornmentItemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem());
            this.removeAdornmentOutputSlot.func_70299_a(0, new ItemStack(gem));
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!WorldInfo.isClientSide(this.world)) {
            this.func_193327_a(player, this.world, this.inputSlots);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.selfPosition).func_177230_c() != TreasureBlocks.JEWELER_BENCH) {
            return false;
        }
        return playerIn.func_70092_e((double)this.selfPosition.func_177958_n() + 0.5, (double)this.selfPosition.func_177956_o() + 0.5, (double)this.selfPosition.func_177952_p() + 0.5) <= 64.0;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }
}

