/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.adornment.TreasureAdornmentRegistry;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.TreasureCharms;
import com.someguyssoftware.treasure2.inventory.MultilineInventoryCraftResult;
import com.someguyssoftware.treasure2.item.Adornment;
import com.someguyssoftware.treasure2.item.CharmItem;
import com.someguyssoftware.treasure2.item.RunestoneItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import com.someguyssoftware.treasure2.rune.IRuneEntity;
import com.someguyssoftware.treasure2.rune.TreasureRunes;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CharmingTableContainer
extends Container {
    private IInventory inputSlots;
    private IInventory outputSlot;
    private IInventory charmInputSlots1;
    private IInventory charmInputSlots2;
    private IInventory[] charmOutputSlots;
    private IInventory runeInputSlot1;
    private IInventory runeInputSlot2;
    private IInventory runeOutputSlot;
    private BlockPos selfPosition;
    private World world;
    public int maximumCost;
    public int materialCost;

    public CharmingTableContainer(InventoryPlayer playerInventory, World world, EntityPlayer player) {
        this(playerInventory, world, BlockPos.field_177992_a, player);
    }

    public CharmingTableContainer(InventoryPlayer playerInventory, World world, BlockPos pos, EntityPlayer player) {
        try {
            this.setupSlots();
            this.setupCharmSlots();
            this.setupRuneSlots();
        }
        catch (Exception e) {
            Treasure.LOGGER.debug("error:", (Throwable)e);
        }
        this.selfPosition = pos;
        this.world = world;
        for (int xIndex = 0; xIndex < 9; ++xIndex) {
            this.func_75146_a(new Slot((IInventory)playerInventory, xIndex, 8 + xIndex * 18, 232));
        }
        for (int yIndex = 0; yIndex < 3; ++yIndex) {
            for (int xIndex = 0; xIndex < 9; ++xIndex) {
                this.func_75146_a(new Slot((IInventory)playerInventory, xIndex + yIndex * 9 + 9, 8 + xIndex * 18, 174 + yIndex * 18));
            }
        }
    }

    private void setupSlots() {
        this.outputSlot = new InventoryCraftResult();
        this.inputSlots = new InventoryBasic("Repair", true, 2){

            public void func_70296_d() {
                super.func_70296_d();
                CharmingTableContainer.this.func_75130_a((IInventory)this);
            }
        };
        this.func_75146_a(new Slot(this.inputSlots, 0, 27, 18){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof CharmItem || stack.func_77973_b() instanceof Adornment;
            }
        });
        this.func_75146_a(new Slot(this.inputSlots, 1, 76, 18){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() instanceof CharmItem || stack.func_77973_b() instanceof RunestoneItem || TreasureCharmableMaterials.isSourceItemRegistered(stack.func_77973_b().getRegistryName());
            }
        });
        this.func_75146_a(new Slot(this.outputSlot, 2, 134, 18){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= CharmingTableContainer.this.maximumCost) && CharmingTableContainer.this.maximumCost > 0 && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-CharmingTableContainer.this.maximumCost);
                }
                CharmingTableContainer.this.clearSlotsWhenOutputTaken();
                CharmingTableContainer.this.maximumCost = 0;
                CharmingTableContainer.this.playUseSound();
                return stack;
            }
        });
    }

    private void setupCharmSlots() {
        int i;
        this.charmInputSlots1 = new InventoryBasic("Charm", true, 4);
        this.charmInputSlots2 = new InventoryBasic("Charm2", true, 4){

            public void func_70296_d() {
                super.func_70296_d();
                CharmingTableContainer.this.func_75130_a((IInventory)this);
            }
        };
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new Slot(this.charmInputSlots1, i, 27, 51 + i * 19){

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }

                public boolean func_82869_a(EntityPlayer player) {
                    return false;
                }
            });
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new Slot(this.charmInputSlots2, i, 76, 51 + i * 19){

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b() == TreasureItems.TREASURE_TOOL || TreasureCharmableMaterials.isSourceItemRegistered(stack.func_77973_b().getRegistryName());
                }
            });
        }
        this.charmOutputSlots = new InventoryCraftResult[4];
        for (i = 0; i < 4; ++i) {
            this.charmOutputSlots[i] = new MultilineInventoryCraftResult(i);
            this.func_75146_a(new Slot(this.charmOutputSlots[i], 0, 134, 51 + i * 19){

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }

                public boolean func_82869_a(EntityPlayer player) {
                    return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= CharmingTableContainer.this.maximumCost) && CharmingTableContainer.this.maximumCost > 0 && this.func_75216_d();
                }

                public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                    Treasure.LOGGER.debug("attempting to take itemstack from slot # -> {}", (Object)this.getSlotIndex());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.func_82242_a(-CharmingTableContainer.this.maximumCost);
                    }
                    CharmingTableContainer.this.clearSlotsWhenCharmOutputTaken(((MultilineInventoryCraftResult)this.field_75224_c).getLine());
                    CharmingTableContainer.this.maximumCost = 0;
                    CharmingTableContainer.this.playUseSound();
                    return stack;
                }
            });
        }
    }

    private void setupRuneSlots() {
        this.runeOutputSlot = new InventoryCraftResult();
        this.runeInputSlot1 = new InventoryBasic("Rune", true, 1);
        this.runeInputSlot2 = new InventoryBasic("Rune2", true, 1){

            public void func_70296_d() {
                super.func_70296_d();
                CharmingTableContainer.this.func_75130_a((IInventory)this);
            }
        };
        this.func_75146_a(new Slot(this.runeInputSlot1, 0, 27, 142){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return false;
            }
        });
        this.func_75146_a(new Slot(this.runeInputSlot2, 0, 76, 142){

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_77973_b() == TreasureItems.TREASURE_TOOL;
            }
        });
        this.func_75146_a(new Slot(this.runeOutputSlot, 0, 134, 142){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player) {
                return (player.field_71075_bZ.field_75098_d || player.field_71068_ca >= CharmingTableContainer.this.maximumCost) && CharmingTableContainer.this.maximumCost > 0 && this.func_75216_d();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-CharmingTableContainer.this.maximumCost);
                }
                CharmingTableContainer.this.clearSlotsWhenRunesOutputTaken();
                CharmingTableContainer.this.maximumCost = 0;
                CharmingTableContainer.this.playUseSound();
                return stack;
            }
        });
    }

    protected void clearAllSlots() {
        this.inputSlots.func_174888_l();
        this.charmInputSlots1.func_174888_l();
        this.charmInputSlots2.func_174888_l();
        this.runeInputSlot1.func_174888_l();
        this.runeInputSlot2.func_174888_l();
        this.outputSlot.func_174888_l();
        for (int i = 0; i < this.charmOutputSlots.length; ++i) {
            this.charmOutputSlots[i].func_174888_l();
        }
        this.runeOutputSlot.func_174888_l();
    }

    protected void clearSlotsWhenOutputTaken() {
        this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
        if (this.materialCost > 0) {
            ItemStack itemStack = this.inputSlots.func_70301_a(1);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.materialCost) {
                itemStack.func_190918_g(this.materialCost);
                this.inputSlots.func_70299_a(1, itemStack);
            } else {
                this.inputSlots.func_70299_a(1, ItemStack.field_190927_a);
            }
        } else {
            this.inputSlots.func_70299_a(1, ItemStack.field_190927_a);
        }
        this.outputSlot.func_174888_l();
        this.charmInputSlots1.func_174888_l();
        for (int i = 0; i < this.charmOutputSlots.length; ++i) {
            this.charmOutputSlots[i].func_174888_l();
        }
        this.runeInputSlot1.func_174888_l();
        this.runeOutputSlot.func_174888_l();
    }

    protected void clearSlotsWhenCharmOutputTaken(int index) {
        Treasure.LOGGER.debug("clearing charm on output taken, index -> {}", (Object)index);
        Treasure.LOGGER.debug("material cost -> {}", (Object)this.materialCost);
        this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
        this.outputSlot.func_174888_l();
        this.charmInputSlots1.func_174888_l();
        if (this.materialCost > 0) {
            ItemStack itemStack = this.charmInputSlots2.func_70301_a(index);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.materialCost) {
                itemStack.func_190918_g(this.materialCost);
                this.charmInputSlots2.func_70299_a(index, itemStack);
            } else {
                this.charmInputSlots2.func_70299_a(index, ItemStack.field_190927_a);
            }
        } else {
            this.charmInputSlots2.func_70299_a(index, ItemStack.field_190927_a);
        }
        for (int i = 0; i < this.charmOutputSlots.length; ++i) {
            this.charmOutputSlots[i].func_174888_l();
        }
        this.runeInputSlot1.func_174888_l();
        this.runeOutputSlot.func_174888_l();
    }

    protected void clearSlotsWhenRunesOutputTaken() {
        this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
        this.outputSlot.func_174888_l();
        this.charmInputSlots1.func_174888_l();
        for (int i = 0; i < this.charmOutputSlots.length; ++i) {
            this.charmOutputSlots[i].func_174888_l();
        }
        this.runeInputSlot1.func_174888_l();
        this.runeInputSlot2.func_174888_l();
        if (this.materialCost > 0) {
            ItemStack itemStack = this.runeInputSlot2.func_70301_a(0);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.materialCost) {
                itemStack.func_190918_g(this.materialCost);
                this.runeInputSlot2.func_70299_a(0, itemStack);
            } else {
                this.runeInputSlot2.func_70299_a(0, ItemStack.field_190927_a);
            }
        } else {
            this.runeInputSlot2.func_70299_a(0, ItemStack.field_190927_a);
        }
        this.runeOutputSlot.func_174888_l();
    }

    protected void playUseSound() {
        this.world.func_184148_a((EntityPlayer)null, (double)this.selfPosition.func_177958_n() + 0.5, (double)this.selfPosition.func_177956_o() + 0.5, (double)this.selfPosition.func_177952_p() + 0.5, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, this.world.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory == this.inputSlots || inventory == this.charmInputSlots2 || inventory == this.runeInputSlot2) {
            this.updateOutput();
        }
    }

    public void updateOutput() {
        this.maximumCost = 0;
        this.materialCost = 1;
        ItemStack itemStack = this.inputSlots.func_70301_a(0);
        if (itemStack.func_190926_b()) {
            this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            for (int i = 0; i < 4; ++i) {
                this.charmInputSlots1.func_70299_a(i, ItemStack.field_190927_a);
                this.charmOutputSlots[i].func_70299_a(0, ItemStack.field_190927_a);
            }
            this.runeInputSlot1.func_70299_a(0, ItemStack.field_190927_a);
            this.runeOutputSlot.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            Object entity2;
            Object cap;
            ItemStack stack;
            ItemStack stack2;
            Optional<ItemStack> outStack;
            Object cap2;
            ItemStack runeStack2;
            this.maximumCost = 1;
            ItemStack itemStack2 = this.inputSlots.func_70301_a(1);
            if (itemStack2.func_190926_b()) {
                this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
            }
            if (itemStack.func_77973_b() instanceof Adornment) {
                Optional<Item> item;
                IRunestonesCapability runestoneCap;
                ICharmableCapability charmableCap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                if (charmableCap != null && charmableCap.getCharmEntities().get((Object)InventoryType.SOCKET).size() > 0 && charmableCap.getCharmEntities().get((Object)InventoryType.SOCKET).size() <= 4) {
                    int index = 0;
                    ResourceLocation resource = new ResourceLocation("treasure2", "gold_charm");
                    for (ICharmEntity charm : charmableCap.getCharmEntities().get((Object)InventoryType.SOCKET)) {
                        ItemStack charmStack = new ItemStack(TreasureItems.ITEMS.get(resource));
                        ICharmEntity entity3 = charm.getCharm().createEntity(charm);
                        ((List)((ICharmableCapability)charmStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getCharmEntities().get((Object)InventoryType.INNATE)).set(0, entity3);
                        this.charmInputSlots1.func_70299_a(index, charmStack);
                        ++index;
                    }
                }
                if ((runestoneCap = (IRunestonesCapability)itemStack.getCapability(TreasureCapabilities.RUNESTONES, null)) != null && runestoneCap.getEntities(InventoryType.SOCKET).size() > 0 && (item = TreasureRunes.getItem(runestoneCap.getEntities(InventoryType.SOCKET).get(0).getRunestone())).isPresent()) {
                    this.runeInputSlot1.func_70299_a(0, new ItemStack(item.get()));
                }
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.charmInputSlots1.func_70301_a(i).func_190926_b() && !this.charmInputSlots2.func_70301_a(i).func_190926_b()) continue;
                this.charmOutputSlots[i].func_70299_a(0, ItemStack.field_190927_a);
            }
            ItemStack runeStack = this.runeInputSlot1.func_70301_a(0);
            if (runeStack.func_190926_b()) {
                this.runeOutputSlot.func_70299_a(0, ItemStack.field_190927_a);
            }
            if ((runeStack2 = this.runeInputSlot2.func_70301_a(0)).func_190926_b()) {
                this.runeOutputSlot.func_70299_a(0, ItemStack.field_190927_a);
            }
            if (itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && itemStack2.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isSocketable() && ((ICharmableCapability)itemStack2.getCapability(TreasureCapabilities.CHARMABLE, null)).isBindable()) {
                cap2 = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                if (cap2.hasCharmType(itemStack2, itemStack, InventoryType.INNATE, InventoryType.SOCKET)) {
                    return;
                }
                if (cap2.getCharmEntities().get((Object)InventoryType.SOCKET).size() < cap2.getMaxSocketSize() && (outStack = TreasureAdornmentRegistry.transferCapabilities(itemStack2, itemStack, InventoryType.INNATE, InventoryType.SOCKET)).isPresent()) {
                    if (outStack.get().hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                        ((IRunestonesCapability)outStack.get().getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(entity -> entity.getRunestone().apply((ItemStack)outStack.get(), (IRuneEntity)entity));
                    }
                    this.outputSlot.func_70299_a(0, outStack.get());
                }
            }
            if (itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && itemStack2.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isImbuable() && ((ICharmableCapability)itemStack2.getCapability(TreasureCapabilities.CHARMABLE, null)).isImbuing()) {
                cap2 = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                if (cap2.hasCharmType(itemStack2, itemStack, InventoryType.INNATE, InventoryType.IMBUE)) {
                    return;
                }
                if (cap2.getCharmEntities().get((Object)InventoryType.IMBUE).size() < cap2.getMaxImbueSize() && (outStack = TreasureAdornmentRegistry.transferCapabilities(itemStack2, itemStack, InventoryType.INNATE, InventoryType.IMBUE)).isPresent()) {
                    if (outStack.get().hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                        ((IRunestonesCapability)outStack.get().getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(entity -> entity.getRunestone().apply((ItemStack)outStack.get(), (IRuneEntity)entity));
                    }
                    this.outputSlot.func_70299_a(0, outStack.get());
                }
            } else if (itemStack.hasCapability(TreasureCapabilities.RUNESTONES, null) && itemStack2.hasCapability(TreasureCapabilities.RUNESTONES, null) && ((IRunestonesCapability)itemStack.getCapability(TreasureCapabilities.RUNESTONES, null)).isSocketable() && ((IRunestonesCapability)itemStack2.getCapability(TreasureCapabilities.RUNESTONES, null)).isBindable()) {
                cap2 = (IRunestonesCapability)itemStack.getCapability(TreasureCapabilities.RUNESTONES, null);
                if (cap2.getEntities(InventoryType.SOCKET).size() < cap2.getMaxSize(InventoryType.SOCKET) && (stack2 = TreasureAdornmentRegistry.transferCapabilities(itemStack2, itemStack, InventoryType.INNATE, InventoryType.SOCKET)).isPresent()) {
                    AtomicBoolean isStackValid = new AtomicBoolean(true);
                    ((IRunestonesCapability)((ItemStack)stack2.get()).getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(arg_0 -> CharmingTableContainer.lambda$updateOutput$2((Optional)stack2, isStackValid, arg_0));
                    if (isStackValid.get()) {
                        this.outputSlot.func_70299_a(0, (ItemStack)stack2.get());
                    }
                }
            } else if (itemStack.hasCapability(TreasureCapabilities.CHARMABLE, null) && ((ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isBindable() && TreasureCharmableMaterials.isSourceItemRegistered(itemStack2.func_77973_b().getRegistryName())) {
                stack = TreasureCharms.copyStack(itemStack, itemStack);
                cap = (ICharmableCapability)stack.getCapability(TreasureCapabilities.CHARMABLE, null);
                entity2 = (ICharmEntity)((List)cap.getCharmEntities().get((Object)InventoryType.INNATE)).get(0);
                if (entity2.getRecharges() > 0 && entity2.getMana() < entity2.getMaxMana()) {
                    entity2.setRecharges(entity2.getRecharges() - 1);
                    entity2.setMana(entity2.getMaxMana());
                    this.outputSlot.func_70299_a(0, stack);
                }
            } else if (!this.charmInputSlots1.func_191420_l() && !this.charmInputSlots2.func_191420_l()) {
                for (int i = 0; i < 4; ++i) {
                    if (!this.charmInputSlots1.func_70301_a(i).func_190926_b() && !this.charmInputSlots2.func_70301_a(i).func_190926_b() && TreasureCharmableMaterials.isSourceItemRegistered(this.charmInputSlots2.func_70301_a(i).func_77973_b().getRegistryName())) {
                        stack2 = TreasureAdornmentRegistry.copyStack(itemStack, itemStack);
                        ICharmableCapability cap3 = (ICharmableCapability)stack2.getCapability(TreasureCapabilities.CHARMABLE, null);
                        ICharmEntity entity4 = (ICharmEntity)((List)cap3.getCharmEntities().get((Object)InventoryType.SOCKET)).get(i);
                        if (entity4.getRecharges() <= 0 || !(entity4.getMana() < entity4.getMaxMana())) continue;
                        entity4.setRecharges(entity4.getRecharges() - 1);
                        entity4.setMana(entity4.getMaxMana());
                        this.charmOutputSlots[i].func_70299_a(0, stack2);
                        continue;
                    }
                    if (this.charmInputSlots1.func_70301_a(i).func_190926_b() || this.charmInputSlots2.func_70301_a(i).func_190926_b() || this.charmInputSlots2.func_70301_a(i).func_77973_b() != TreasureItems.TREASURE_TOOL) continue;
                    stack2 = itemStack.func_77946_l();
                    ItemStack newStack = TreasureAdornmentRegistry.copyStack(itemStack, stack2);
                    ICharmableCapability cap4 = (ICharmableCapability)newStack.getCapability(TreasureCapabilities.CHARMABLE, null);
                    cap4.remove(InventoryType.SOCKET, i);
                    if (newStack.hasCapability(TreasureCapabilities.RUNESTONES, null)) {
                        ((IRunestonesCapability)newStack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.SOCKET).forEach(entity -> entity.getRunestone().apply(newStack, (IRuneEntity)entity));
                    }
                    this.charmOutputSlots[i].func_70299_a(0, newStack);
                }
            } else if (runeStack != ItemStack.field_190927_a && runeStack2.func_77973_b() == TreasureItems.TREASURE_TOOL) {
                stack = itemStack.func_77946_l();
                cap = (IRunestonesCapability)(stack = TreasureAdornmentRegistry.copyStack(itemStack, stack)).getCapability(TreasureCapabilities.RUNESTONES, null);
                if (cap != null && cap.remove(InventoryType.SOCKET, (IRuneEntity)(entity2 = ((IRunestonesCapability)runeStack.getCapability(TreasureCapabilities.RUNESTONES, null)).getEntities(InventoryType.INNATE).get(0)))) {
                    entity2.getRunestone().undo(stack, (IRuneEntity)entity2);
                }
                this.runeOutputSlot.func_70299_a(0, stack);
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!WorldInfo.isClientSide(this.world)) {
            this.func_193327_a(player, this.world, this.inputSlots);
            this.clearAllSlots();
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.selfPosition).func_177230_c() != TreasureBlocks.CHARMING_TABLE) {
            return false;
        }
        return playerIn.func_70092_e((double)this.selfPosition.func_177958_n() + 0.5, (double)this.selfPosition.func_177956_o() + 0.5, (double)this.selfPosition.func_177952_p() + 0.5) <= 64.0;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    private static /* synthetic */ void lambda$updateOutput$2(Optional stack, AtomicBoolean isStackValid, IRuneEntity entity) {
        if (!entity.getRunestone().isValid((ItemStack)stack.get())) {
            isStackValid.set(false);
            return;
        }
        entity.getRunestone().apply((ItemStack)stack.get(), entity);
    }
}

