/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.inventory;

import com.someguyssoftware.treasure2.Treasure;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AbstractChestContainer
extends Container {
    protected IInventory inventory;
    protected final int HOTBAR_SLOT_COUNT = 9;
    protected final int PLAYER_INVENTORY_ROW_COUNT = 3;
    protected final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    protected final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    protected final int VANILLA_SLOT_COUNT = 36;
    protected final int VANILLA_FIRST_SLOT_INDEX = 0;
    protected final int CONTAINER_INVENTORY_FIRST_SLOT_INDEX = 36;
    private int containerInventoryRowCount = 3;
    private int containerInventoryColumnCount = 9;
    private int slotXSpacing = 18;
    private int slotYSpacing = 18;
    private int hotbarXPos = 8;
    private int hotbarYPos = 142;
    private int playerInventoryXPos = 8;
    private int playerInventoryYPos = 84;
    private int containerInventoryXPos = 8;
    private int containerInventoryYPos = 18;

    public AbstractChestContainer(InventoryPlayer invPlayer, IInventory inventory) {
        this.inventory = inventory;
        inventory.func_174889_b(invPlayer.field_70458_d);
    }

    public void buildContainer(InventoryPlayer player, IInventory inventory) {
        if (this.getContainerInventorySlotCount() != inventory.func_70302_i_()) {
            Treasure.LOGGER.error("Mismatched slot count in Container(" + this.getContainerInventorySlotCount() + ") and TileInventory (" + inventory.func_70302_i_() + ")");
        }
        this.buildHotbar(player);
        this.buildPlayerInventory(player);
        this.buildContainerInventory();
    }

    public void buildHotbar(InventoryPlayer player) {
        for (int x = 0; x < 9; ++x) {
            int slotNumber = x;
            this.func_75146_a(new Slot((IInventory)player, slotNumber, this.getHotbarXPos() + this.getSlotXSpacing() * x, this.getHotbarYPos()));
        }
    }

    public void buildPlayerInventory(InventoryPlayer player) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = this.getPlayerInventoryXPos() + x * this.getSlotXSpacing();
                int ypos = this.getPlayerInventoryYPos() + y * this.getSlotYSpacing();
                this.func_75146_a(new Slot((IInventory)player, slotNumber, xpos, ypos));
            }
        }
    }

    public void buildContainerInventory() {
        for (int y = 0; y < this.getContainerInventoryRowCount(); ++y) {
            for (int x = 0; x < this.getContainerInventoryColumnCount(); ++x) {
                int slotNumber = y * this.getContainerInventoryColumnCount() + x;
                int xpos = this.getContainerInventoryXPos() + x * this.getSlotXSpacing();
                int ypos = this.getContainerInventoryYPos() + y * this.getSlotYSpacing();
                this.func_75146_a(new Slot(this.inventory, slotNumber, xpos, ypos));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.inventory.func_94041_b(sourceSlotIndex, sourceStack)) {
                return ItemStack.field_190927_a;
            }
            if (!this.func_75135_a(sourceStack, 36, 36 + this.getContainerInventorySlotCount(), false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 36 + this.getContainerInventorySlotCount()) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            Treasure.LOGGER.warn("Invalid slotIndex:" + sourceSlotIndex);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return copyOfSourceStack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public int getContainerInventoryRowCount() {
        return this.containerInventoryRowCount;
    }

    public void setContainerInventoryRowCount(int containerInventoryRowCount) {
        this.containerInventoryRowCount = containerInventoryRowCount;
    }

    public int getContainerInventoryColumnCount() {
        return this.containerInventoryColumnCount;
    }

    public void setContainerInventoryColumnCount(int containerInventoryColumnCount) {
        this.containerInventoryColumnCount = containerInventoryColumnCount;
    }

    public int getContainerInventorySlotCount() {
        return this.getContainerInventoryRowCount() * this.getContainerInventoryColumnCount();
    }

    public int getSlotXSpacing() {
        return this.slotXSpacing;
    }

    public void setSlotXSpacing(int slotXSpacing) {
        this.slotXSpacing = slotXSpacing;
    }

    public int getSlotYSpacing() {
        return this.slotYSpacing;
    }

    public void setSlotYSpacing(int slotYSpacing) {
        this.slotYSpacing = slotYSpacing;
    }

    public int getHotbarYPos() {
        return this.hotbarYPos;
    }

    public void setHotbarYPos(int hotbarYPos) {
        this.hotbarYPos = hotbarYPos;
    }

    public int getHotbarXPos() {
        return this.hotbarXPos;
    }

    public void setHotbarXPos(int hotbarXPos) {
        this.hotbarXPos = hotbarXPos;
    }

    public int getPlayerInventoryXPos() {
        return this.playerInventoryXPos;
    }

    public void setPlayerInventoryXPos(int playerInventoryXPos) {
        this.playerInventoryXPos = playerInventoryXPos;
    }

    public int getPlayerInventoryYPos() {
        return this.playerInventoryYPos;
    }

    public void setPlayerInventoryYPos(int playerInventoryYPos) {
        this.playerInventoryYPos = playerInventoryYPos;
    }

    public int getContainerInventoryXPos() {
        return this.containerInventoryXPos;
    }

    public void setContainerInventoryXPos(int containerInventoryXPos) {
        this.containerInventoryXPos = containerInventoryXPos;
    }

    public int getContainerInventoryYPos() {
        return this.containerInventoryYPos;
    }

    public void setContainerInventoryYPos(int containerInventoryYPos) {
        this.containerInventoryYPos = containerInventoryYPos;
    }

    public IInventory getChestInventory() {
        return this.inventory;
    }

    public void setChestInventory(IInventory inventory) {
        this.inventory = inventory;
    }
}

