/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.well;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.IWellConfig;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.well.IWellGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.registry.TreasureTemplateRegistry;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class WellGenerator
implements IWellGenerator<GeneratorResult<GeneratorData>> {
    @Override
    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, IWellConfig config) {
        return this.generate(world, random, originalSpawnCoords, null, config);
    }

    @Override
    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder templateHolder, IWellConfig config) {
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        Biome biome = world.func_180494_b(originalSpawnCoords.toPos());
        TemplateGenerator generator = new TemplateGenerator();
        generator.setNullBlock(Blocks.field_150357_h);
        if (templateHolder == null) {
            templateHolder = TreasureTemplateRegistry.getManager().getTemplate(world, random, StructureArchetype.SURFACE, StructureType.WELL, biome);
        }
        if (templateHolder == null) {
            return result.fail();
        }
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotation).func_189950_a(random);
        Coords templateSize = new Coords(templateHolder.getTemplate().func_186257_a(rotation));
        ICoords actualSpawnCoords = generator.getTransformedSpawnCoords(originalSpawnCoords, templateSize, placement);
        actualSpawnCoords = WorldInfo.getDryLandSurfaceCoords(world, actualSpawnCoords.withY(255));
        if (actualSpawnCoords == null || actualSpawnCoords == WorldInfo.EMPTY_COORDS) {
            Treasure.LOGGER.debug("Returning due to marker coords == null or EMPTY_COORDS");
            return result.fail();
        }
        Treasure.LOGGER.debug("actual spawn coords after dry land surface check -> {}", (Object)actualSpawnCoords);
        if (!WorldInfo.isSolidBase(world, actualSpawnCoords, 3, 3, 50.0)) {
            Treasure.LOGGER.debug("Coords [{}] does not meet solid base requires for {} x {}", (Object)actualSpawnCoords.toShortString(), (Object)3, (Object)3);
            return result.fail();
        }
        originalSpawnCoords = new Coords(originalSpawnCoords.getX(), actualSpawnCoords.getY(), originalSpawnCoords.getZ());
        GeneratorResult<TemplateGeneratorData> genResult = generator.generate(world, random, templateHolder, placement, originalSpawnCoords);
        Treasure.LOGGER.debug("Well gen  structure result -> {}", (Object)genResult.isSuccess());
        if (!genResult.isSuccess()) {
            Treasure.LOGGER.debug("failing well gen.");
            return result.fail();
        }
        ICoords transformedSize = genResult.getData().getSize();
        this.addDecorations(world, random, genResult.getData().getSpawnCoords(), transformedSize.getX(), transformedSize.getZ());
        result.setData(genResult.getData());
        Treasure.LOGGER.info("CHEATER! Wishing Well at coords: {}", (Object)result.getData().getSpawnCoords().toShortString());
        return result.success();
    }

    public void addDecorations(World world, Random random, ICoords coords, int width, int depth) {
        int depthIndex;
        int widthIndex;
        ICoords startCoords = coords.add(-1, 0, -1);
        for (widthIndex = 0; widthIndex <= width + 1; ++widthIndex) {
            if (RandomHelper.randomInt(0, 1) != 0) continue;
            this.addDecoration(world, random, startCoords.add(widthIndex, 0, 0));
        }
        startCoords = coords.add(-1, 0, depth);
        for (widthIndex = 0; widthIndex <= width + 1; ++widthIndex) {
            if (RandomHelper.randomInt(0, 1) != 0) continue;
            this.addDecoration(world, random, startCoords.add(widthIndex, 0, 0));
        }
        startCoords = coords.add(-1, 0, 0);
        for (depthIndex = 0; depthIndex < depth - 1; ++depthIndex) {
            if (RandomHelper.randomInt(0, 1) != 0) continue;
            this.addDecoration(world, random, startCoords.add(0, 0, depthIndex));
        }
        startCoords = coords.add(width, 0, 0);
        for (depthIndex = 0; depthIndex < depth - 1; ++depthIndex) {
            if (RandomHelper.randomInt(0, 1) != 0) continue;
            this.addDecoration(world, random, startCoords.add(0, 0, depthIndex));
        }
    }

    @Override
    public void addDecoration(World world, Random random, ICoords coords) {
        IBlockState blockState = null;
        ICoords markerCoords = WorldInfo.getDryLandSurfaceCoords(world, coords);
        if (markerCoords == null || markerCoords == WorldInfo.EMPTY_COORDS) {
            Treasure.LOGGER.debug("Returning due to marker coords == null or EMPTY_COORDS");
            return;
        }
        Cube markerCube = new Cube(world, markerCoords);
        if (!markerCube.isAir() && !markerCube.isReplaceable()) {
            Treasure.LOGGER.debug("Returning due to marker coords is not air nor replaceable.");
            return;
        }
        markerCube = new Cube(world, markerCoords.add(0, -1, 0));
        if (markerCube.equalsBlock((Block)Blocks.field_150349_c)) {
            blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150328_O);
        } else if (markerCube.equalsBlock(Blocks.field_150346_d)) {
            BlockDirt.DirtType dirtType = (BlockDirt.DirtType)markerCube.getState().func_177229_b((IProperty)BlockDirt.field_176386_a);
            if (dirtType == BlockDirt.DirtType.DIRT) {
                blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150328_O);
            } else if (dirtType == BlockDirt.DirtType.PODZOL) {
                BlockBush mushBlock = random.nextInt(2) == 0 ? Blocks.field_150338_P : Blocks.field_150337_Q;
                blockState = this.getDecorationBlockState(world, (Block)mushBlock);
            } else {
                blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150329_H);
            }
        } else if (markerCube.equalsBlock((Block)Blocks.field_150391_bh)) {
            BlockBush mushBlock = random.nextInt(2) == 0 ? Blocks.field_150338_P : Blocks.field_150337_Q;
            blockState = this.getDecorationBlockState(world, (Block)mushBlock);
        } else {
            blockState = this.getDecorationBlockState(world, (Block)Blocks.field_150329_H);
        }
        world.func_180501_a(coords.toPos(), blockState, 3);
    }
}

