/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class VolcanoPitGenerator
extends AbstractPitGenerator {
    private static final int MIN_VOLCANO_RADIUS = 4;
    private static final int MAX_VOLCANO_RADIUS = 8;
    private static final int MIN_VERTICAL_DISTANCE = 15;

    public VolcanoPitGenerator() {
        this.getBlockLayers().add(50, Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Block)Blocks.field_150354_m);
        this.getBlockLayers().add(15, Blocks.field_150347_e);
        this.getBlockLayers().add(15, Blocks.field_150351_n);
        this.getBlockLayers().add(10, Blocks.field_150364_r);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = super.generate(world, random, surfaceCoords, spawnCoords);
        if (result.isSuccess()) {
            Treasure.LOGGER.debug("Generated Volcano Pit at " + spawnCoords.toShortString());
        }
        return result;
    }

    @Override
    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        ICoords nextCoords = null;
        ICoords expectedCoords = null;
        int radius = RandomHelper.randomInt(random, 4, 8);
        int shaftStartY = coords.getY() + (surfaceCoords.getY() - coords.getY()) / 3 * 2;
        this.buildLavaBaseLayer(world, coords.down(1), radius);
        nextCoords = coords;
        while (nextCoords.getY() < shaftStartY - 4) {
            nextCoords = this.buildLayer(world, nextCoords, radius, Blocks.field_150350_a, true);
        }
        while (nextCoords.getY() < shaftStartY && radius > 1) {
            nextCoords = this.buildLayer(world, nextCoords, radius--, Blocks.field_150350_a, false);
        }
        nextCoords = this.buildLogLayer(world, random, nextCoords, Blocks.field_150364_r);
        for (int yIndex = nextCoords.getY() + 1; yIndex <= surfaceCoords.getY() - 6; ++yIndex) {
            Cube cube = new Cube(world, new Coords(coords.getX(), yIndex, coords.getZ()));
            if (cube.isAir()) continue;
            Block block = col.next();
            nextCoords = block == Blocks.field_150364_r ? this.buildLogLayer(world, random, cube.getCoords(), block) : this.buildLayer(world, cube.getCoords(), block);
            expectedCoords = cube.getCoords().add(0, 1, 0);
            yIndex = this.autoCorrectIndex(yIndex, nextCoords, expectedCoords);
        }
        return nextCoords;
    }

    @Override
    public void buildAboveChestLayers(World world, Random random, ICoords spawnCoords) {
    }

    private ICoords buildLayer(World world, ICoords coords, int radius, Block block, boolean addDecorations) {
        int radiusSquared = radius * radius;
        Integer[] distancesMet = new Integer[radius + 1];
        ICoords spawnCoords = null;
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                ICoords replaceCoords;
                boolean isDistanceMet = false;
                spawnCoords = coords.add(xOffset, 0, zOffset);
                if (distancesMet[Math.abs(xOffset)] != null) {
                    if (Math.abs(zOffset) <= distancesMet[Math.abs(xOffset)]) {
                        isDistanceMet = true;
                    }
                } else if (coords.getDistanceSq(spawnCoords) < (double)radiusSquared) {
                    distancesMet[Math.abs((int)xOffset)] = Math.abs(zOffset);
                    isDistanceMet = true;
                }
                if (!isDistanceMet) continue;
                Random random = new Random();
                GenUtil.replaceWithBlock(world, spawnCoords, block);
                if (!addDecorations) continue;
                if (xOffset < 0) {
                    replaceCoords = spawnCoords.west(1);
                    this.addDecorations(world, random, replaceCoords);
                } else if (xOffset > 0) {
                    replaceCoords = spawnCoords.east(1);
                    this.addDecorations(world, random, replaceCoords);
                }
                if (zOffset < 0) {
                    replaceCoords = spawnCoords.north(1);
                    this.addDecorations(world, random, replaceCoords);
                    continue;
                }
                if (zOffset <= 0) continue;
                replaceCoords = spawnCoords.south(1);
                this.addDecorations(world, random, replaceCoords);
            }
        }
        return coords.up(1);
    }

    private void addDecorations(World world, Random random, ICoords coords) {
        if (world.func_180495_p(coords.toPos()).func_177230_c() != Blocks.field_150350_a) {
            if (RandomHelper.checkProbability(random, 30)) {
                world.func_175656_a(coords.toPos(), TreasureBlocks.BLACKSTONE.func_176223_P());
            } else if (RandomHelper.checkProbability(random, 10)) {
                world.func_175656_a(coords.toPos(), Blocks.field_150353_l.func_176223_P());
            }
        }
    }

    private void buildLavaBaseLayer(World world, ICoords coords, int radius) {
        Treasure.LOGGER.debug("Building lava baselayer from @ {} ", (Object)coords.toShortString());
        this.buildLayer(world, coords, radius, (Block)Blocks.field_150353_l, false);
        GenUtil.replaceWithBlock(world, coords, Blocks.field_150348_b);
    }

    @Override
    public int getMinSurfaceToSpawnDistance() {
        return 15;
    }
}

