/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.marker;

import com.someguyssoftware.gottschcore.block.AbstractModContainerBlock;
import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.block.SkeletonBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.marker.IMarkerGenerator;
import com.someguyssoftware.treasure2.tileentity.GravestoneProximitySpawnerTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class GravestoneMarkerGenerator
implements IMarkerGenerator<GeneratorResult<GeneratorData>> {
    @Override
    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords) {
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        if (!TreasureConfig.WORLD_GEN.getMarkerProperties().isGravestonesAllowed) {
            return result.fail();
        }
        int x = coords.getX();
        int z = coords.getZ();
        int numberOfMarkers = RandomHelper.randomInt(TreasureConfig.WORLD_GEN.getMarkerProperties().minGravestonesPerChest, TreasureConfig.WORLD_GEN.getMarkerProperties().maxGravestonesPerChest);
        int gridSize = 4;
        if (numberOfMarkers >= 6) {
            gridSize = numberOfMarkers >= 6 && numberOfMarkers <= 8 ? 5 : 6;
        }
        ICoords markerCoords = null;
        for (int i = 0; i < numberOfMarkers; ++i) {
            int zSpawn;
            int ySpawn;
            int xSpawn = x + random.nextInt(gridSize) * (random.nextInt(3) - 1);
            ICoords spawnCoords = new Coords(xSpawn, ySpawn = WorldInfo.getHeightValue(world, new Coords(xSpawn, 0, zSpawn = z + random.nextInt(gridSize) * (random.nextInt(3) - 1))), zSpawn);
            if (!WorldInfo.isValidY(spawnCoords)) {
                Treasure.LOGGER.debug(String.format("[%d] is not a valid y value.", spawnCoords.getY()));
                continue;
            }
            if ((spawnCoords = WorldInfo.getDryLandSurfaceCoords(world, spawnCoords)) == null) {
                Treasure.LOGGER.debug(String.format("Not a valid surface @ %s", coords));
                continue;
            }
            Cube cube = new Cube(world, spawnCoords);
            if (!cube.isAir() && !cube.isReplaceable()) {
                Treasure.LOGGER.debug("Marker not placed because block  @ [{}] is not Air, Replaceable.", (Object)spawnCoords.toShortString());
                continue;
            }
            Block block = world.func_180495_p(spawnCoords.add(0, -1, 0).toPos()).func_177230_c();
            if (block instanceof BlockContainer || block instanceof AbstractModContainerBlock || block instanceof ITreasureBlock) {
                Treasure.LOGGER.debug("Marker not placed because block underneath is a chest, container or Treasure block.");
                continue;
            }
            Block marker = null;
            marker = TreasureConfig.WORLD_GEN.markerProperties.isGravestoneSpawnMobAllowed && RandomHelper.checkProbability(random, TreasureConfig.WORLD_GEN.markerProperties.gravestoneMobProbability) ? TreasureBlocks.gravestoneSpawners.get(random.nextInt(TreasureBlocks.gravestoneSpawners.size())) : TreasureBlocks.gravestones.get(random.nextInt(TreasureBlocks.gravestones.size()));
            Treasure.LOGGER.debug("marker class -> {}", (Object)marker.getClass().getSimpleName());
            EnumFacing[] horizontals = EnumFacing.field_176754_o;
            EnumFacing facing = horizontals[random.nextInt(horizontals.length)];
            if (marker instanceof SkeletonBlock) {
                Treasure.LOGGER.debug("should be placing skeleton block -> {}", (Object)spawnCoords.toShortString());
                GenUtil.placeSkeleton(world, random, spawnCoords);
            } else {
                world.func_175656_a(spawnCoords.toPos(), marker.func_176223_P().func_177226_a(AbstractChestBlock.FACING, (Comparable)facing));
            }
            GravestoneProximitySpawnerTileEntity tileEntity = (GravestoneProximitySpawnerTileEntity)world.func_175625_s(spawnCoords.toPos());
            if (tileEntity != null) {
                tileEntity.setHasEntity(true);
            }
            if (markerCoords != null) continue;
            markerCoords = spawnCoords;
        }
        result.getData().setSpawnCoords(markerCoords);
        return result.success();
    }
}

