/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.chest;

import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.enums.ChestGeneratorType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster2;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;

public class SkullChestGenerator
implements IChestGenerator {
    @Override
    public void addGenerationContext(AbstractTreasureChestTileEntity tileEntity, Rarity rarity) {
        AbstractTreasureChestTileEntity abstractTreasureChestTileEntity = tileEntity;
        abstractTreasureChestTileEntity.getClass();
        AbstractTreasureChestTileEntity.GenerationContext generationContext = new AbstractTreasureChestTileEntity.GenerationContext(abstractTreasureChestTileEntity, rarity, ChestGeneratorType.SKULL);
        tileEntity.setGenerationContext(generationContext);
    }

    @Override
    public Optional<LootTableShell> selectLootTable2(Random random, Rarity chestRarity) {
        return Optional.ofNullable(TreasureLootTableRegistry.getLootTableMaster().getSpecialLootTable(TreasureLootTableMaster2.SpecialLootTables.SKULL_CHEST));
    }

    @Override
    public Optional<LootTableShell> selectLootTable2(Supplier<Random> factory, Rarity rarity) {
        return Optional.ofNullable(TreasureLootTableRegistry.getLootTableMaster().getSpecialLootTable(TreasureLootTableMaster2.SpecialLootTables.SKULL_CHEST));
    }

    @Override
    public TreasureChestBlock selectChest(Random random, Rarity rarity) {
        TreasureChestBlock chest = null;
        if (this.isChestEnabled(TreasureBlocks.SKULL_CHEST)) {
            chest = (TreasureChestBlock)TreasureBlocks.SKULL_CHEST;
        }
        return chest;
    }

    @Override
    public int randomizedNumberOfLocksByChestType(Random random, TreasureChestType type) {
        int numLocks = RandomHelper.randomInt(random, 1, type.getMaxLocks());
        Treasure.LOGGER.debug("# of locks to use: {})", (Object)numLocks);
        return numLocks;
    }

    @Override
    public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity te, Rarity rarity) {
        ArrayList<LockItem> locks = new ArrayList<LockItem>();
        locks.addAll(TreasureItems.locks.get((Object)Rarity.UNCOMMON));
        locks.addAll(TreasureItems.locks.get((Object)Rarity.SCARCE));
        this.addLocks(random, chest, te, locks);
        locks.clear();
    }
}

