/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.WorldGeneratorType;
import com.someguyssoftware.treasure2.loot.TreasureLootTableRegistry;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.registry.TreasureDecayRegistry;
import com.someguyssoftware.treasure2.registry.TreasureMetaRegistry;
import com.someguyssoftware.treasure2.registry.TreasureTemplateRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEventHandler {
    private IMod mod;

    public WorldEventHandler(IMod mod) {
        this.setMod(mod);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldEvent.Load event) {
        Treasure.LOGGER.debug("In world load event for dimension {}", (Object)event.getWorld().field_73011_w.getDimension());
        if (WorldInfo.isServerSide(event.getWorld()) && event.getWorld().field_73011_w.getDimension() == 0) {
            WorldServer world = (WorldServer)event.getWorld();
            TreasureLootTableRegistry.onWorldLoad(event);
            TreasureMetaRegistry.onWorldLoad(event);
            TreasureTemplateRegistry.onWorldLoad(event);
            TreasureDecayRegistry.onWorldLoad(event);
            for (Map.Entry<WorldGeneratorType, ITreasureWorldGenerator> worldGenEntry : Treasure.WORLD_GENERATORS.entrySet()) {
                worldGenEntry.getValue().init();
            }
            Treasure.LOGGER.debug("Chest registry size BEFORE cleaning -> {}", (Object)ChestRegistry.getInstance().getValues().size());
            ChestRegistry.getInstance().clear();
            Treasure.LOGGER.debug("Chest registry size AFTER cleaning -> {}", (Object)ChestRegistry.getInstance().getValues().size());
            GenDataPersistence.get((World)world);
            Treasure.LOGGER.debug("Chest registry size after world event load -> {}", (Object)ChestRegistry.getInstance().getValues().size());
        }
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        if (event.getName().toString().equals(LootTableList.field_186422_d.toString())) {
            ResourceLocation location = new ResourceLocation("treasure2", "pools/treasure/scarce");
            LootEntryTable entry = new LootEntryTable(location, 1, 1, new LootCondition[0], "treasure");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(1.0f), "treasure");
            event.getTable().addPool(pool);
        }
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }
}

