/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.mojang.authlib.GameProfile;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.item.IWishable;
import com.someguyssoftware.treasure2.item.TreasureItems;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerEventHandler {
    private static final String FIRST_JOIN_NBT_KEY = "treasure2.firstjoin";
    private static final String PATCHOULI_MODID = "patchouli";
    private static final String PATCHOULI_GUIDE_BOOK_ID = "patchouli:guide_book";
    private static final String PATCHOULI_GUIDE_TAG_ID = "patchouli:book";
    private static final String TREASURE2_GUIDE_TAG_VALUE = "treasure2:guide";
    private IMod mod;

    public PlayerEventHandler(IMod mod) {
        this.setMod(mod);
    }

    @SubscribeEvent
    public void addToInventory(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistentNbt;
        if (!TreasureConfig.MOD.enableSpecialRewards) {
            return;
        }
        if (event.player.func_184812_l_()) {
            return;
        }
        NBTTagCompound playerData = event.player.getEntityData();
        if (!playerData.func_74764_b("PlayerPersisted")) {
            persistentNbt = new NBTTagCompound();
            playerData.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
        } else {
            persistentNbt = playerData.func_74775_l("PlayerPersisted");
        }
        if (Year.now().getValue() == 2022 && (LocalDate.now().getMonth() == Month.JUNE && LocalDate.now().getDayOfMonth() > 10 || LocalDate.now().getMonth() == Month.JULY && LocalDate.now().getDayOfMonth() < 15) && !persistentNbt.func_74764_b("treasure2.firstjoin_5m_reward")) {
            persistentNbt.func_74757_a("treasure2.firstjoin_5m_reward", true);
            ItemStack ring = new ItemStack((Item)TreasureItems.GOTTSCHS_AMULET_OF_HEAVENS, 1);
            event.player.field_71071_by.func_70441_a(ring);
        }
    }

    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistent;
        if (!TreasureConfig.MOD.enableStartingBook) {
            return;
        }
        if (event.player.func_184812_l_()) {
            return;
        }
        NBTTagCompound data = event.player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new NBTTagCompound();
            data.func_74782_a("PlayerPersisted", (NBTBase)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (Loader.isModLoaded((String)PATCHOULI_MODID) && !persistent.func_74764_b(FIRST_JOIN_NBT_KEY)) {
            persistent.func_74757_a(FIRST_JOIN_NBT_KEY, true);
            Item guideBook = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(PATCHOULI_GUIDE_BOOK_ID));
            ItemStack stack = new ItemStack(guideBook);
            if (!stack.func_77942_o()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(PATCHOULI_GUIDE_TAG_ID, TREASURE2_GUIDE_TAG_VALUE);
                stack.func_77982_d(tag);
            }
            event.player.field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent
    public void onTossCoinEvent(ItemTossEvent event) {
        if (WorldInfo.isClientSide(event.getPlayer().field_70170_p)) {
            return;
        }
        Treasure.LOGGER.debug("{} tossing item -> {}", (Object)event.getPlayer().func_70005_c_(), (Object)event.getEntityItem().func_92059_d().func_82833_r());
        Item item = event.getEntityItem().func_92059_d().func_77973_b();
        if (item instanceof IWishable) {
            ItemStack stack = event.getEntityItem().func_92059_d();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("droppedBy", EntityPlayer.func_146094_a((GameProfile)event.getPlayer().func_146103_bH()).toString());
            stack.func_77982_d(nbt);
        }
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }

    public static enum CharmedType {
        CHARM,
        FOCUS,
        ADORNMENT;

    }
}

