/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.CharmContext;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.eventhandler.IEquipmentCharmHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HotbarEquipmentCharmHandler
implements IEquipmentCharmHandler {
    private static final int MAX_HOTBAR_CHARMS = 4;

    @Override
    public List<CharmContext> handleEquipmentCharms(Event event, EntityPlayerMP player) {
        ArrayList<CharmContext> contexts = new ArrayList<CharmContext>(5);
        AtomicInteger adornmentCount = new AtomicInteger(0);
        AtomicInteger slot = new AtomicInteger(-1);
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            ICharmableCapability cap;
            slot.set(hotbarSlot);
            ItemStack inventoryStack = player.field_71071_by.func_70301_a(hotbarSlot);
            if (inventoryStack == player.func_184614_ca() || !inventoryStack.hasCapability(TreasureCapabilities.CHARMABLE, null) || !(cap = (ICharmableCapability)inventoryStack.getCapability(TreasureCapabilities.CHARMABLE, null)).isExecuting()) continue;
            for (InventoryType type : InventoryType.values()) {
                AtomicInteger index = new AtomicInteger();
                for (int i = 0; i < cap.getCharmEntities().get((Object)type).size(); ++i) {
                    ICharmEntity entity = (ICharmEntity)((List)cap.getCharmEntities().get((Object)type)).get(i);
                    if (!entity.getCharm().getRegisteredEvent().equals(event.getClass())) continue;
                    index.set(i);
                    CharmContext context = new CharmContext.Builder().with($ -> {
                        $.slotProviderId = "minecraft";
                        $.slot = slot.get();
                        $.itemStack = inventoryStack;
                        $.capability = cap;
                        $.type = type;
                        $.index = index.get();
                        $.entity = entity;
                    }).build();
                    contexts.add(context);
                }
            }
            adornmentCount.getAndIncrement();
            if (adornmentCount.get() >= 4) break;
        }
        return contexts;
    }
}

