/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.mojang.authlib.GameProfile;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.CharmContext;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.eventhandler.IEquipmentCharmHandler;
import com.someguyssoftware.treasure2.network.CharmMessageToClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CharmEventHandler {
    private IEquipmentCharmHandler equipmentCharmHandler;

    public CharmEventHandler(IEquipmentCharmHandler handler) {
        this.equipmentCharmHandler = handler;
    }

    @SubscribeEvent
    public void checkCharmsInteraction(LivingEvent.LivingUpdateEvent event) {
        if (WorldInfo.isClientSide(event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.processCharms((Event)event, player);
        }
    }

    @SubscribeEvent
    public void checkCharmsInteractionWithDamage(LivingDamageEvent event) {
        if (WorldInfo.isClientSide(event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            this.processCharms((Event)event, player);
        }
    }

    @SubscribeEvent
    public void checkCharmsInteractionWithAttack(LivingHurtEvent event) {
        if (WorldInfo.isClientSide(event.getEntity().func_130014_f_())) {
            return;
        }
        EntityPlayerMP player = null;
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayerMP)event.getSource().func_76346_g();
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            player = (EntityPlayerMP)event.getEntityLiving();
        }
        if (player != null) {
            this.processCharms((Event)event, player);
        }
    }

    @SubscribeEvent
    public void checkCharmsInteractionWithBlock(BlockEvent.HarvestDropsEvent event) {
        if (WorldInfo.isClientSide(event.getWorld())) {
            return;
        }
        if (event.getHarvester() == null) {
            return;
        }
        IBlockState harvestedState = event.getState();
        Block harvestedBlock = harvestedState.func_177230_c();
        if (harvestedBlock.hasTileEntity(harvestedState)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getHarvester();
        this.processCharms((Event)event, player);
    }

    private void processCharms(Event event, EntityPlayerMP player) {
        List<CharmContext> charmsToExecute = this.gatherCharms(event, player);
        Collections.sort(charmsToExecute, CharmContext.priorityComparator);
        CharmEventHandler.executeCharms(event, player, charmsToExecute);
    }

    private List<CharmContext> gatherCharms(Event event, EntityPlayerMP player) {
        ArrayList<CharmContext> contexts = new ArrayList<CharmContext>(5);
        for (EnumHand hand : EnumHand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (!heldStack.hasCapability(TreasureCapabilities.CHARMABLE, null)) continue;
            contexts.addAll(this.getCharmsFromStack(event, hand, -1, heldStack, false));
        }
        List<CharmContext> equipmentContexts = this.getEquipmentCharmHandler().handleEquipmentCharms(event, player);
        contexts.addAll(equipmentContexts);
        return contexts;
    }

    private List<CharmContext> getCharmsFromStack(Event event, EnumHand hand, int slot, ItemStack itemStack, boolean isPouch) {
        ArrayList<CharmContext> contexts = new ArrayList<CharmContext>(5);
        ICharmableCapability cap = (ICharmableCapability)itemStack.getCapability(TreasureCapabilities.CHARMABLE, null);
        if (cap.isExecuting()) {
            for (InventoryType type : InventoryType.values()) {
                AtomicInteger index = new AtomicInteger();
                for (int i = 0; i < cap.getCharmEntities().get((Object)type).size(); ++i) {
                    ICharmEntity entity = (ICharmEntity)((List)cap.getCharmEntities().get((Object)type)).get(i);
                    if (!entity.getCharm().getRegisteredEvent().equals(event.getClass())) continue;
                    index.set(i);
                    CharmContext context = new CharmContext.Builder().with($ -> {
                        $.hand = hand;
                        $.slot = slot;
                        $.slotProviderId = isPouch ? "treasure2" : "minecraft";
                        $.itemStack = itemStack;
                        $.capability = cap;
                        $.type = type;
                        $.index = index.get();
                        $.entity = entity;
                    }).build();
                    contexts.add(context);
                }
            }
        }
        return contexts;
    }

    private static void executeCharms(Event event, EntityPlayerMP player, List<CharmContext> contexts) {
        ArrayList executeOnceCharmTypes = new ArrayList(5);
        contexts.forEach(context -> {
            ICharm charm = context.getEntity().getCharm();
            if (!charm.isEffectStackable()) {
                if (executeOnceCharmTypes.contains(charm.getType())) {
                    return;
                }
                executeOnceCharmTypes.add(charm.getType());
            }
            if (context.getEntity().getCharm().update(player.field_70170_p, new Random(), new Coords(player.func_180425_c()), (EntityPlayer)player, event, context.getEntity())) {
                CharmEventHandler.processUsage(player.field_70170_p, player, event, context);
                CharmMessageToClient message = new CharmMessageToClient(EntityPlayerMP.func_146094_a((GameProfile)player.func_146103_bH()).toString(), (CharmContext)context);
                Treasure.simpleNetworkWrapper.sendTo((IMessage)message, player);
            }
            if (context.getCapability().isBindable() && context.getEntity().getRecharges() <= 0 && context.getEntity().getMana() <= 0.0) {
                Treasure.LOGGER.debug("charm is empty without any recharges -> remove");
                context.getCapability().remove(context.getType(), context.getIndex());
            }
        });
    }

    private static void processUsage(World world, EntityPlayerMP player, Event event, CharmContext context) {
        ItemStack stack = context.getItemStack();
        if (stack.hasCapability(TreasureCapabilities.DURABILITY, null)) {
            IDurabilityCapability cap = (IDurabilityCapability)stack.getCapability(TreasureCapabilities.DURABILITY, null);
            if (cap.isInfinite()) {
                return;
            }
            stack.func_77964_b(stack.func_77952_i() + 1);
            if (stack.func_77952_i() >= cap.getDurability()) {
                stack.func_190918_g(1);
            }
        }
    }

    public IEquipmentCharmHandler getEquipmentCharmHandler() {
        return this.equipmentCharmHandler;
    }
}

