/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.enums;

import com.someguyssoftware.treasure2.enums.IEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum AdornmentType implements IEnum
{
    RING(0, "ring"),
    NECKLACE(1, "necklace"),
    BRACELET(2, "bracelet"),
    POCKET(3, "pocket"),
    EARRING(4, "earring");

    private static final Map<Integer, IEnum> codes;
    private static final Map<String, IEnum> values;
    private Integer code;
    private String value;

    private AdornmentType(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public static AdornmentType getByCode(Integer code) {
        return (AdornmentType)codes.get(code);
    }

    public static AdornmentType getByValue(String value) {
        return (AdornmentType)values.get(value);
    }

    @Override
    public Map<Integer, IEnum> getCodes() {
        return codes;
    }

    @Override
    public Map<String, IEnum> getValues() {
        return values;
    }

    public static List<String> getNames() {
        List<String> names = EnumSet.allOf(AdornmentType.class).stream().map(x -> x.name()).collect(Collectors.toList());
        return names;
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    static {
        codes = new HashMap<Integer, IEnum>();
        values = new HashMap<String, IEnum>();
        for (AdornmentType x : EnumSet.allOf(AdornmentType.class)) {
            codes.put(x.getCode(), x);
            values.put(x.getValue(), x);
        }
    }
}

