/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.enums.Direction;
import com.someguyssoftware.gottschcore.loot.LootTableShell;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.enums.ChestGeneratorType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGeneratorType;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnChestCommand
extends CommandBase {
    private static final String RARITY_ARG = "rarity";
    private static final String FACING_ARG = "facing";
    private static final String CHEST_ARG = "chest";
    private static final String LOCKED_ARG = "locked";
    private static final String SEALED_ARG = "sealed";

    public String func_71517_b() {
        return "t2-chest";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-chest <x> <y> <z> [-rarity <rarity>] [-facing <facing>] [-chest <chest>] [-locked] [-sealed]: generates a Treasure! chest at location (x,y,z)";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.LOGGER.debug("Starting to spawn Treasure! chest ...");
        try {
            int z = 0;
            int x = this.getPositionValue(args[0], commandSender, 'x');
            int y = this.getPositionValue(args[1], commandSender, 'y');
            z = this.getPositionValue(args[2], commandSender, 'z');
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(RARITY_ARG, true, "");
            options.addOption(FACING_ARG, true, "");
            options.addOption(CHEST_ARG, true, "");
            options.addOption(LOCKED_ARG, false, "");
            options.addOption(SEALED_ARG, false, "");
            CommandLine line = parser.parse(options, parserArgs);
            Rarity rarity = Rarity.COMMON;
            if (line.hasOption(RARITY_ARG)) {
                String rarityArg = line.getOptionValue(RARITY_ARG);
                try {
                    rarity = Rarity.valueOf(rarityArg.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.warn("unable to set rarity to -> {}, defaulting to {}", (Object)rarityArg, (Object)rarity);
                }
            }
            if (Treasure.LOGGER.isDebugEnabled()) {
                Treasure.LOGGER.debug("rarity -> {}", (Object)rarity);
            }
            Direction direction = Direction.NORTH;
            if (line.hasOption(FACING_ARG)) {
                String directionArg = line.getOptionValue(FACING_ARG);
                try {
                    direction = Direction.valueOf(directionArg.toUpperCase());
                }
                catch (Exception e) {
                    Treasure.LOGGER.warn("unable to set direction to -> {}, defaulting to NORTH", (Object)directionArg);
                }
            }
            if (Treasure.LOGGER.isDebugEnabled()) {
                Treasure.LOGGER.debug("facing -> {}", (Object)direction);
            }
            Optional<Object> chests = Optional.empty();
            Object chest = null;
            if (line.hasOption(CHEST_ARG)) {
                String chestArg = line.getOptionValue(CHEST_ARG);
                try {
                    chests = Optional.of(Chests.valueOf(chestArg.toUpperCase()));
                }
                catch (Exception e) {
                    Treasure.LOGGER.warn("unable to set chest to -> {}, defaulting based on rarity", (Object)chestArg);
                }
            }
            if (Treasure.LOGGER.isDebugEnabled() && chests.isPresent()) {
                Treasure.LOGGER.debug("chest -> {}", chests.get());
            }
            World world = commandSender.func_130014_f_();
            Random random = new Random();
            IChestGenerator gen = null;
            if (chests.isPresent() && ChestGeneratorType.getNames().contains(((Chests)((Object)chests.get())).name())) {
                gen = ChestGeneratorType.valueOf(((Chests)((Object)chests.get())).name()).getChestGenerator();
            } else {
                SurfaceChestWorldGenerator chestGens = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGeneratorType.SURFACE_CHEST);
                gen = chestGens.getChestGenMap().get(rarity).next();
            }
            chest = chests.isPresent() ? ((Chests)((Object)chests.get())).chest : gen.selectChest(random, rarity);
            BlockPos pos = new BlockPos(x, y, z);
            world.func_175656_a(pos, chest.func_176223_P().func_177226_a((IProperty)TreasureChestBlock.FACING, (Comparable)direction.toFacing()));
            Optional<LootTableShell> lootTableShell = gen.selectLootTable2(random, rarity);
            ResourceLocation lootTableResourceLocation = null;
            if (lootTableShell.isPresent()) {
                lootTableResourceLocation = lootTableShell.get().getResourceLocation();
            }
            if (lootTableResourceLocation == null) {
                Treasure.LOGGER.debug("Unable to select a LootTable for rarity -> {}", (Object)rarity);
                return;
            }
            AbstractTreasureChestTileEntity tileEntity = (AbstractTreasureChestTileEntity)world.func_175625_s(pos);
            if (tileEntity != null) {
                if (line.hasOption(LOCKED_ARG) || line.hasOption(SEALED_ARG)) {
                    gen.addLootTable(tileEntity, lootTableResourceLocation);
                    gen.addSeal(tileEntity);
                }
                gen.addGenerationContext(tileEntity, rarity);
                if (line.hasOption(LOCKED_ARG)) {
                    gen.addLocks(random, (AbstractChestBlock)chest, tileEntity, rarity);
                    ((AbstractChestBlock)chest).rotateLockStates(world, pos, Direction.NORTH.getRotation(direction));
                    tileEntity.sendUpdates();
                }
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error generating Treasure! chest: ", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 3) {
            if (args[args.length - 2].equals("-rarity")) {
                return SpawnChestCommand.func_175762_a((String[])args, Rarity.getNames());
            }
            if (args[args.length - 2].equals("-facing")) {
                return SpawnChestCommand.func_175762_a((String[])args, Direction.getHorizontalNames());
            }
            if (args[args.length - 2].equals("-chest")) {
                return SpawnChestCommand.func_175762_a((String[])args, Chests.getNames());
            }
        }
        return Collections.emptyList();
    }

    private int getOriginValue(ICommandSender commandSender, char coordName) {
        switch (coordName) {
            case 'z': {
                return commandSender.func_180425_c().func_177952_p();
            }
            case 'y': {
                return commandSender.func_180425_c().func_177956_o();
            }
        }
        return commandSender.func_180425_c().func_177958_n();
    }

    private int getPositionValue(String coordStr, ICommandSender commandSender, char coordName) {
        int value = 0;
        int origin = 0;
        if (coordStr.equals("~")) {
            origin = this.getOriginValue(commandSender, coordName);
        } else if (coordStr.charAt(0) == '~') {
            try {
                value = Integer.parseInt(coordStr.substring(1));
            }
            catch (Exception e) {
                Treasure.LOGGER.error("Error with " + coordName + " coordinate: ", (Throwable)e);
                value = 0;
            }
            origin = this.getOriginValue(commandSender, coordName);
        } else {
            try {
                value = Integer.parseInt(coordStr);
            }
            catch (Exception e) {
                Treasure.LOGGER.error("Error with " + coordName + " coordinate: ", (Throwable)e);
                value = 0;
            }
        }
        return value + origin;
    }

    private static enum Chests {
        WOOD(TreasureBlocks.WOOD_CHEST),
        CRATE(TreasureBlocks.CRATE_CHEST),
        MOLDY_CRATE(TreasureBlocks.MOLDY_CRATE_CHEST),
        IRON_BOUND(TreasureBlocks.IRONBOUND_CHEST),
        PIRATE(TreasureBlocks.PIRATE_CHEST),
        IRON_STRONGBOX(TreasureBlocks.IRON_STRONGBOX),
        GOLD_STRONGBOX(TreasureBlocks.GOLD_STRONGBOX),
        SAFE(TreasureBlocks.SAFE),
        DREAD_PIRATE(TreasureBlocks.DREAD_PIRATE_CHEST),
        COMPRESSOR(TreasureBlocks.COMPRESSOR_CHEST),
        SPIDER(TreasureBlocks.SPIDER_CHEST),
        VIKING(TreasureBlocks.VIKING_CHEST),
        CARDBOARD_BOX(TreasureBlocks.CARDBOARD_BOX),
        MILK_CRATE(TreasureBlocks.MILK_CRATE),
        WITHER(TreasureBlocks.WITHER_CHEST),
        SKULL(TreasureBlocks.SKULL_CHEST),
        GOLD_SKULL(TreasureBlocks.GOLD_SKULL_CHEST),
        CRYSTAL_SKULL(TreasureBlocks.CRYSTAL_SKULL_CHEST),
        CAULDRON(TreasureBlocks.CAULDRON_CHEST);

        Block chest;

        private Chests(Block chestBlock) {
            this.chest = chestBlock;
        }

        public static List<String> getNames() {
            List<String> names = EnumSet.allOf(Chests.class).stream().map(x -> x.name()).collect(Collectors.toList());
            return names;
        }
    }
}

