/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.TreasureItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnCharmCommand
extends CommandBase {
    private static final String LEVEL_ARG = "level";
    private static final String RARITY_ARG = "rarity";
    private static final String BOOK_ARG = "book";

    public String func_71517_b() {
        return "t2-charm";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-charm <charm> [-level <level> -rarity <rarity>]: spawns a Treasure! charm.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.LOGGER.debug("Starting to build Treasure! charm ...");
        World world = commandSender.func_130014_f_();
        Random random = new Random();
        try {
            Optional<ItemStack> charmStack;
            String[] parserArgs = Arrays.copyOfRange(args, 1, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(LEVEL_ARG, true, "");
            options.addOption(RARITY_ARG, true, "");
            options.addOption(BOOK_ARG, false, "");
            CommandLine line = parser.parse(options, parserArgs);
            String charmTypeName = args[0];
            int level = 1;
            if (line.hasOption(LEVEL_ARG)) {
                level = Integer.parseInt(line.getOptionValue(LEVEL_ARG));
            }
            if (!(charmStack = TreasureItems.getCharm(charmTypeName, level, line.hasOption(BOOK_ARG) ? 1 : 0)).isPresent()) {
                return;
            }
            InventoryHelper.func_180173_a((World)world, (double)((double)commandSender.func_180425_c().func_177958_n() + 0.5), (double)((double)commandSender.func_180425_c().func_177956_o() + 0.5), (double)((double)commandSender.func_180425_c().func_177952_p() + 0.5), (ItemStack)charmStack.get());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Error generating Treasure! well:", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            List<String> charms = Arrays.asList("aegis", "decay", "decrepit", "dirt_fill", "dirt_walk", "drain", "fire_immunity", "fire_resistence", "greater_healing", "healing", "illumination", "life_strike", "reflection", "ruin", "satiety", "shielding");
            return SpawnCharmCommand.func_175762_a((String[])args, charms);
        }
        if (args[args.length - 2].equals("-rarity")) {
            return SpawnCharmCommand.func_175762_a((String[])args, Rarity.getNames());
        }
        if (args[args.length - 2].equals("-level")) {
            ArrayList<String> levels = new ArrayList<String>();
            for (int i = 1; i <= 9; ++i) {
                levels.add(String.valueOf(i));
            }
            return SpawnCharmCommand.func_175762_a((String[])args, levels);
        }
        return Collections.emptyList();
    }
}

