/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.client.render.tileentity;

import com.someguyssoftware.treasure2.client.model.ITreasureChestModel;
import com.someguyssoftware.treasure2.client.render.tileentity.ITreasureChestTileEntityRenderer;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TreasureChestTileEntityRenderer
extends TileEntitySpecialRenderer<AbstractTreasureChestTileEntity>
implements ITreasureChestTileEntityRenderer {
    private ResourceLocation texture;
    private ITreasureChestModel model;

    public TreasureChestTileEntityRenderer(String texture, ITreasureChestModel model) {
        this.setTexture(new ResourceLocation("treasure2:textures/entity/chest/" + texture + ".png"));
        this.setModel(model);
    }

    public void applyDestroyGlState(int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public void popDestroyGlState(int destroyStage) {
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public void render(AbstractTreasureChestTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!(te instanceof AbstractTreasureChestTileEntity)) {
            return;
        }
        this.applyDestroyGlState(destroyStage);
        ITreasureChestModel model = this.getModel();
        this.func_147499_a(this.getTexture());
        int meta = 0;
        if (te.func_145830_o()) {
            meta = te.func_145832_p();
        }
        int rotation = this.getRotation(meta);
        GlStateManager.func_179094_E();
        this.updateTranslation(x, y, z);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.updateScale();
        this.updateModelLidRotation(te, partialTicks);
        model.renderAll(te);
        GlStateManager.func_179121_F();
        this.popDestroyGlState(destroyStage);
        if (te.getLockStates() != null && !te.getLockStates().isEmpty()) {
            this.renderLocks(te, x, y, z);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderLocks(AbstractTreasureChestTileEntity te, double x, double y, double z) {
        for (LockState lockState : te.getLockStates()) {
            if (lockState.getLock() == null) continue;
            ItemStack lockStack = new ItemStack((Item)lockState.getLock());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + lockState.getSlot().getXOffset()), (float)((float)y + lockState.getSlot().getYOffset()), (float)((float)z + lockState.getSlot().getZOffset()));
            this.updateLockRotation(lockState);
            this.updateLockScale();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(lockStack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public ITreasureChestModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(ITreasureChestModel model) {
        this.model = model;
    }
}

