/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.client.render.tileentity;

import com.someguyssoftware.treasure2.client.model.ITreasureChestModel;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public interface ITreasureChestTileEntityRenderer {
    public static final int NORTH = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int EAST = 5;

    default public int getRotation(int meta) {
        switch (meta) {
            case 2: {
                return 0;
            }
            case 3: {
                return 180;
            }
            case 4: {
                return -90;
            }
            case 5: {
                return 90;
            }
        }
        return 0;
    }

    default public void updateTranslation(double x, double y, double z) {
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
    }

    default public void updateScale() {
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
    }

    default public void updateLockScale() {
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
    }

    default public void updateLockRotation(LockState lockState) {
        GlStateManager.func_179114_b((float)lockState.getSlot().getRotation(), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    default public void updateModelLidRotation(AbstractTreasureChestTileEntity te, float partialTicks) {
        float lidRotation = te.prevLidAngle + (te.lidAngle - te.prevLidAngle) * partialTicks;
        lidRotation = 1.0f - lidRotation;
        lidRotation = 1.0f - lidRotation * lidRotation * lidRotation;
        this.getModel().getLid().field_78795_f = -(lidRotation * (float)Math.PI / this.getAngleModifier());
    }

    public ResourceLocation getTexture();

    public void setTexture(ResourceLocation var1);

    public ITreasureChestModel getModel();

    public void setModel(ITreasureChestModel var1);

    default public float getAngleModifier() {
        return 2.0f;
    }
}

