/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.google.common.collect.Maps;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.AegisCharm;
import com.someguyssoftware.treasure2.charm.CheatDeathCharm;
import com.someguyssoftware.treasure2.charm.DecayCurse;
import com.someguyssoftware.treasure2.charm.DecrepitCurse;
import com.someguyssoftware.treasure2.charm.DirtFillCurse;
import com.someguyssoftware.treasure2.charm.DirtWalkCurse;
import com.someguyssoftware.treasure2.charm.DrainCharm;
import com.someguyssoftware.treasure2.charm.FireImmunityCharm;
import com.someguyssoftware.treasure2.charm.FireResistenceCharm;
import com.someguyssoftware.treasure2.charm.GreaterHealingCharm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.IlluminationCharm;
import com.someguyssoftware.treasure2.charm.LifeStrikeCharm;
import com.someguyssoftware.treasure2.charm.ReflectionCharm;
import com.someguyssoftware.treasure2.charm.RuinCurse;
import com.someguyssoftware.treasure2.charm.SatietyCharm;
import com.someguyssoftware.treasure2.charm.ShieldingCharm;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TreasureCharms {
    public static final Map<Integer, Rarity> LEVEL_RARITY = Maps.newHashMap();

    public static void init() {
    }

    private static int getRecharges(Rarity rarity) {
        return rarity == Rarity.SCARCE || rarity == Rarity.RARE ? 1 : (rarity == Rarity.EPIC || rarity == Rarity.LEGENDARY ? 2 : (rarity == Rarity.MYTHICAL ? 3 : 1));
    }

    public static ICharm makeHealing(int level) {
        ICharm charm = new HealingCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = 1.0;
            $.frequency = Math.max(40.0, 100.0 - Math.floor((double)(level + 1) / 5.0) * 10.0);
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeGreaterHealing(int level) {
        ICharm charm = new GreaterHealingCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = 2.0;
            $.frequency = Math.max(40.0, 100.0 - Math.floor((double)(level + 1) / 5.0) * 10.0);
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeShielding(int level) {
        ICharm charm = new ShieldingCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = level < 4 ? 0.5 : (level < 7 ? 0.6 : (level < 10 ? 0.7 : 0.8));
            $.cooldown = 0.0;
            $.effectStackable = true;
            $.priority = 2;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeAegis(int level) {
        ICharm charm = new AegisCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.cooldown = Math.max(20.0, 100.0 - Math.floor((level + 1) / 5) * 10.0);
            $.effectStackable = false;
            $.priority = 2;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeFireResistence(int level) {
        ICharm charm = new FireResistenceCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = level < 6 ? 0.3 : (level < 11 ? 0.5 : 0.8);
            $.amount = level <= 4 ? 0.2 : (level <= 8 ? 0.4 : (level <= 12 ? 0.6 : 0.8));
            $.effectStackable = true;
            $.priority = 1;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeFireImmunity(int level) {
        ICharm charm = new FireImmunityCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.effectStackable = false;
            $.priority = 1;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeSatiety(int level) {
        ICharm charm = new SatietyCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = 1.0;
            $.frequency = Math.max(20.0, 100.0 - Math.floor((level + 1) / 5) * 20.0);
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeLifeStrike(int level) {
        LifeStrikeCharm.Builder builder = (LifeStrikeCharm.Builder)new LifeStrikeCharm.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = level < 4 ? 0.2 : (level < 7 ? 0.4 : (level < 10 ? 0.6 : (level < 13 ? 0.8 : 1.0)));
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        });
        ICharm charm = builder.withLifeCost(2.0).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeReflection(int level) {
        ICharm charm = new ReflectionCharm.Builder(level).with($ -> {
            $.mana = level < 8 ? (double)level * 10.0 + 10.0 : (double)(level - 7) * 10.0 + 10.0;
            $.amount = level < 3 ? 0.2 : (level < 5 ? 0.35 : (level < 7 ? 0.5 : (level < 9 ? 0.65 : (level < 11 ? 0.8 : (level < 13 ? 0.95 : 1.1)))));
            $.range = level < 4 ? 2.0 : (level < 7 ? 3.0 : (level < 10 ? 4.0 : (level < 13 ? 5.0 : 6.0)));
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeDrain(int level) {
        ICharm charm = new DrainCharm.Builder(level).with($ -> {
            $.mana = level < 8 ? (double)level * 10.0 + 10.0 : (double)(level - 7) * 10.0 + 10.0;
            $.frequency = Math.max(20.0, 100.0 - Math.floor((level + 1) / 5) * 20.0);
            $.range = level < 4 ? 2.0 : (level < 7 ? 3.0 : (level < 10 ? 4.0 : (level < 13 ? 5.0 : 6.0)));
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = TreasureCharms.getRecharges($.rarity);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeIllumination(int level) {
        ICharm charm = new IlluminationCharm.Builder(level).with($ -> {
            $.mana = (double)Math.max(1, level / 3) * 3.0;
            $.effectStackable = false;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeCheatDeath(int level) {
        ICharm charm = new CheatDeathCharm.Builder(level).with($ -> {
            $.mana = level;
            $.amount = 5.0 + Math.floor((double)level / 5.0);
            $.effectStackable = false;
            $.rarity = LEVEL_RARITY.get(level);
            $.recharges = 0;
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ICharm makeDecay(int level) {
        ICharm curse = new DecayCurse.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = 1.0;
            $.frequency = Math.max(40.0, 100.0 - Math.floor((double)(level + 1) / 5.0) * 10.0);
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(curse);
        return curse;
    }

    public static ICharm makeDecrepit(int level) {
        ICharm curse = new DecrepitCurse.Builder(level).with($ -> {
            $.mana = (double)level * 10.0 + 10.0;
            $.amount = level <= 4 ? 0.2 : (level <= 8 ? 0.3 : (level <= 12 ? 0.4 : 0.5));
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(curse);
        return curse;
    }

    public static ICharm makeDirtFill(int level) {
        ICharm curse = new DirtFillCurse.Builder(level).with($ -> {
            $.mana = (double)level * 25.0;
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(curse);
        return curse;
    }

    public static ICharm makeDirtWalk(int level) {
        ICharm curse = new DirtWalkCurse.Builder(level).with($ -> {
            $.mana = (double)level * 25.0;
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(curse);
        return curse;
    }

    public static ICharm makeRuin(int level) {
        ICharm charm = new RuinCurse.Builder(level).with($ -> {
            $.mana = (double)level * 20.0;
            $.amount = 1.0;
            $.frequency = Math.max(40.0, 100.0 - Math.floor((double)(level + 1) / 5.0) * 10.0);
            $.effectStackable = true;
            $.rarity = LEVEL_RARITY.get(level);
        }).build();
        TreasureCharmRegistry.register(charm);
        return charm;
    }

    public static ItemStack copyStack(ItemStack source, ItemStack dest) {
        ItemStack resultStack = dest.func_77946_l();
        ResourceLocation sourceItem = ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).getSourceItem();
        if (dest.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).clearCharms();
            ((ICharmableCapability)source.getCapability(TreasureCapabilities.CHARMABLE, null)).copyTo(resultStack);
        }
        ((ICharmableCapability)resultStack.getCapability(TreasureCapabilities.CHARMABLE, null)).setSourceItem(sourceItem);
        return resultStack;
    }

    public static void setHoverName(ItemStack stack) {
        if (stack.hasCapability(TreasureCapabilities.CHARMABLE, null)) {
            // empty if block
        }
    }

    static {
        Treasure.LOGGER.debug("creating charms...");
        for (int level = 1; level <= 25; ++level) {
            LEVEL_RARITY.put(level, level <= 4 ? Rarity.COMMON : (level <= 8 ? Rarity.UNCOMMON : (level <= 12 ? Rarity.SCARCE : (level <= 16 ? Rarity.RARE : (level <= 20 ? Rarity.EPIC : (level <= 24 ? Rarity.LEGENDARY : Rarity.MYTHICAL))))));
            TreasureCharmRegistry.register(TreasureCharms.makeHealing(level));
            TreasureCharmRegistry.register(TreasureCharms.makeGreaterHealing(level));
            TreasureCharmRegistry.register(TreasureCharms.makeShielding(level));
            TreasureCharmRegistry.register(TreasureCharms.makeAegis(level));
            TreasureCharmRegistry.register(TreasureCharms.makeFireResistence(level));
            TreasureCharmRegistry.register(TreasureCharms.makeFireImmunity(level));
            TreasureCharmRegistry.register(TreasureCharms.makeSatiety(level));
            TreasureCharmRegistry.register(TreasureCharms.makeLifeStrike(level));
            TreasureCharmRegistry.register(TreasureCharms.makeReflection(level));
            TreasureCharmRegistry.register(TreasureCharms.makeDrain(level));
            TreasureCharmRegistry.register(TreasureCharms.makeIllumination(level));
            TreasureCharmRegistry.register(TreasureCharms.makeDecay(level));
            TreasureCharmRegistry.register(TreasureCharms.makeDecrepit(level));
            TreasureCharmRegistry.register(TreasureCharms.makeDirtFill(level));
            TreasureCharmRegistry.register(TreasureCharms.makeDirtWalk(level));
            TreasureCharmRegistry.register(TreasureCharms.makeRuin(level));
            TreasureCharmRegistry.register(TreasureCharms.makeCheatDeath(level));
        }
    }
}

