/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReflectionCharm
extends Charm {
    public static String REFLECTION_TYPE = "reflection";
    private static final Class<?> REGISTERED_EVENT = LivingHurtEvent.class;

    ReflectionCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (entity.getMana() > 0.0 && !player.field_70128_L && ((LivingHurtEvent)event).getEntity() instanceof EntityPlayer) {
            double px = player.field_70165_t;
            double py = player.field_70163_u;
            double pz = player.field_70161_v;
            double amount = ((LivingHurtEvent)event).getAmount();
            double reflectedAmount = amount * entity.getAmount();
            double range = entity.getRange();
            List mobs = world.func_72872_a(EntityMob.class, new AxisAlignedBB(px - range, py - range, pz - range, px + range, py + range, pz + range));
            mobs.forEach(mob -> {
                boolean flag = mob.func_70097_a(DamageSource.field_76377_j, (float)reflectedAmount);
                Treasure.LOGGER.debug("reflected damage {} onto mob -> {} was successful -> {}", (Object)reflectedAmount, (Object)mob.func_70005_c_(), (Object)flag);
            });
            this.applyCost(world, random, coords, player, event, entity, reflectedAmount);
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.reflection", (Object[])new Object[]{Math.toIntExact((long)(entity.getAmount() * 100.0)), entity.getRange()});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(REFLECTION_TYPE, level)), REFLECTION_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new ReflectionCharm(this);
        }
    }
}

