/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HealingCharm
extends Charm {
    public static String TYPE = "healing";
    private static float HEAL_RATE = 1.0f;
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    HealingCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if ((double)world.func_82737_E() % entity.getFrequency() == 0.0 && entity.getMana() > 0.0 && player.func_110143_aJ() < player.func_110138_aP() && !player.field_70128_L) {
            float amount = Math.min((float)this.getAmount(), player.func_110138_aP() - player.func_110143_aJ());
            player.func_70606_j(MathHelper.func_76131_a((float)(player.func_110143_aJ() + amount), (float)0.0f, (float)player.func_110138_aP()));
            this.applyCost(world, random, coords, player, event, entity, amount);
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.healing", (Object[])new Object[]{DECIMAL_FORMAT.format(this.getAmount() / 2.0), (int)(entity.getFrequency() / 20.0)});
    }

    public static class Costinator
    implements ICostEvaluator {
        @Override
        public double apply(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity, double amount) {
            double cost = amount;
            if (entity.getMana() < amount) {
                cost = entity.getMana();
            }
            double remaining = entity.getMana() - cost;
            entity.setMana(MathHelper.func_151237_a((double)remaining, (double)0.0, (double)entity.getMana()));
            return cost;
        }
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(TYPE, level)), TYPE, level);
            this.costEvaluator = new Costinator();
        }

        @Override
        public ICharm build() {
            return new HealingCharm(this);
        }
    }
}

