/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.HealingCharm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.IHealing;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GreaterHealingCharm
extends Charm
implements IHealing {
    public static String HEALING_TYPE = "greater_healing";
    private static float HEAL_RATE = 2.0f;
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    GreaterHealingCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public float getHealRate() {
        return HEAL_RATE;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if ((double)world.func_82737_E() % entity.getFrequency() == 0.0 && entity.getMana() > 0.0 && player.func_110143_aJ() < player.func_110138_aP() && !player.field_70128_L) {
            float amount = Math.min(this.getHealRate(), player.func_110138_aP() - player.func_110143_aJ());
            player.func_70606_j(MathHelper.func_76131_a((float)(player.func_110143_aJ() + amount), (float)0.0f, (float)player.func_110138_aP()));
            this.applyCost(world, random, coords, player, event, entity, amount);
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.greater_healing", (Object[])new Object[]{(int)(entity.getFrequency() / 20.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(HEALING_TYPE, level)), HEALING_TYPE, level);
            this.costEvaluator = new HealingCharm.Costinator();
        }

        @Override
        public ICharm build() {
            return new GreaterHealingCharm(this);
        }
    }
}

