/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class FireImmunityCharm
extends Charm {
    public static final String FIRE_IMMUNITY_TYPE = "fire_immunity";
    private static final Class<?> REGISTERED_EVENT = LivingDamageEvent.class;

    FireImmunityCharm(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if (!((LivingDamageEvent)event).getSource().func_76347_k()) {
            return result;
        }
        double newAmount = 0.0;
        if (entity.getMana() > 0.0 && !player.field_70128_L) {
            double amount = ((LivingDamageEvent)event).getAmount();
            double cost = this.applyCost(world, random, coords, player, event, entity, amount);
            if (cost < amount) {
                newAmount = amount - cost;
            }
            ((LivingDamageEvent)event).setAmount((float)newAmount);
            result = true;
        }
        return result;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.fire_immunity", (Object[])new Object[0]);
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(FireImmunityCharm.FIRE_IMMUNITY_TYPE, level)), FireImmunityCharm.FIRE_IMMUNITY_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new FireImmunityCharm(this);
        }
    }
}

