/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.google.common.collect.Lists;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DirtFillCurse
extends Charm {
    public static final String DIRT_FILL_TYPE = "dirt_fill";
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    DirtFillCurse(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean isCurse() {
        return true;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        List<Integer> emptySlots;
        boolean result = false;
        if (world.func_82737_E() % 200L == 0L && !player.field_70128_L && entity.getMana() > 0.0 && (emptySlots = this.getEmptySlotsRandomized((IInventory)player.field_71071_by, random)) != null && !emptySlots.isEmpty()) {
            player.field_71071_by.func_70299_a(emptySlots.get(emptySlots.size() - 1).intValue(), new ItemStack(Blocks.field_150346_d, 1));
            this.applyCost(world, random, coords, player, event, entity, 1.0);
            result = true;
        }
        return result;
    }

    @Override
    public TextFormatting getCharmLabelColor() {
        return TextFormatting.DARK_RED;
    }

    private List<Integer> getEmptySlotsRandomized(IInventory inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < Math.min(36, inventory.func_70302_i_()); ++i) {
            if (!inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(DirtFillCurse.DIRT_FILL_TYPE, level)), DirtFillCurse.DIRT_FILL_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new DirtFillCurse(this);
        }
    }
}

