/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DecayCurse
extends Charm {
    public static String DECAY_TYPE = "decay";
    private static float DECAY_RATE = 2.0f;
    private static final Class<?> REGISTERED_EVENT = LivingEvent.LivingUpdateEvent.class;

    DecayCurse(Builder builder) {
        super(builder);
    }

    @Override
    public boolean isCurse() {
        return true;
    }

    @Override
    public Class<?> getRegisteredEvent() {
        return REGISTERED_EVENT;
    }

    @Override
    public boolean update(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity) {
        boolean result = false;
        if ((double)world.func_82737_E() % entity.getFrequency() == 0.0 && !player.field_70128_L && entity.getMana() > 0.0 && (double)player.func_110143_aJ() > 0.0) {
            player.func_70606_j(MathHelper.func_76131_a((float)(player.func_110143_aJ() - (float)this.getAmount()), (float)0.0f, (float)player.func_110138_aP()));
            this.applyCost(world, random, coords, player, event, entity, this.getAmount());
            result = true;
        }
        return result;
    }

    @Override
    public TextFormatting getCharmLabelColor() {
        return TextFormatting.DARK_RED;
    }

    @Override
    public String getCharmDesc(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.rate.decay", (Object[])new Object[]{DECIMAL_FORMAT.format(this.getAmount() / 2.0), DECIMAL_FORMAT.format(entity.getFrequency() / 20.0)});
    }

    public static class Builder
    extends Charm.Builder {
        public Builder(Integer level) {
            super(ResourceLocationUtil.create(Builder.makeName(DECAY_TYPE, level)), DECAY_TYPE, level);
        }

        @Override
        public ICharm build() {
            return new DecayCurse(this);
        }
    }
}

