/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CharmEntity
implements ICharmEntity {
    private ICharm charm;
    private double mana;
    private int duration;
    private double frequency;
    private double range;
    private double cooldown;
    private double amount;
    private boolean exclusive;
    private ICostEvaluator costEvaluator;
    private double maxMana;
    private int recharges;
    private int maxRecharges;

    public CharmEntity() {
    }

    public CharmEntity(ICharm charm) {
        this.setCharm(charm);
        this.setAmount(charm.getAmount());
        this.setCooldown(charm.getCooldown());
        this.setDuration(charm.getDuration());
        this.setFrequency(charm.getFrequency());
        this.setMana(charm.getMana());
        this.setRange(charm.getRange());
        this.setCostEvaluator(charm.getCostEvaluator());
        this.setMaxMana(charm.getMana());
        this.setExclusive(charm.isExclusive());
        this.setRecharges(charm.getRecharges());
        this.setMaxRecharges(charm.getRecharges());
    }

    public CharmEntity(ICharmEntity entity) {
        this.setCharm(entity.getCharm());
        this.setAmount(entity.getAmount());
        this.setCooldown(entity.getCooldown());
        this.setDuration(entity.getDuration());
        this.setFrequency(entity.getFrequency());
        this.setMana(entity.getMana());
        this.setRange(entity.getRange());
        this.setCostEvaluator(entity.getCostEvaluator());
        this.setMaxMana(entity.getMaxMana());
        this.setExclusive(entity.isExclusive());
        this.setRecharges(entity.getRecharges());
        this.setMaxRecharges(entity.getRecharges());
    }

    @Override
    public void update(ICharmEntity entity) {
        this.setMana(entity.getMana());
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagCompound charmNbt = new NBTTagCompound();
        nbt.func_74782_a("charm", (NBTBase)this.getCharm().save(charmNbt));
        nbt.func_74780_a("mana", this.getMana());
        nbt.func_74768_a("duration", this.getDuration());
        nbt.func_74780_a("frequency", this.getFrequency());
        nbt.func_74780_a("amount", this.getAmount());
        nbt.func_74780_a("cooldown", this.getCooldown());
        nbt.func_74780_a("range", this.getRange());
        if (this.getCostEvaluator() != null) {
            NBTTagCompound ceNbt = new NBTTagCompound();
            this.getCostEvaluator().save(ceNbt);
            nbt.func_74782_a("costEvaluator", (NBTBase)ceNbt);
        }
        nbt.func_74780_a("maxMana", this.getMaxMana());
        nbt.func_74757_a("exclusive", this.isExclusive());
        nbt.func_74768_a("recharges", this.getRecharges());
        nbt.func_74768_a("maxRecharges", this.getMaxRecharges());
        return nbt;
    }

    @Override
    public ICharm getCharm() {
        return this.charm;
    }

    @Override
    public void setCharm(ICharm charm) {
        this.charm = charm;
    }

    @Override
    public double getMana() {
        return this.mana;
    }

    @Override
    public void setMana(double value) {
        this.mana = value;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public String toString() {
        return "CharmEntity [charm=" + this.charm + ", mana=" + this.mana + ", duration=" + this.duration + ", frequency=" + this.frequency + ", range=" + this.range + ", cooldown=" + this.cooldown + ", amount=" + this.amount + ", costEvaluator=" + this.costEvaluator + ", maxMana=" + this.maxMana + "]";
    }

    @Override
    public double getRange() {
        return this.range;
    }

    @Override
    public void setRange(double range) {
        this.range = range;
    }

    @Override
    public double getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(double cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Override
    public ICostEvaluator getCostEvaluator() {
        return this.costEvaluator;
    }

    @Override
    public void setCostEvaluator(ICostEvaluator costEvaluator) {
        this.costEvaluator = costEvaluator;
    }

    @Override
    public double getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(double maxMana) {
        this.maxMana = maxMana;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    @Override
    public int getRecharges() {
        return this.recharges;
    }

    @Override
    public void setRecharges(int recharges) {
        this.recharges = recharges;
    }

    @Override
    public int getMaxRecharges() {
        return this.maxRecharges;
    }

    @Override
    public void setMaxRecharges(int maxRecharges) {
        this.maxRecharges = maxRecharges;
    }
}

