/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.charm;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.charm.CharmEntity;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.charm.TreasureCharmRegistry;
import com.someguyssoftware.treasure2.charm.cost.CostEvaluator;
import com.someguyssoftware.treasure2.charm.cost.ICostEvaluator;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Charm
implements ICharm {
    protected static DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.#");
    public static final int TICKS_PER_SECOND = 20;
    public static final TextFormatting CHARM_COLOR = TextFormatting.AQUA;
    public static final TextFormatting CHARM_DESC_COLOR = TextFormatting.GRAY;
    private ResourceLocation name;
    private String type;
    private int level;
    private Rarity rarity;
    private int priority;
    private double mana;
    private int duration;
    private double frequency;
    private double range;
    private double cooldown;
    private double amount;
    @Deprecated
    private boolean exclusive;
    private int recharges;
    private ICostEvaluator costEvaluator;
    private boolean effectStackable = false;

    protected Charm(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.level = builder.level;
        this.mana = builder.mana;
        this.duration = builder.duration.intValue();
        this.frequency = builder.frequency;
        this.amount = builder.amount;
        this.cooldown = builder.cooldown;
        this.range = builder.range;
        this.effectStackable = builder.effectStackable;
        this.costEvaluator = builder.costEvaluator;
        this.rarity = builder.rarity;
        this.recharges = builder.recharges;
    }

    @Override
    public abstract Class<?> getRegisteredEvent();

    @Override
    public ICharmEntity createEntity() {
        CharmEntity entity = new CharmEntity();
        entity.setCharm(this);
        entity.setAmount(this.amount);
        entity.setCooldown(this.cooldown);
        entity.setDuration(this.duration);
        entity.setFrequency(this.frequency);
        entity.setMana(this.mana);
        entity.setMaxMana(this.mana);
        entity.setRange(this.range);
        entity.setExclusive(this.exclusive);
        entity.setRecharges(this.recharges);
        entity.setMaxRecharges(this.recharges);
        return entity;
    }

    @Override
    public ICharmEntity createEntity(ICharmEntity entity) {
        CharmEntity newEntity = new CharmEntity(entity);
        return newEntity;
    }

    @Override
    public boolean isCurse() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag, ICharmEntity entity, InventoryType type) {
        boolean showRecharges = type == InventoryType.SOCKET;
        tooltip.add(this.getLabel(entity, showRecharges));
        tooltip.add(this.getDesc(entity));
    }

    public String getLabel(ICharmEntity entity, boolean showRecharges) {
        return this.getCharmLabelColor() + "" + I18n.func_74837_a((String)"tooltip.indent2", (Object[])new Object[]{I18n.func_74837_a((String)("tooltip.charm.type." + this.getType().toLowerCase()), (Object[])new Object[0]) + " " + String.valueOf(this.getLevel()) + " " + this.getUsesGauge(entity) + (showRecharges && entity.getRecharges() > 0 ? " " + this.getRecharges(entity) : "") + " " + (this.effectStackable ? "+" : "-")});
    }

    public String getRecharges(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.recharges", (Object[])new Object[]{entity.getRecharges(), entity.getMaxRecharges()});
    }

    public String getDesc(ICharmEntity entity) {
        return this.getCharmDescColor() + "" + TextFormatting.ITALIC + I18n.func_74837_a((String)"tooltip.indent4", (Object[])new Object[]{this.getCharmDesc(entity)});
    }

    public String getCharmDesc(ICharmEntity entity) {
        return "";
    }

    public String getUsesGauge(ICharmEntity entity) {
        return I18n.func_74837_a((String)"tooltip.charm.uses_gauge", (Object[])new Object[]{String.valueOf(Math.toIntExact(Math.round(entity.getMana()))), String.valueOf(Math.toIntExact((long)Math.ceil(entity.getMaxMana())))});
    }

    public static Optional<ICharm> load(NBTTagCompound tag) {
        Optional<ICharm> charm = Optional.empty();
        try {
            String charmName = tag.func_74779_i("name");
            ResourceLocation resource = ResourceLocationUtil.create(charmName);
            charm = TreasureCharmRegistry.get(resource);
            if (!charm.isPresent()) {
                throw new Exception(String.format("Unable to locate charm %s in registry.", resource.toString()));
            }
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to read state to NBT:", (Throwable)e);
        }
        return charm;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        try {
            nbt.func_74778_a("name", this.name.toString());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    public double applyCost(World world, Random random, ICoords coords, EntityPlayer player, Event event, ICharmEntity entity, double amount) {
        if (entity.getCostEvaluator() != null) {
            return entity.getCostEvaluator().apply(world, random, coords, player, event, entity, amount);
        }
        Treasure.LOGGER.debug("Charm does not have a cost eval.");
        entity.setMana(MathHelper.func_151237_a((double)(entity.getMana() - 1.0), (double)0.0, (double)entity.getMana()));
        return amount;
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getMana() {
        return this.mana;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    @Override
    public boolean isEffectStackable() {
        return this.effectStackable;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public int getRecharges() {
        return this.recharges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.cooldown);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.costEvaluator == null ? 0 : this.costEvaluator.hashCode());
        result = 31 * result + this.duration;
        result = 31 * result + (this.effectStackable ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.frequency);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.level;
        temp = Double.doubleToLongBits(this.mana);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.priority;
        temp = Double.doubleToLongBits(this.range);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rarity == null ? 0 : this.rarity.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Charm other = (Charm)obj;
        if (Double.doubleToLongBits(this.amount) != Double.doubleToLongBits(other.amount)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cooldown) != Double.doubleToLongBits(other.cooldown)) {
            return false;
        }
        if (this.costEvaluator == null ? other.costEvaluator != null : !this.costEvaluator.equals(other.costEvaluator)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.effectStackable != other.effectStackable) {
            return false;
        }
        if (Double.doubleToLongBits(this.frequency) != Double.doubleToLongBits(other.frequency)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (Double.doubleToLongBits(this.mana) != Double.doubleToLongBits(other.mana)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (Double.doubleToLongBits(this.range) != Double.doubleToLongBits(other.range)) {
            return false;
        }
        if (this.rarity != other.rarity) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public double getRange() {
        return this.range;
    }

    @Override
    public double getCooldown() {
        return this.cooldown;
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public ICostEvaluator getCostEvaluator() {
        return this.costEvaluator;
    }

    @Override
    public TextFormatting getCharmLabelColor() {
        return CHARM_COLOR;
    }

    @Override
    public TextFormatting getCharmDescColor() {
        return CHARM_DESC_COLOR;
    }

    public String toString() {
        return "Charm [name=" + this.name + ", type=" + this.type + ", level=" + this.level + ", rarity=" + this.rarity + ", priority=" + this.priority + ", mana=" + this.mana + ", duration=" + this.duration + ", frequency=" + this.frequency + ", range=" + this.range + ", cooldown=" + this.cooldown + ", amount=" + this.amount + ", exclusive=" + this.exclusive + ", recharges=" + this.recharges + ", effectStackable=" + this.effectStackable + "]";
    }

    public static abstract class Builder {
        public ResourceLocation name;
        public final String type;
        public final Integer level;
        public Double mana = 0.0;
        public Double duration = 0.0;
        public Double frequency = 0.0;
        public Double amount = 1.0;
        public Double cooldown = 0.0;
        public Double range = 0.0;
        public Rarity rarity = Rarity.COMMON;
        public int priority = 10;
        public boolean effectStackable = false;
        public boolean exclusive = false;
        public int recharges = 0;
        public ICostEvaluator costEvaluator;

        public Builder(ResourceLocation name, String type, Integer level) {
            this.name = name;
            this.type = type;
            this.level = level;
            this.costEvaluator = new CostEvaluator();
        }

        public abstract ICharm build();

        public static String makeName(String type, int level) {
            return type + "_" + level;
        }

        public Builder with(Consumer<Builder> builder) {
            builder.accept(this);
            return this;
        }

        public Builder withMana(Double mana) {
            this.mana = mana;
            return this;
        }

        public Builder withDuration(Double duration) {
            this.duration = duration;
            return this;
        }

        public Builder withEffectStackable(boolean stackable) {
            this.effectStackable = stackable;
            return this;
        }

        public Builder withFrequency(Double frequency) {
            this.frequency = frequency;
            return this;
        }

        public String toString() {
            return "Builder [name=" + this.name + ", type=" + this.type + ", level=" + this.level + ", mana=" + this.mana + ", duration=" + this.duration + ", frequency=" + this.frequency + ", amount=" + this.amount + ", cooldown=" + this.cooldown + ", range=" + this.range + ", rarity=" + this.rarity + ", priority=" + this.priority + ", effectStackable=" + this.effectStackable + ", exclusive=" + this.exclusive + ", recharges=" + this.recharges + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
            result = 31 * result + (this.cooldown == null ? 0 : this.cooldown.hashCode());
            result = 31 * result + (this.costEvaluator == null ? 0 : this.costEvaluator.hashCode());
            result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
            result = 31 * result + (this.effectStackable ? 1231 : 1237);
            result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
            result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
            result = 31 * result + (this.mana == null ? 0 : this.mana.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.priority;
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + (this.rarity == null ? 0 : this.rarity.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.amount == null ? other.amount != null : !this.amount.equals(other.amount)) {
                return false;
            }
            if (this.cooldown == null ? other.cooldown != null : !this.cooldown.equals(other.cooldown)) {
                return false;
            }
            if (this.costEvaluator == null ? other.costEvaluator != null : !this.costEvaluator.equals(other.costEvaluator)) {
                return false;
            }
            if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
                return false;
            }
            if (this.effectStackable != other.effectStackable) {
                return false;
            }
            if (this.frequency == null ? other.frequency != null : !this.frequency.equals(other.frequency)) {
                return false;
            }
            if (this.level == null ? other.level != null : !this.level.equals(other.level)) {
                return false;
            }
            if (this.mana == null ? other.mana != null : !this.mana.equals(other.mana)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
                return false;
            }
            if (this.priority != other.priority) {
                return false;
            }
            if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
                return false;
            }
            if (this.rarity != other.rarity) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

