/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.InventoryType;
import com.someguyssoftware.treasure2.capability.modifier.ILevelModifier;
import com.someguyssoftware.treasure2.charm.Charm;
import com.someguyssoftware.treasure2.charm.ICharm;
import com.someguyssoftware.treasure2.charm.ICharmEntity;
import com.someguyssoftware.treasure2.util.ResourceLocationUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class CharmableCapabilityStorage
implements Capability.IStorage<ICharmableCapability> {
    private static final String SOURCE = "source";
    private static final String EXECUTING = "executing";
    private static final String BINDABLE = "bindable";
    private static final String INNATE = "innate";
    private static final String IMBUABLE = "imbuable";
    private static final String IMBUING = "imbuing";
    private static final String SOCKETABLE = "socketable";
    private static final String BASE_MATERIAL = "baseMaterial";
    private static final String SOURCE_ITEM = "sourceItem";
    private static final String MAX_CHARM_LEVEL = "maxCharmLevel";
    private static final String NAMED_BY_MATERIAL = "namedByMaterial";
    private static final String NAMED_BY_CHARM = "namedByCharm";
    private static final String LEVEL_MODIFIER = "levelModifier";
    private static final String MAX_SOCKET_SIZE = "maxSocketSize";

    public NBTBase writeNBT(Capability<ICharmableCapability> capability, ICharmableCapability instance, EnumFacing side) {
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            for (InventoryType type : InventoryType.values()) {
                List entityList = (List)instance.getCharmEntities().get((Object)type);
                if (entityList == null || entityList.isEmpty()) continue;
                NBTTagList listNbt = new NBTTagList();
                for (ICharmEntity entity : entityList) {
                    NBTTagCompound entityNbt = new NBTTagCompound();
                    listNbt.func_74742_a((NBTBase)entity.save(entityNbt));
                }
                nbt.func_74782_a(type.name(), (NBTBase)listNbt);
            }
            nbt.func_74757_a(SOURCE, instance.isSource());
            nbt.func_74757_a(EXECUTING, instance.isExecuting());
            nbt.func_74757_a(BINDABLE, instance.isBindable());
            nbt.func_74757_a(INNATE, instance.isInnate());
            nbt.func_74757_a(IMBUABLE, instance.isImbuable());
            nbt.func_74757_a(IMBUING, instance.isImbuing());
            nbt.func_74757_a(SOCKETABLE, instance.isSocketable());
            nbt.func_74778_a(BASE_MATERIAL, instance.getBaseMaterial().toString());
            nbt.func_74778_a(SOURCE_ITEM, instance.getSourceItem().toString());
            nbt.func_74757_a(NAMED_BY_MATERIAL, instance.isNamedByMaterial());
            nbt.func_74757_a(NAMED_BY_CHARM, instance.isNamedByCharm());
            nbt.func_74778_a(LEVEL_MODIFIER, instance.getLevelModifier().getClass().getName());
            nbt.func_74768_a(MAX_SOCKET_SIZE, instance.getMaxSocketSize());
        }
        catch (Exception e) {
            Treasure.LOGGER.error("Unable to write state to NBT:", (Throwable)e);
        }
        return nbt;
    }

    public void readNBT(Capability<ICharmableCapability> capability, ICharmableCapability instance, EnumFacing side, NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            for (InventoryType type : InventoryType.values()) {
                instance.getCharmEntities().get((Object)type).clear();
                if (tag.func_74764_b(type.name())) {
                    NBTTagList listNbt = tag.func_150295_c(type.name(), 10);
                    listNbt.forEach(e -> {
                        Optional<ICharm> charm = Charm.load(((NBTTagCompound)e).func_74775_l("charm"));
                        if (!charm.isPresent()) {
                            return;
                        }
                        ICharmEntity entity = charm.get().createEntity();
                        entity.load((NBTTagCompound)e);
                        instance.getCharmEntities().get((Object)type).add(entity);
                    });
                }
                if (tag.func_74764_b(SOURCE)) {
                    instance.setSource(tag.func_74767_n(SOURCE));
                }
                if (tag.func_74764_b(EXECUTING)) {
                    instance.setExecuting(tag.func_74767_n(EXECUTING));
                }
                if (tag.func_74764_b(BINDABLE)) {
                    instance.setBindable(tag.func_74767_n(BINDABLE));
                }
                if (tag.func_74764_b(INNATE)) {
                    instance.setInnate(tag.func_74767_n(INNATE));
                }
                if (tag.func_74764_b(IMBUABLE)) {
                    instance.setImbuable(tag.func_74767_n(IMBUABLE));
                }
                if (tag.func_74764_b(IMBUING)) {
                    instance.setImbuing(tag.func_74767_n(IMBUING));
                }
                if (tag.func_74764_b(SOCKETABLE)) {
                    instance.setSocketable(tag.func_74767_n(SOCKETABLE));
                }
                if (tag.func_74764_b(BASE_MATERIAL)) {
                    instance.setBaseMaterial(ResourceLocationUtil.create(tag.func_74779_i(BASE_MATERIAL)));
                }
                if (tag.func_74764_b(SOURCE_ITEM)) {
                    instance.setSourceItem(ResourceLocationUtil.create(tag.func_74779_i(SOURCE_ITEM)));
                }
                if (tag.func_74764_b(NAMED_BY_MATERIAL)) {
                    instance.setNamedByMaterial(tag.func_74767_n(NAMED_BY_MATERIAL));
                }
                if (tag.func_74764_b(NAMED_BY_CHARM)) {
                    instance.setNamedByCharm(tag.func_74767_n(NAMED_BY_CHARM));
                }
                if (tag.func_74764_b(LEVEL_MODIFIER)) {
                    try {
                        ILevelModifier levelModifier = (ILevelModifier)Class.forName(tag.func_74779_i(LEVEL_MODIFIER)).newInstance();
                        instance.setLevelModifier(levelModifier);
                    }
                    catch (Exception e2) {
                        Treasure.LOGGER.warn("unable to create level modifier -> {}", (Object)tag.func_74779_i(LEVEL_MODIFIER));
                    }
                }
                if (!tag.func_74764_b(MAX_SOCKET_SIZE)) continue;
                instance.setMaxSocketSize(tag.func_74762_e(MAX_SOCKET_SIZE));
            }
        } else {
            Treasure.LOGGER.warn("Not a tag compound!");
        }
    }
}

