/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.capability;

import com.someguyssoftware.treasure2.capability.CharmableCapability;
import com.someguyssoftware.treasure2.capability.DurabilityCapability;
import com.someguyssoftware.treasure2.capability.ICharmableCapability;
import com.someguyssoftware.treasure2.capability.IDurabilityCapability;
import com.someguyssoftware.treasure2.capability.IRunestonesCapability;
import com.someguyssoftware.treasure2.capability.RunestonesCapability;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class AdornmentCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    private final ICharmableCapability charmableCap;
    private final IDurabilityCapability durabilityCap;
    private final IRunestonesCapability runestonesCap;

    public AdornmentCapabilityProvider() {
        this.charmableCap = new CharmableCapability(0, 0, 0);
        this.durabilityCap = new DurabilityCapability(100, 100);
        this.runestonesCap = new RunestonesCapability(0, 0, 0);
    }

    @Deprecated
    public AdornmentCapabilityProvider(ICharmableCapability charmableCap) {
        this.charmableCap = charmableCap;
        this.durabilityCap = new DurabilityCapability(100, 100);
        this.runestonesCap = new RunestonesCapability(0, 0, 0);
    }

    public AdornmentCapabilityProvider(ICharmableCapability charmableCap, IDurabilityCapability durabilityCap) {
        this.charmableCap = charmableCap;
        this.durabilityCap = durabilityCap;
        this.runestonesCap = new RunestonesCapability(0, 0, 0);
    }

    public AdornmentCapabilityProvider(ICharmableCapability charmableCap, IRunestonesCapability runestonesCap, IDurabilityCapability durabilityCap) {
        this.charmableCap = charmableCap;
        this.runestonesCap = runestonesCap;
        this.durabilityCap = durabilityCap;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == TreasureCapabilities.CHARMABLE) {
            return true;
        }
        if (capability == TreasureCapabilities.RUNESTONES) {
            return true;
        }
        return capability == TreasureCapabilities.DURABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TreasureCapabilities.CHARMABLE) {
            return (T)TreasureCapabilities.CHARMABLE.cast((Object)this.charmableCap);
        }
        if (capability == TreasureCapabilities.RUNESTONES) {
            return (T)TreasureCapabilities.RUNESTONES.cast((Object)this.runestonesCap);
        }
        if (capability == TreasureCapabilities.DURABILITY) {
            return (T)TreasureCapabilities.DURABILITY.cast((Object)this.durabilityCap);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound charmableTag = (NBTTagCompound)TreasureCapabilities.CHARMABLE.getStorage().writeNBT(TreasureCapabilities.CHARMABLE, (Object)this.charmableCap, null);
        NBTTagCompound runestonesTag = (NBTTagCompound)TreasureCapabilities.RUNESTONES.getStorage().writeNBT(TreasureCapabilities.RUNESTONES, (Object)this.runestonesCap, null);
        NBTTagCompound durabilityTag = (NBTTagCompound)TreasureCapabilities.DURABILITY.getStorage().writeNBT(TreasureCapabilities.DURABILITY, (Object)this.durabilityCap, null);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("charmable", (NBTBase)charmableTag);
        tag.func_74782_a("runestones", (NBTBase)runestonesTag);
        tag.func_74782_a("durability", (NBTBase)durabilityTag);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound tag;
        if (nbt.func_74764_b("charmable")) {
            tag = nbt.func_74775_l("charmable");
            TreasureCapabilities.CHARMABLE.getStorage().readNBT(TreasureCapabilities.CHARMABLE, (Object)this.charmableCap, null, (NBTBase)tag);
        }
        if (nbt.func_74764_b("runestones")) {
            tag = nbt.func_74775_l("runestones");
            TreasureCapabilities.RUNESTONES.getStorage().readNBT(TreasureCapabilities.RUNESTONES, (Object)this.runestonesCap, null, (NBTBase)tag);
        }
        if (nbt.func_74764_b("durability")) {
            tag = nbt.func_74775_l("durability");
            TreasureCapabilities.DURABILITY.getStorage().readNBT(TreasureCapabilities.DURABILITY, (Object)this.durabilityCap, null, (NBTBase)tag);
        }
    }
}

