/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.block.CardinalDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.block.IMistSupport;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.particle.WitherMistParticle;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WitherRootBlock
extends CardinalDirectionFacadeBlock
implements ITreasureBlock,
IMistSupport {
    public static final PropertyBool ACTIVATED = PropertyBool.func_177716_a((String)"activated");
    AxisAlignedBB[] bounds = new AxisAlignedBB[4];

    public WitherRootBlock(String modID, String name) {
        super(modID, name, Material.field_151575_d);
        this.setSoundType(SoundType.field_185848_a);
        this.func_149711_c(3.0f);
        this.setBounds(new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVATED});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        int z;
        int y;
        if (WorldInfo.isServerSide(world)) {
            return;
        }
        if (!TreasureConfig.WORLD_GEN.getGeneralProperties().enablePoisonFog) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            return;
        }
        int x = pos.func_177958_n();
        boolean isCreateParticle = this.checkTorchPrevention(world, random, x, y = pos.func_177956_o(), z = pos.func_177952_p());
        if (!isCreateParticle) {
            return;
        }
        double xPos = (double)x + 0.5 + (double)random.nextFloat() * 2.0 - 1.0;
        double yPos = (double)y + 0.125;
        double zPos = (double)z + 0.5 + (double)random.nextFloat() * 2.0 - 1.0;
        double velocityX = 0.0;
        double velocityY = 0.0;
        double velocityZ = 0.0;
        WitherMistParticle mistParticle = new WitherMistParticle(world, xPos, yPos, zPos, velocityX, velocityY, velocityZ, new Coords(pos));
        mistParticle.init();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)mistParticle);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            return this.bounds[EnumFacing.NORTH.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return this.bounds[EnumFacing.SOUTH.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            return this.bounds[EnumFacing.EAST.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return this.bounds[EnumFacing.WEST.func_176736_b()];
        }
        return this.bounds[EnumFacing.NORTH.func_176736_b()];
    }

    @Override
    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        if (RandomHelper.checkProbability(random, TreasureConfig.WITHER_TREE.witherRootItemGenProbability)) {
            return TreasureItems.WITHER_ROOT_ITEM;
        }
        return Items.field_151055_y;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta);
        return state.func_177226_a((IProperty)ACTIVATED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta = super.func_176201_c(state);
        if (((Boolean)state.func_177229_b((IProperty)ACTIVATED)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    public AxisAlignedBB[] getBounds() {
        return this.bounds;
    }

    public void setBounds(AxisAlignedBB[] bounds) {
        this.bounds = bounds;
    }
}

