/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.block;

import com.someguyssoftware.gottschcore.block.CardinalDirectionFacadeBlock;
import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.ITreasureBlock;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.PaintingItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractPaintingBlock
extends CardinalDirectionFacadeBlock
implements ITreasureBlock {
    private PaintingItem item;
    private Rarity rarity;
    AxisAlignedBB[] bounds = new AxisAlignedBB[4];

    public AbstractPaintingBlock(String modID, String name, Material material) {
        super(modID, name, material);
        this.setSoundType(SoundType.field_185848_a);
        this.func_149647_a(Treasure.TREASURE_TAB);
        this.func_149711_c(0.1f);
        this.setBoundingBox(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        this.setRarity(Rarity.SCARCE);
    }

    public AbstractPaintingBlock(String modID, String name, Material material, Rarity rarity) {
        this(modID, name, material);
        this.setRarity(rarity);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 3);
    }

    @Override
    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            return this.bounds[EnumFacing.NORTH.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            return this.bounds[EnumFacing.SOUTH.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            return this.bounds[EnumFacing.EAST.func_176736_b()];
        }
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            return this.bounds[EnumFacing.WEST.func_176736_b()];
        }
        return this.bounds[EnumFacing.NORTH.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
            AbstractPaintingBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.bounds[EnumFacing.NORTH.func_176736_b()]);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
            AbstractPaintingBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.bounds[EnumFacing.SOUTH.func_176736_b()]);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
            AbstractPaintingBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.bounds[EnumFacing.EAST.func_176736_b()]);
        } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
            AbstractPaintingBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.bounds[EnumFacing.WEST.func_176736_b()]);
        } else {
            AbstractPaintingBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.bounds[EnumFacing.NORTH.func_176736_b()]);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Cube cube = new Cube(worldIn, new Coords(pos));
        if (!cube.isAir() && !cube.isReplaceable() || cube.getState().func_177230_c() instanceof AbstractPaintingBlock) {
            return false;
        }
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    private boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState state = worldIn.func_180495_p(blockpos);
        Block block = state.func_177230_c();
        BlockFaceShape blockFaceShape = state.func_193401_d((IBlockAccess)worldIn, blockpos, facing);
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return !AbstractPaintingBlock.func_193382_c((Block)block) && blockFaceShape == BlockFaceShape.SOLID;
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing.Axis enumfacing$axis = enumfacing.func_176740_k();
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (enumfacing$axis.func_176722_c() && worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 1);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceBlock(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 1);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getItem();
    }

    public AxisAlignedBB[] getBounds() {
        return this.bounds;
    }

    public AbstractPaintingBlock setBounds(AxisAlignedBB[] bounds) {
        this.bounds = bounds;
        return this;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public void setRarity(Rarity rarity) {
        this.rarity = rarity;
    }

    public PaintingItem getItem() {
        return this.item;
    }

    public void setItem(PaintingItem item) {
        this.item = item;
    }
}

