/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.annotation.Credits;
import com.someguyssoftware.gottschcore.command.ShowVersionCommand;
import com.someguyssoftware.gottschcore.config.IConfig;
import com.someguyssoftware.gottschcore.config.ILoggerConfig;
import com.someguyssoftware.gottschcore.mod.AbstractMod;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.version.BuildVersion;
import com.someguyssoftware.treasure2.api.TreasureApi;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.capability.IKeyRingCapability;
import com.someguyssoftware.treasure2.capability.KeyRingCapability;
import com.someguyssoftware.treasure2.capability.KeyRingStorage;
import com.someguyssoftware.treasure2.capability.TreasureCapabilities;
import com.someguyssoftware.treasure2.charm.TreasureCharms;
import com.someguyssoftware.treasure2.client.gui.GuiHandler;
import com.someguyssoftware.treasure2.command.SpawnCharmCommand;
import com.someguyssoftware.treasure2.command.SpawnChestCommand;
import com.someguyssoftware.treasure2.command.SpawnPitCommand;
import com.someguyssoftware.treasure2.command.SpawnPitOnlyCommand;
import com.someguyssoftware.treasure2.command.SpawnPitStructureOnlyCommand;
import com.someguyssoftware.treasure2.command.SpawnRuinsCommand;
import com.someguyssoftware.treasure2.command.SpawnWellStructureCommand;
import com.someguyssoftware.treasure2.command.SpawnWitherTreeCommand;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.WorldGeneratorType;
import com.someguyssoftware.treasure2.eventhandler.AnvilEventHandler;
import com.someguyssoftware.treasure2.eventhandler.CharmEventHandler;
import com.someguyssoftware.treasure2.eventhandler.HotbarEquipmentCharmHandler;
import com.someguyssoftware.treasure2.eventhandler.IEquipmentCharmHandler;
import com.someguyssoftware.treasure2.eventhandler.LogoutEventHandler;
import com.someguyssoftware.treasure2.eventhandler.MimicEventHandler;
import com.someguyssoftware.treasure2.eventhandler.PlayerEventHandler;
import com.someguyssoftware.treasure2.eventhandler.WorldEventHandler;
import com.someguyssoftware.treasure2.integration.baubles.BaublesIntegration;
import com.someguyssoftware.treasure2.item.PaintingItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.loot.function.CharmRandomly;
import com.someguyssoftware.treasure2.loot.function.RandomAdornment;
import com.someguyssoftware.treasure2.loot.function.RandomCharm;
import com.someguyssoftware.treasure2.loot.function.RandomRunestone;
import com.someguyssoftware.treasure2.material.TreasureCharmableMaterials;
import com.someguyssoftware.treasure2.network.CharmMessageHandlerOnClient;
import com.someguyssoftware.treasure2.network.CharmMessageToClient;
import com.someguyssoftware.treasure2.network.PoisonMistMessageHandlerOnServer;
import com.someguyssoftware.treasure2.network.PoisonMistMessageToServer;
import com.someguyssoftware.treasure2.network.WitherMistMessageHandlerOnServer;
import com.someguyssoftware.treasure2.network.WitherMistMessageToServer;
import com.someguyssoftware.treasure2.worldgen.GemOreWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SubmergedChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WellWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WitherTreeWorldGenerator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

@Mod(modid="treasure2", name="Treasure2", version="2.1.1", dependencies="required-after:gottschcore@[1.15.0,)", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Treasure/master/update.json")
@Credits(values={"Treasure was first developed by Mark Gottschling on Aug 27, 2014.", "Treasure2 was first developed by Mark Gottschling on Jan 2018.", "Credits to Mason Gottschling for ideas and debugging.", "Credits to CuddleBeak for some Keys and Locks textures.", "Credits to mn_ti for Chinese and to DarkKnightComes for Polish translation.", "Credits to Mythical Sausage for tutorials on house/tower designs.", "Credits to OdinsRagnarok for Spanish translation and DarvinSlav for Russian translation.", "Credits to sfs131010 for updated Chinese translation.", "Credits to Xemnes for updated textures for locks, keys, adornments, gems, ores."})
public class Treasure
extends AbstractMod {
    public static final String MODID = "treasure2";
    protected static final String NAME = "Treasure2";
    protected static final String VERSION = "2.1.1";
    public static final String UPDATE_JSON_URL = "https://raw.githubusercontent.com/gottsch/gottsch-minecraft-Treasure/master/update.json";
    private static final String VERSION_URL = "";
    private static final BuildVersion MINECRAFT_VERSION = new BuildVersion(1, 12, 2);
    private static BuildVersion latestVersion;
    public static final Logger LOGGER;
    @Mod.Instance(value="treasure2")
    public static Treasure instance;
    public static CreativeTabs TREASURE_TAB;
    public static CreativeTabs ADORNMENTS_TAB;
    public static final Map<WorldGeneratorType, ITreasureWorldGenerator> WORLD_GENERATORS;
    public static SimpleNetworkWrapper simpleNetworkWrapper;

    @Override
    @Mod.EventHandler
    public void preInt(FMLPreInitializationEvent event) {
        super.preInt(event);
        TreasureConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)new LogoutEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new WorldEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new MimicEventHandler(this.getInstance()));
        MinecraftForge.EVENT_BUS.register((Object)new AnvilEventHandler(this.getInstance()));
        Appender appender = this.createRollingFileAppender(instance, "Treasure2Appender", (ILoggerConfig)((Object)this.getConfig()));
        this.addAppenderToLogger(appender, NAME, (ILoggerConfig)((Object)this.getConfig()));
        this.addAppenderToLogger(appender, GottschCore.instance.getName(), (ILoggerConfig)((Object)this.getConfig()));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        int PARTICLE_MESSAGE_ID = 14;
        simpleNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("treasure2_channel");
        simpleNetworkWrapper.registerMessage(PoisonMistMessageHandlerOnServer.class, PoisonMistMessageToServer.class, PARTICLE_MESSAGE_ID, Side.SERVER);
        simpleNetworkWrapper.registerMessage(WitherMistMessageHandlerOnServer.class, WitherMistMessageToServer.class, 15, Side.SERVER);
        simpleNetworkWrapper.registerMessage(CharmMessageHandlerOnClient.class, CharmMessageToClient.class, 25, Side.CLIENT);
        TreasureCapabilities.register();
        CapabilityManager.INSTANCE.register(IKeyRingCapability.class, (Capability.IStorage)new KeyRingStorage(), KeyRingCapability::new);
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomAdornment.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomCharm.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new RandomRunestone.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new CharmRandomly.Serializer());
        TreasureApi.registerLootTables(MODID);
        TreasureApi.registerMeta(MODID);
        TreasureApi.registerTemplates(MODID);
        TreasureApi.registerDecays(MODID);
        BaublesIntegration.init();
        IEquipmentCharmHandler equipmentCharmHandler = null;
        if (BaublesIntegration.isEnabled()) {
            LOGGER.debug("baubles IS loaded");
            try {
                equipmentCharmHandler = (IEquipmentCharmHandler)Class.forName("com.someguyssoftware.treasure2.eventhandler.BaublesEquipmentCharmHandler").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Unable to load Baubles compatiblity class.", (Throwable)e);
            }
        }
        if (equipmentCharmHandler == null) {
            LOGGER.debug("equipmentHandler is null");
            equipmentCharmHandler = new HotbarEquipmentCharmHandler();
        }
        MinecraftForge.EVENT_BUS.register((Object)new CharmEventHandler(equipmentCharmHandler));
        TreasureCharms.init();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        event.registerServerCommand((ICommand)new ShowVersionCommand(this));
        event.registerServerCommand((ICommand)new SpawnChestCommand());
        event.registerServerCommand((ICommand)new SpawnPitCommand());
        event.registerServerCommand((ICommand)new SpawnPitOnlyCommand());
        event.registerServerCommand((ICommand)new SpawnPitStructureOnlyCommand());
        event.registerServerCommand((ICommand)new SpawnWellStructureCommand());
        event.registerServerCommand((ICommand)new SpawnWitherTreeCommand());
        event.registerServerCommand((ICommand)new SpawnRuinsCommand());
        event.registerServerCommand((ICommand)new SpawnCharmCommand());
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        super.init(event);
        WORLD_GENERATORS.put(WorldGeneratorType.SURFACE_CHEST, new SurfaceChestWorldGenerator());
        WORLD_GENERATORS.put(WorldGeneratorType.SUBMERGED_CHEST, new SubmergedChestWorldGenerator());
        WORLD_GENERATORS.put(WorldGeneratorType.WELL, new WellWorldGenerator());
        WORLD_GENERATORS.put(WorldGeneratorType.WITHER_TREE, new WitherTreeWorldGenerator());
        WORLD_GENERATORS.put(WorldGeneratorType.GEM, new GemOreWorldGenerator());
        int genWeight = 0;
        for (Map.Entry<WorldGeneratorType, ITreasureWorldGenerator> gen : WORLD_GENERATORS.entrySet()) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)gen.getValue(), (int)genWeight++);
        }
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.getConfig().isModEnabled()) {
            return;
        }
        super.postInit(event);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_BRICKS).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_BRICKS);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_COBBLESTONE).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_COBBLESTONE);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_DIRT).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_DIRT);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_LAVA).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_LAVA);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_SAND).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_SAND);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_WATER).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_WATER);
        ((PaintingItem)TreasureItems.PAINTING_BLOCKS_WOOD).setPaintingBlock(TreasureBlocks.PAINTING_BLOCKS_WOOD);
        TreasureBlocks.PAINTING_BLOCKS_BRICKS.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_BRICKS);
        TreasureBlocks.PAINTING_BLOCKS_COBBLESTONE.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_COBBLESTONE);
        TreasureBlocks.PAINTING_BLOCKS_DIRT.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_DIRT);
        TreasureBlocks.PAINTING_BLOCKS_LAVA.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_LAVA);
        TreasureBlocks.PAINTING_BLOCKS_SAND.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_SAND);
        TreasureBlocks.PAINTING_BLOCKS_WATER.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_WATER);
        TreasureBlocks.PAINTING_BLOCKS_WOOD.setItem((PaintingItem)TreasureItems.PAINTING_BLOCKS_WOOD);
        TreasureBlocks.AMETHYST_ORE.setItem(TreasureItems.AMETHYST);
        TreasureBlocks.ONYX_ORE.setItem(TreasureItems.ONYX);
        TreasureBlocks.SAPPHIRE_ORE.setItem(TreasureItems.SAPPHIRE);
        TreasureBlocks.RUBY_ORE.setItem(TreasureItems.RUBY);
        TreasureCharmableMaterials.setup();
    }

    @Override
    public IConfig getConfig() {
        return TreasureConfig.instance;
    }

    @Override
    public BuildVersion getMinecraftVersion() {
        return MINECRAFT_VERSION;
    }

    @Override
    public String getVerisionURL() {
        return VERSION_URL;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return MODID;
    }

    @Override
    public IMod getInstance() {
        return instance;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public BuildVersion getModLatestVersion() {
        return latestVersion;
    }

    @Override
    public void setModLatestVersion(BuildVersion version) {
        latestVersion = version;
    }

    @Override
    public String getUpdateURL() {
        return UPDATE_JSON_URL;
    }

    static {
        LOGGER = LogManager.getLogger((String)NAME);
        TREASURE_TAB = new CreativeTabs(CreativeTabs.getNextID(), "treasure2:treasure_tab"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(TreasureItems.TREASURE_TAB, 1);
            }
        };
        ADORNMENTS_TAB = new CreativeTabs(CreativeTabs.getNextID(), "treasure2:adornments_tab"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(TreasureItems.ADORNMENTS_TAB, 1);
            }
        };
        WORLD_GENERATORS = new HashMap<WorldGeneratorType, ITreasureWorldGenerator>();
    }
}

