/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.IEldritchLockType;
import thecodex6824.thaumicaugmentation.api.block.property.IHorizontallyDirectionalBlock;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.TileRiftBarrier;

public class TileEldritchLock
extends TileEntity
implements ITickable,
IInteractWithCaster {
    protected int ticks;
    protected int openTicks = Integer.MIN_VALUE;

    public TileEldritchLock() {
        this.ticks = ThreadLocalRandom.current().nextInt(20);
    }

    public boolean isClosed() {
        return this.openTicks == Integer.MIN_VALUE;
    }

    public int getOpenTicks() {
        return this.openTicks;
    }

    public void open() {
        this.openTicks = 140;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    protected void checkAndPlaceBarriers(EnumFacing face) {
        boolean xAxis = face.func_176740_k() == EnumFacing.Axis.X;
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int c = -2; c < 3; ++c) {
            check.func_181079_c(this.field_174879_c.func_177958_n() + (xAxis ? 0 : c), 0, this.field_174879_c.func_177952_p() + (xAxis ? c : 0));
            for (int y = -2; y < 3; ++y) {
                check.func_185336_p(this.field_174879_c.func_177956_o() + y);
                IBlockState state = this.field_145850_b.func_180495_p((BlockPos)check);
                if (!state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, (BlockPos)check) || !this.field_145850_b.func_175667_e((BlockPos)check)) continue;
                this.field_145850_b.func_180501_a((BlockPos)check, TABlocks.RIFT_BARRIER.func_176223_P().func_177226_a((IProperty)IHorizontallyDirectionalBlock.DIRECTION, (Comparable)face), 3);
                TileEntity placed = this.field_145850_b.func_175625_s((BlockPos)check);
                if (!(placed instanceof TileRiftBarrier)) continue;
                ((TileRiftBarrier)placed).setLock(this.field_174879_c);
            }
        }
    }

    protected void destroyBarriers(EnumFacing face) {
        boolean xAxis = face.func_176740_k() == EnumFacing.Axis.X;
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        ArrayList<Vec3d> particles = new ArrayList<Vec3d>();
        for (int c = -3; c < 4; ++c) {
            check.func_181079_c(this.field_174879_c.func_177958_n() + (xAxis ? 0 : c), 0, this.field_174879_c.func_177952_p() + (xAxis ? c : 0));
            for (int y = -3; y < 4; ++y) {
                check.func_185336_p(this.field_174879_c.func_177956_o() + y);
                if (!this.field_145850_b.func_175667_e((BlockPos)check)) continue;
                IBlockState state = this.field_145850_b.func_180495_p((BlockPos)check);
                if (Math.abs(c) <= 2 && Math.abs(y) <= 2 && state.func_177230_c() == TABlocks.RIFT_BARRIER) {
                    this.field_145850_b.func_175698_g((BlockPos)check);
                    particles.add(new Vec3d((double)check.func_177958_n(), (double)check.func_177956_o(), (double)check.func_177952_p()));
                    continue;
                }
                if (state.func_177230_c() != BlocksTC.stoneAncientDoorway) continue;
                this.field_145850_b.func_180501_a((BlockPos)check, BlocksTC.stoneEldritchTile.func_176223_P(), 2);
            }
        }
        List list = particles;
        if (list.size() * 3 > PacketParticleEffect.maxPacketData) {
            list = list.subList(0, PacketParticleEffect.maxPacketData / 3);
        }
        double[] coords = new double[list.size() * 3];
        for (int i = 0; i < list.size(); ++i) {
            Vec3d vec = (Vec3d)list.get(i);
            coords[i * 3] = vec.field_72450_a;
            coords[i * 3 + 1] = vec.field_72448_b;
            coords[i * 3 + 2] = vec.field_72449_c;
        }
        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.FLUX_BATCH, coords), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
    }

    protected boolean shouldPlayRetractSound() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IEldritchLockType.LockType type = state.func_177227_a().contains(IEldritchLockType.LOCK_TYPE) ? (IEldritchLockType.LockType)((Object)state.func_177229_b(IEldritchLockType.LOCK_TYPE)) : IEldritchLockType.LockType.BOSS;
        switch (type) {
            case LABYRINTH: {
                return this.openTicks > 20 && this.openTicks % 20 == 0;
            }
            case PRISON: {
                return this.openTicks > 15 && (this.openTicks + 5) % 10 == 0;
            }
            case LIBRARY: {
                return this.openTicks > 15 && (this.openTicks + 5) % 10 == 0;
            }
            case BOSS: {
                return this.openTicks > 20 && this.openTicks % 5 == 0;
            }
        }
        return false;
    }

    public void func_73660_a() {
        EnumFacing dir;
        if (!(this.field_145850_b.field_72995_K || this.ticks++ % 20 != 0 || this.openTicks != Integer.MIN_VALUE && this.openTicks <= 20)) {
            dir = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
            this.checkAndPlaceBarriers(dir);
        }
        if (this.openTicks != Integer.MIN_VALUE) {
            --this.openTicks;
            if (!this.field_145850_b.field_72995_K) {
                if (this.openTicks < 101 && this.shouldPlayRetractSound()) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.grind, SoundCategory.BLOCKS, 1.0f, 0.9f);
                } else if (this.openTicks <= 0) {
                    dir = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
                    this.destroyBarriers(dir);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundsTC.ice, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.FLUX, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
            }
        }
    }

    public boolean onCasterRightClick(World paramWorld, ItemStack paramItemStack, EntityPlayer paramEntityPlayer, BlockPos paramBlockPos, EnumFacing paramEnumFacing, EnumHand paramEnumHand) {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public double func_145833_n() {
        int dist = TAConfig.bulkRenderDistance.getValue();
        return dist * dist;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177227_a().contains(IHorizontallyDirectionalBlock.DIRECTION)) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)IHorizontallyDirectionalBlock.DIRECTION);
            return new AxisAlignedBB(this.field_174879_c).func_72314_b((double)(Math.abs(face.func_82601_c()) * 2), 2.0, (double)(face.func_82599_e() * 2));
        }
        return super.getRenderBoundingBox();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("openTicks", this.openTicks);
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("openTicks", this.openTicks);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.openTicks = pkt.func_148857_g().func_74762_e("openTicks");
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("openTicks", this.openTicks);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.openTicks = compound.func_74762_e("openTicks");
    }
}

