/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.block.property.IUrnType;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;

public class BlockTAUrn
extends BlockTABase
implements IUrnType,
IItemBlockProvider {
    protected static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.125, 0.0625, 0.125, 0.875, 0.8125, 0.875);

    public BlockTAUrn() {
        super(Material.field_151576_e);
        this.func_149711_c(0.25f);
        this.func_149752_b(3.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(IUrnType.URN_TYPE, (Comparable)((Object)IUrnType.UrnType.URN_COMMON)));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemMultiTexture((Block)this, null, IUrnType.URN_TYPE.func_177700_c().stream().map(arg_0 -> IUrnType.URN_TYPE.func_177702_a(arg_0)).collect(Collectors.toList()).toArray(new String[IUrnType.URN_TYPE.func_177700_c().size()]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{IUrnType.URN_TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((IUrnType.UrnType)((Object)state.func_177229_b(IUrnType.URN_TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(IUrnType.URN_TYPE, (Comparable)((Object)IUrnType.UrnType.fromMeta(meta)));
    }

    public int func_180651_a(IBlockState state) {
        return ((IUrnType.UrnType)((Object)state.func_177229_b(IUrnType.URN_TYPE))).getMeta();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (world instanceof WorldServer) {
            LootTable table = null;
            switch ((IUrnType.UrnType)((Object)state.func_177229_b(IUrnType.URN_TYPE))) {
                case URN_COMMON: {
                    table = ((WorldServer)world).func_184146_ak().func_186521_a(TALootTables.LOOT_COMMON);
                    break;
                }
                case URN_UNCOMMON: {
                    table = ((WorldServer)world).func_184146_ak().func_186521_a(TALootTables.LOOT_UNCOMMON);
                    break;
                }
                case URN_RARE: {
                    table = ((WorldServer)world).func_184146_ak().func_186521_a(TALootTables.LOOT_RARE);
                    break;
                }
                default: {
                    return;
                }
            }
            LootContext context = new LootContext.Builder((WorldServer)world).func_186471_a();
            drops.addAll((Collection)table.func_186462_a(((WorldServer)world).field_73012_v, context));
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundsTC.URN;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            for (IUrnType.UrnType type : IUrnType.UrnType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IUrnType.UrnType type : IUrnType.UrnType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().func_110624_b() + ":" + type.func_176610_l(), "inventory"));
        }
    }
}

