/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.api;

import java.util.ListIterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class ClassTransformer {
    public static final String ASM_HOOKS = "vazkii/quark/api/ASMHooks";

    public static byte[] transformBlockPistonBase(@Nonnull byte[] basicClass) {
        MethodSignature sig2 = new MethodSignature("doMove", "func_176319_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Z");
        MethodSignature sig3 = new MethodSignature("checkForMove", "func_176316_e", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V");
        String targetClazz = "net/minecraft/block/state/BlockPistonStructureHelper";
        MethodSignature target3 = new MethodSignature("<init>", "", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)V");
        return ClassTransformer.transform(basicClass, ClassTransformer.forMethod(sig2, ClassTransformer.combine(node -> node.getOpcode() == 183 && ((MethodInsnNode)node).owner.equals(targetClazz) && target3.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "transformStructureHelper", "(Lnet/minecraft/block/state/BlockPistonStructureHelper;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Lnet/minecraft/block/state/BlockPistonStructureHelper;", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })), ClassTransformer.forMethod(sig3, ClassTransformer.combine(node -> node.getOpcode() == 183 && ((MethodInsnNode)node).owner.equals(targetClazz) && target3.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new InsnNode(4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "transformStructureHelper", "(Lnet/minecraft/block/state/BlockPistonStructureHelper;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Z)Lnet/minecraft/block/state/BlockPistonStructureHelper;", false));
            method.instructions.insert(node, newInstructions);
            return true;
        })));
    }

    private static TransformerAction forMethod(MethodSignature sig, MethodAction ... actions) {
        return new MethodTransformerAction(sig, actions);
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction predicate) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            return predicate.test(method);
        }
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return node -> ClassTransformer.applyOnNode(node, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static byte[] transform(byte[] basicClass, TransformerAction ... methods) {
        ClassReader reader;
        try {
            reader = new ClassReader(basicClass);
        }
        catch (NullPointerException ex) {
            return basicClass;
        }
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (TransformerAction pair : methods) {
            didAnything |= pair.test(node);
        }
        if (didAnything) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }
    }

    private static interface TransformerAction
    extends Predicate<ClassNode> {
    }

    private static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    private static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    private static interface MethodAction
    extends Predicate<MethodNode> {
    }

    private static final class MethodTransformerAction
    implements TransformerAction {
        private final MethodSignature sig;
        private final MethodAction[] actions;

        private MethodTransformerAction(MethodSignature sig, MethodAction[] actions) {
            this.sig = sig;
            this.actions = actions;
        }

        @Override
        public boolean test(ClassNode classNode) {
            boolean didAnything = false;
            for (MethodAction action : this.actions) {
                didAnything |= ClassTransformer.findMethodAndTransform(classNode, this.sig, action);
            }
            return didAnything;
        }
    }
}

