/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.Reflection;
import thedarkcolour.core.tile.InteractionTile;
import thedarkcolour.futuremc.block.buzzybees.BeeHiveBlock;
import thedarkcolour.futuremc.block.villagepillage.CampfireBlock;
import thedarkcolour.futuremc.config.FConfig;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.registry.FItems;
import thedarkcolour.futuremc.registry.FSounds;
import thedarkcolour.futuremc.tile.ExtensionsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u00012\u00020\u0002:\u0002HIB\u0005\u00a2\u0006\u0002\u0010\u0003J@\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tJ \u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0006\u0010&\u001a\u00020\u000bJ\b\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0010H\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0010H\u0002J\b\u0010/\u001a\u00020\u0010H\u0002J\u0018\u00100\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tH\u0002J\u0006\u00101\u001a\u00020\u0010J\b\u00102\u001a\u00020\u0010H\u0002J\b\u00103\u001a\u00020\u0010H\u0002J\u0006\u00104\u001a\u00020\u0010J\u0010\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020-H\u0016J(\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020-2\u000e\u00109\u001a\n\u0012\u0004\u0012\u00020;\u0018\u00010:2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u0016\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u0010J\b\u0010@\u001a\u00020\u001eH\u0002J \u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020\u00102\b\b\u0002\u0010D\u001a\u00020\u000bJ \u0010E\u001a\u0012\u0012\u0004\u0012\u00020;0\u0005j\b\u0012\u0004\u0012\u00020;`\u00072\u0006\u0010\u0011\u001a\u00020\u001fH\u0002J\b\u0010F\u001a\u00020\u001eH\u0016J\u0010\u0010G\u001a\u00020-2\u0006\u00106\u001a\u00020-H\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006J"}, d2={"Lthedarkcolour/futuremc/tile/BeeHiveTile;", "Lthedarkcolour/core/tile/InteractionTile;", "Lnet/minecraft/util/ITickable;", "()V", "bees", "Ljava/util/ArrayList;", "Lthedarkcolour/futuremc/tile/BeeHiveTile$Bee;", "Lkotlin/collections/ArrayList;", "flowerPos", "Lnet/minecraft/util/math/BlockPos;", "<set-?>", "", "honeyLevel", "getHoneyLevel", "()I", "activated", "", "state", "Lnet/minecraft/block/state/IBlockState;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "angerBees", "", "Lthedarkcolour/futuremc/tile/BeeHiveTile$BeeState;", "broken", "dropHoneyCombs", "worldIn", "Lnet/minecraft/world/World;", "pos", "emptyHoney", "getBeeCount", "getBees", "Lnet/minecraft/nbt/NBTTagList;", "getItemWithBees", "Lnet/minecraft/item/ItemStack;", "isCreative", "getUpdateTag", "Lnet/minecraft/nbt/NBTTagCompound;", "hasFlowerPos", "hasNoBees", "isExitBlocked", "isFullOfBees", "isFullOfHoney", "isHiveSmoked", "isNearFire", "readFromNBT", "compound", "releaseBee", "tag", "list", "", "Lthedarkcolour/futuremc/entity/bee/EntityBee;", "beeState", "setHoneyLevel", "level", "updateState", "tickBees", "tryEnterHive", "entityIn", "isDelivering", "i", "tryReleaseBee", "update", "writeToNBT", "Bee", "BeeState", "future-mc"})
public final class BeeHiveTile
extends InteractionTile
implements ITickable {
    private final ArrayList<Bee> bees = new ArrayList();
    private BlockPos flowerPos;
    private int honeyLevel;

    public final int getHoneyLevel() {
        return this.honeyLevel;
    }

    public final boolean isNearFire() {
        for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            IBlockState iBlockState = this.field_145850_b.func_180495_p((BlockPos)pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
            if (!(iBlockState.func_177230_c() instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasNoBees() {
        return this.bees.isEmpty();
    }

    public final boolean isFullOfBees() {
        return this.bees.size() == 3;
    }

    public final void angerBees(@Nullable EntityPlayer playerIn, @NotNull BeeState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        ArrayList<EntityBee> bees = this.tryReleaseBee(state);
        if (playerIn != null) {
            for (EntityBee bee : bees) {
                Entity entity = (Entity)playerIn;
                EntityBee entityBee = bee;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)entityBee), (String)"bee");
                if (!(ExtensionsKt.squaredDistanceTo(entity, (Entity)entityBee) <= 16.0)) continue;
                if (!this.isHiveSmoked()) {
                    bee.setBeeAttacker((Entity)playerIn);
                    continue;
                }
                bee.setCannotEnterHiveTicks(400);
            }
        }
    }

    private final ArrayList<EntityBee> tryReleaseBee(BeeState state) {
        ArrayList<EntityBee> arrayList = new ArrayList<EntityBee>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<EntityBee> list2 = arrayList;
        boolean bl3 = false;
        this.bees.removeIf(new Predicate(list2, this, state){
            final /* synthetic */ ArrayList $list;
            final /* synthetic */ BeeHiveTile this$0;
            final /* synthetic */ BeeState $state$inlined;
            {
                this.$list = arrayList;
                this.this$0 = beeHiveTile;
                this.$state$inlined = beeState;
            }

            public final boolean test(@NotNull Bee it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BeeHiveTile.access$releaseBee(this.this$0, it.getData(), this.$list, this.$state$inlined);
            }
        });
        return arrayList;
    }

    public final int getBeeCount() {
        return this.bees.size();
    }

    private final boolean isHiveSmoked() {
        World world = this.field_145850_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        BlockPos blockPos = this.field_174879_c;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        return CampfireBlock.Companion.isLitInRange(world, blockPos, 5);
    }

    public final void tryEnterHive(@NotNull EntityBee entityIn, boolean isDelivering, int i2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entityIn), (String)"entityIn");
        if (this.bees.size() < 3) {
            entityIn.func_184210_p();
            entityIn.func_184226_ay();
            NBTTagCompound tag = new NBTTagCompound();
            entityIn.func_70039_c(tag);
            this.bees.add(new Bee(tag, i2, isDelivering ? 2400 : 600));
            if (this.field_145850_b != null) {
                if (entityIn.hasFlower() && (!this.hasFlowerPos() || this.field_145850_b.field_73012_v.nextBoolean())) {
                    BlockPos blockPos = entityIn.getFlowerPos();
                    if (blockPos == null) {
                        Intrinsics.throwNpe();
                    }
                    this.flowerPos = blockPos;
                }
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                ExtensionsKt.playSound(world, blockPos, FSounds.INSTANCE.getBEE_ENTER_HIVE(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            entityIn.func_70106_y();
        }
    }

    public static /* synthetic */ void tryEnterHive$default(BeeHiveTile beeHiveTile, EntityBee entityBee, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        beeHiveTile.tryEnterHive(entityBee, bl, n);
    }

    private final boolean releaseBee(NBTTagCompound tag, List<EntityBee> list2, BeeState beeState) {
        World world = this.field_145850_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
        if (!world.func_72935_r() && this.field_145850_b.func_175727_C(this.field_174879_c) && beeState != BeeState.EMERGENCY) {
            return false;
        }
        tag.func_82580_o("Passengers");
        tag.func_82580_o("Leash");
        tag.func_82580_o("UUIDLeast");
        tag.func_82580_o("UUIDMost");
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BeeHiveBlock.FACING);
        BlockPos pos1 = this.field_174879_c.func_177972_a(direction);
        World world2 = this.field_145850_b;
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
        BlockPos blockPos = pos1;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos1");
        boolean flag = this.isExitBlocked(world2, blockPos);
        if (flag && beeState != BeeState.EMERGENCY) {
            return false;
        }
        Entity entity = AnvilChunkLoader.func_186051_a((NBTTagCompound)tag, (World)this.field_145850_b, (boolean)false);
        if (entity != null) {
            BlockPos pos;
            float width = entity.field_70130_N;
            double d0 = flag ? 0.0 : 0.55 + (double)(width / 2.0f);
            BlockPos blockPos2 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
            double d = (double)blockPos2.func_177958_n() + 0.5;
            EnumFacing enumFacing = direction;
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"direction");
            double d1 = d + d0 * (double)enumFacing.func_82601_c();
            BlockPos blockPos3 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos");
            double d2 = (double)blockPos3.func_177956_o() + 0.5 - (double)(entity.field_70131_O / 2.0f);
            BlockPos blockPos4 = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"pos");
            double d3 = (double)blockPos4.func_177952_p() + 0.5 + d0 * (double)direction.func_82599_e();
            entity.func_70012_b(d1, d2, d3, entity.field_70177_z, entity.field_70125_A);
            if (!(entity instanceof EntityBee)) {
                return false;
            }
            if (this.hasFlowerPos() && !((EntityBee)entity).hasFlower() && this.field_145850_b.field_73012_v.nextFloat() < 0.9f) {
                ((EntityBee)entity).setFlowerPos(this.flowerPos);
            }
            if (beeState == BeeState.HONEY_DELIVERED) {
                ((EntityBee)entity).onHoneyDelivered();
                this.setHoneyLevel(this.honeyLevel + (this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1), true);
            }
            ((EntityBee)entity).resetPollinationTicks();
            List<EntityBee> list3 = list2;
            if (list3 != null) {
                list3.add((EntityBee)entity);
            }
            BlockPos blockPos5 = pos = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"pos");
            this.field_145850_b.func_184148_a(null, (double)blockPos5.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), FSounds.INSTANCE.getENTITY_BEE_EXIT_HIVE(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return this.field_145850_b.func_72838_d(entity);
        }
        return false;
    }

    private final boolean isExitBlocked(World worldIn, BlockPos pos) {
        IBlockState iBlockState = worldIn.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
        return thedarkcolour.core.util.ExtensionsKt.isAir(iBlockState, (IBlockAccess)worldIn, pos);
    }

    private final boolean hasFlowerPos() {
        return this.flowerPos != null;
    }

    private final void tickBees() {
        Iterator<Bee> iterator = this.bees.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"bees.iterator()");
        Iterator<Bee> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Bee bee;
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator2.next(), (String)"iterator.next()");
            if (bee.getTicksInHive() > bee.getMinOccupationTicks()) {
                NBTTagCompound tag;
                BeeState state = (tag = bee.getData()).func_74767_n("HasNectar") ? BeeState.HONEY_DELIVERED : BeeState.BEE_RELEASED;
                if (!this.releaseBee(tag, null, state)) continue;
                iterator2.remove();
                continue;
            }
            Bee bee2 = bee;
            bee2.setTicksInHive(bee2.getTicksInHive() + 1);
            bee2.getTicksInHive();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickBees();
            if (!this.hasNoBees() && this.field_145850_b.field_73012_v.nextDouble() < 0.005) {
                BlockPos pos;
                BlockPos blockPos = pos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                double x = (double)blockPos.func_177958_n() + 0.5;
                double y = pos.func_177956_o();
                double z = (double)pos.func_177952_p() + 0.5;
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                ExtensionsKt.playSound(world, x, y, z, FSounds.BEE_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.bees.clear();
        NBTTagList list2 = compound.func_150295_c("Bees", 10);
        this.setHoneyLevel(compound.func_74762_e("HoneyLevel"), Intrinsics.areEqual((Object)Reflection.getCallerClass((int)2), TileEntity.class) ^ true);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            NBTBase base;
            NBTBase nBTBase = base = (NBTBase)iterator.next();
            if (nBTBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            NBTTagCompound tag = (NBTTagCompound)nBTBase;
            NBTBase nBTBase2 = tag.func_74781_a("EntityData");
            if (nBTBase2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.minecraft.nbt.NBTTagCompound");
            }
            Bee bee = new Bee((NBTTagCompound)nBTBase2, tag.func_74762_e("TicksInHive"), tag.func_74762_e("MinOccupationTicks"));
            this.bees.add(bee);
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        compound.func_74782_a("Bees", (NBTBase)this.getBees());
        compound.func_74768_a("HoneyLevel", this.honeyLevel);
        if (this.hasFlowerPos()) {
            BlockPos blockPos = this.flowerPos;
            if (blockPos == null) {
                Intrinsics.throwNpe();
            }
            compound.func_74782_a("FlowerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)blockPos));
        }
        return compound;
    }

    public final void setHoneyLevel(int level, boolean updateState) {
        int n = this.honeyLevel = level >= 5 ? 5 : level;
        if (updateState) {
            Block block = this.func_145838_q();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"getBlockType()");
            this.field_145850_b.func_175656_a(this.field_174879_c, block.func_176223_P().func_177226_a((IProperty)BeeHiveBlock.Companion.getIS_FULL(), (Comparable)Boolean.valueOf(this.honeyLevel == 5)).func_177226_a((IProperty)BeeHiveBlock.FACING, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BeeHiveBlock.FACING)));
        }
    }

    private final boolean isFullOfHoney() {
        return this.honeyLevel >= 5;
    }

    @Override
    public boolean activated(@NotNull IBlockState state, @NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)((Object)playerIn), (String)"playerIn");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        ItemStack stack = playerIn.func_184586_b(hand);
        boolean action = false;
        if (this.isFullOfHoney()) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (itemStack.func_77973_b() instanceof ItemShears) {
                this.field_145850_b.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, FSounds.INSTANCE.getBEEHIVE_SHEAR(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                World world = this.field_145850_b;
                Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                this.dropHoneyCombs(world, blockPos);
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                action = true;
            } else if (Intrinsics.areEqual((Object)stack.func_77973_b(), (Object)Items.field_151069_bo)) {
                stack.func_190918_g(1);
                this.field_145850_b.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack((Item)FItems.INSTANCE.getHONEY_BOTTLE()));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack((Item)FItems.INSTANCE.getHONEY_BOTTLE()))) {
                    playerIn.func_71019_a(new ItemStack((Item)FItems.INSTANCE.getHONEY_BOTTLE()), false);
                }
                action = true;
            }
        }
        if (action) {
            World world = this.field_145850_b;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            BlockPos blockPos = this.field_174879_c;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
            this.emptyHoney(world, blockPos, playerIn);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void dropHoneyCombs(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i2;
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)FItems.INSTANCE.getHONEYCOMB()));
            ++i2;
        }
    }

    public final void emptyHoney(@NotNull World worldIn, @NotNull BlockPos pos, @Nullable EntityPlayer playerIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)BeeHiveBlock.Companion.getIS_FULL(), (Comparable)Boolean.valueOf(false)), 3);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof BeeHiveTile) {
            ((BeeHiveTile)tile).setHoneyLevel(0, true);
            ((BeeHiveTile)tile).angerBees(playerIn, BeeState.HONEY_DELIVERED);
        }
    }

    @Override
    public void broken(@NotNull IBlockState state, @NotNull EntityPlayer playerIn) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)((Object)playerIn), (String)"playerIn");
        if (!this.field_145850_b.field_72995_K) {
            boolean isCreative = playerIn.func_184812_l_();
            if (isCreative || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)playerIn.func_184614_ca()) == 1) {
                BlockPos blockPos = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
                double d = blockPos.func_177958_n();
                BlockPos blockPos2 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos");
                double d2 = blockPos2.func_177956_o();
                BlockPos blockPos3 = this.field_174879_c;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos");
                ItemStack itemStack = this.getItemWithBees(isCreative);
                if (itemStack == null) {
                    return;
                }
                EntityItem item = new EntityItem(this.field_145850_b, d, d2, (double)blockPos3.func_177952_p(), itemStack);
                item.func_174869_p();
                this.field_145850_b.func_72838_d((Entity)item);
            } else {
                List nearbyPlayers;
                int players;
                List nearbyBees;
                if (!this.field_145850_b.field_72995_K && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)playerIn.func_184614_ca()) == 0) {
                    this.angerBees(playerIn, BeeState.HONEY_DELIVERED);
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
                List list2 = nearbyBees = this.field_145850_b.func_72872_a(EntityBee.class, new AxisAlignedBB(this.field_174879_c).func_72321_a(8.0, 6.0, 8.0));
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"nearbyBees");
                Collection collection = list2;
                boolean bl = false;
                if (!collection.isEmpty() && (players = (nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_72321_a(8.0, 6.0, 8.0))).size()) != 0) {
                    Iterator iterator = nearbyBees.iterator();
                    while (iterator.hasNext()) {
                        EntityBee bee;
                        EntityBee entityBee = bee = (EntityBee)((Object)iterator.next());
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)entityBee), (String)"bee");
                        if (entityBee.func_70638_az() != null) continue;
                        bee.setBeeAttacker((Entity)nearbyPlayers.get(this.field_145850_b.field_73012_v.nextInt(players)));
                    }
                }
            }
        }
    }

    private final ItemStack getItemWithBees(boolean isCreative) {
        IBlockState iBlockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
        ItemStack stack = new ItemStack(iBlockState.func_177230_c());
        NBTTagCompound tag = new NBTTagCompound();
        if (this.hasNoBees() && this.honeyLevel == 0) {
            return isCreative ? null : stack;
        }
        tag.func_74782_a("Bees", (NBTBase)this.getBees());
        tag.func_74768_a("HoneyLevel", this.honeyLevel);
        stack.func_77983_a("BlockEntityTag", (NBTBase)tag);
        return stack;
    }

    /*
     * WARNING - void declaration
     */
    private final NBTTagList getBees() {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        NBTTagList nBTTagList = new NBTTagList();
        boolean bl = false;
        boolean bl2 = false;
        NBTTagList it = nBTTagList;
        boolean bl3 = false;
        Iterable $this$map$iv = this.bees;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Bee bee = (Bee)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            NBTTagCompound nBTTagCompound = p1.deserialize();
            collection.add(nBTTagCompound);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NBTBase p1 = (NBTBase)element$iv;
            boolean bl5 = false;
            it.func_74742_a(p1);
        }
        return nBTTagList;
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nBTTagCompound;
        if (FConfig.INSTANCE.getBuzzyBees().bee.enabled) {
            NBTTagCompound nBTTagCompound2 = super.func_189517_E_();
            nBTTagCompound = nBTTagCompound2;
            Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound2, (String)"super.getUpdateTag()");
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public static final /* synthetic */ boolean access$releaseBee(BeeHiveTile $this, NBTTagCompound tag, List list2, BeeState beeState) {
        return $this.releaseBee(tag, list2, beeState);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000b\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lthedarkcolour/futuremc/tile/BeeHiveTile$Bee;", "", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "ticksInHive", "", "minOccupationTicks", "(Lnet/minecraft/nbt/NBTTagCompound;II)V", "getData", "()Lnet/minecraft/nbt/NBTTagCompound;", "getMinOccupationTicks", "()I", "getTicksInHive", "setTicksInHive", "(I)V", "deserialize", "future-mc"})
    private static final class Bee {
        @NotNull
        private final NBTTagCompound data;
        private int ticksInHive;
        private final int minOccupationTicks;

        @NotNull
        public final NBTTagCompound deserialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("EntityData", (NBTBase)this.data);
            tag.func_74768_a("TicksInHive", this.ticksInHive);
            tag.func_74768_a("MinOccupationTicks", this.minOccupationTicks);
            return tag;
        }

        @NotNull
        public final NBTTagCompound getData() {
            return this.data;
        }

        public final int getTicksInHive() {
            return this.ticksInHive;
        }

        public final void setTicksInHive(int n) {
            this.ticksInHive = n;
        }

        public final int getMinOccupationTicks() {
            return this.minOccupationTicks;
        }

        public Bee(@NotNull NBTTagCompound data, int ticksInHive, int minOccupationTicks) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            this.data = data;
            this.ticksInHive = ticksInHive;
            this.minOccupationTicks = minOccupationTicks;
            this.data.func_74757_a("Leashed", false);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lthedarkcolour/futuremc/tile/BeeHiveTile$BeeState;", "", "(Ljava/lang/String;I)V", "HONEY_DELIVERED", "BEE_RELEASED", "EMERGENCY", "future-mc"})
    public static final class BeeState
    extends Enum<BeeState> {
        public static final /* enum */ BeeState HONEY_DELIVERED;
        public static final /* enum */ BeeState BEE_RELEASED;
        public static final /* enum */ BeeState EMERGENCY;
        private static final /* synthetic */ BeeState[] $VALUES;

        static {
            BeeState[] beeStateArray = new BeeState[3];
            BeeState[] beeStateArray2 = beeStateArray;
            beeStateArray[0] = HONEY_DELIVERED = new BeeState();
            beeStateArray[1] = BEE_RELEASED = new BeeState();
            beeStateArray[2] = EMERGENCY = new BeeState();
            $VALUES = beeStateArray;
        }

        public static BeeState[] values() {
            return (BeeState[])$VALUES.clone();
        }

        public static BeeState valueOf(String string) {
            return Enum.valueOf(BeeState.class, string);
        }
    }
}

