/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import thedarkcolour.core.gui.FContainer;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.container.ContainerBarrel;
import thedarkcolour.futuremc.container.ContainerCartographyTable;
import thedarkcolour.futuremc.container.ContainerFurnaceAdvanced;
import thedarkcolour.futuremc.container.ContainerGrindstone;
import thedarkcolour.futuremc.container.ContainerLoom;
import thedarkcolour.futuremc.container.SmithingContainer;
import thedarkcolour.futuremc.container.StonecutterContainer;

public enum GuiType {
    BARREL(ContainerBarrel::new),
    FURNACE(ContainerFurnaceAdvanced::new),
    GRINDSTONE(ContainerGrindstone::new),
    STONECUTTER(StonecutterContainer::new),
    LOOM(ContainerLoom::new),
    SMITHING_TABLE(SmithingContainer::new),
    CARTOGRAPHY_TABLE(ContainerCartographyTable::new);

    private final ContainerFactory container;

    private GuiType(ContainerFactory container) {
        this.container = container;
    }

    private GuiType(TEContainerFactory container) {
        this.container = container;
    }

    private Object createGui(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        return this.createContainer(playerInv, worldIn, pos).createGui();
    }

    private Object createGui(InventoryPlayer playerInv, TileEntity te) {
        return this.createContainer(playerInv, te).createGui();
    }

    private FContainer createContainer(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        if (this.isTile()) {
            return this.container.get(playerInv, worldIn.func_175625_s(pos));
        }
        return this.container.get(playerInv, worldIn, pos);
    }

    private FContainer createContainer(InventoryPlayer playerInv, TileEntity te) {
        return this.container.get(playerInv, te);
    }

    public boolean isTile() {
        return this.container instanceof TEContainerFactory;
    }

    public boolean open(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui(FutureMC.INSTANCE, this.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static void registerGuiHandler() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)FutureMC.INSTANCE, (IGuiHandler)Handler.INSTANCE);
    }

    @FunctionalInterface
    private static interface TEContainerFactory
    extends ContainerFactory {
        @Override
        default public FContainer get(InventoryPlayer player, World worldIn, BlockPos pos) {
            return null;
        }

        @Override
        public FContainer get(InventoryPlayer var1, TileEntity var2);
    }

    @FunctionalInterface
    private static interface ContainerFactory {
        default public FContainer get(InventoryPlayer player, TileEntity te) {
            return null;
        }

        public FContainer get(InventoryPlayer var1, World var2, BlockPos var3);
    }

    private static final class Handler
    implements IGuiHandler {
        private static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public FContainer getServerGuiElement(int ID, EntityPlayer playerIn, World worldIn, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            GuiType guiType = GuiType.values()[ID];
            if (guiType.isTile()) {
                return guiType.createContainer(playerIn.field_71071_by, worldIn.func_175625_s(pos));
            }
            return guiType.createContainer(playerIn.field_71071_by, worldIn, pos);
        }

        public Object getClientGuiElement(int ID, EntityPlayer playerIn, World worldIn, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            GuiType guiType = GuiType.values()[ID];
            if (guiType.isTile()) {
                return guiType.createGui(playerIn.field_71071_by, worldIn.func_175625_s(pos));
            }
            return guiType.createGui(playerIn.field_71071_by, worldIn, pos);
        }
    }
}

