/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.speaker;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.common.NamedThreadPoolFactory;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

@Deprecated
public abstract class ALSpeakerBase
implements Speaker {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final SoundManager soundManager;
    protected final int sampleRate;
    protected int bufferSize;
    protected int bufferSampleSize;
    protected int source;
    protected volatile int bufferIndex;
    protected final IntBuffer buffers;
    protected final ExecutorService executor;
    @Nullable
    protected UUID audioChannelId;

    public ALSpeakerBase(SoundManager soundManager, int sampleRate, int bufferSize, @Nullable UUID audioChannelId) {
        this.soundManager = soundManager;
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.bufferSampleSize = bufferSize;
        this.audioChannelId = audioChannelId;
        this.buffers = BufferUtils.createIntBuffer((int)32);
        String threadName = audioChannelId == null ? "SoundSourceThread" : "SoundSourceThread-" + audioChannelId;
        this.executor = Executors.newSingleThreadExecutor(NamedThreadPoolFactory.create(threadName));
    }

    @Override
    public void open() throws SpeakerException {
        this.runInContext(this::openSync);
    }

    protected void openSync() {
        if (this.hasValidSourceSync()) {
            return;
        }
        this.source = AL10.alGenSources();
        SoundManager.checkAlError();
        AL10.alSourcei((int)this.source, (int)4103, (int)0);
        SoundManager.checkAlError();
        AL10.alDistanceModel((int)53251);
        SoundManager.checkAlError();
        AL10.alSourcef((int)this.source, (int)4131, (float)Utils.getDefaultDistance());
        SoundManager.checkAlError();
        AL10.alSourcef((int)this.source, (int)4128, (float)0.0f);
        SoundManager.checkAlError();
        AL10.alGenBuffers((IntBuffer)this.buffers);
        SoundManager.checkAlError();
    }

    @Override
    public void play(short[] data, float volume, @Nullable Vec3d position, @Nullable String category, float maxDistance) {
        this.runInContext(() -> {
            boolean stopped;
            this.removeProcessedBuffersSync();
            int buffers = this.getQueuedBuffersSync();
            boolean bl = stopped = this.getStateSync() == 4113 || this.getStateSync() == 4116 || buffers <= 1;
            if (stopped) {
                for (int i = 0; i < this.getBufferSize(); ++i) {
                    this.writeSync(new short[this.bufferSize], 1.0f, position, category, maxDistance);
                }
            }
            this.writeSync(data, volume, position, category, maxDistance);
            if (stopped) {
                AL10.alSourcePlay((int)this.source);
                SoundManager.checkAlError();
            }
        });
    }

    protected int getBufferSize() {
        return VoicechatClient.CLIENT_CONFIG.outputBufferSize.get();
    }

    protected void writeSync(short[] data, float volume, @Nullable Vec3d position, @Nullable String category, float maxDistance) {
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, category, OpenALSoundEvent.Pre.class);
        this.setPositionSync(position, maxDistance);
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, category, OpenALSoundEvent.class);
        AL10.alSourcef((int)this.source, (int)4110, (float)6.0f);
        SoundManager.checkAlError();
        AL10.alSourcef((int)this.source, (int)4106, (float)this.getVolume(volume, position, maxDistance));
        SoundManager.checkAlError();
        AL10.alListenerf((int)4106, (float)1.0f);
        SoundManager.checkAlError();
        int queuedBuffers = this.getQueuedBuffersSync();
        if (queuedBuffers >= this.buffers.capacity()) {
            Voicechat.LOGGER.warn("Full playback buffer: {}/{}", (Object)queuedBuffers, (Object)this.buffers.capacity());
            int sampleOffset = AL10.alGetSourcei((int)this.source, (int)4133);
            SoundManager.checkAlError();
            int buffersToSkip = queuedBuffers - this.getBufferSize();
            AL10.alSourcei((int)this.source, (int)4133, (int)(sampleOffset + buffersToSkip * this.bufferSampleSize));
            SoundManager.checkAlError();
            this.removeProcessedBuffersSync();
        }
        AL10.alBufferData((int)this.buffers.get(this.bufferIndex), (int)this.getFormat(), (ShortBuffer)this.convert(data, position), (int)this.sampleRate);
        SoundManager.checkAlError();
        AL10.alSourceQueueBuffers((int)this.source, (int)this.buffers.get(this.bufferIndex));
        SoundManager.checkAlError();
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.capacity();
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, category, OpenALSoundEvent.Post.class);
    }

    protected float getVolume(float volume, @Nullable Vec3d position, float maxDistance) {
        return volume;
    }

    protected void linearAttenuation(float maxDistance) {
        AL10.alDistanceModel((int)53251);
        SoundManager.checkAlError();
        AL10.alSourcef((int)this.source, (int)4131, (float)maxDistance);
        SoundManager.checkAlError();
    }

    protected abstract int getFormat();

    protected ShortBuffer convert(short[] data, @Nullable Vec3d position) {
        return ALSpeakerBase.toShortBuffer(data);
    }

    protected static ShortBuffer toShortBuffer(short[] data) {
        return BufferUtils.createShortBuffer((int)data.length).put(data);
    }

    protected void setPositionSync(@Nullable Vec3d soundPos, float maxDistance) {
        RenderManager renderManager = this.mc.func_175598_ae();
        Vec3d position = new Vec3d(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n);
        Vec3d look = this.getVectorForRotation(renderManager.field_78732_j, renderManager.field_78735_i);
        AL10.alListener3f((int)4100, (float)((float)position.field_72450_a), (float)((float)position.field_72448_b), (float)((float)position.field_72449_c));
        SoundManager.checkAlError();
        Vec3d up = look.func_178789_a(-90.0f);
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)7);
        floatBuffer.put(new float[]{(float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c, (float)up.field_72450_a, (float)up.field_72448_b, (float)up.field_72449_c});
        floatBuffer.flip();
        AL10.alListener((int)4111, (FloatBuffer)floatBuffer);
        SoundManager.checkAlError();
        if (soundPos != null) {
            this.linearAttenuation(maxDistance);
            AL10.alSourcei((int)this.source, (int)514, (int)0);
            SoundManager.checkAlError();
            AL10.alSource3f((int)this.source, (int)4100, (float)((float)soundPos.field_72450_a), (float)((float)soundPos.field_72448_b), (float)((float)soundPos.field_72449_c));
            SoundManager.checkAlError();
        } else {
            this.linearAttenuation(48.0f);
            AL10.alSourcei((int)this.source, (int)514, (int)1);
            SoundManager.checkAlError();
            AL10.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            SoundManager.checkAlError();
        }
    }

    protected final Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    @Override
    public void close() {
        this.runInContext(this::closeSync);
    }

    protected void closeSync() {
        if (this.hasValidSourceSync()) {
            if (this.getStateSync() == 4114) {
                AL10.alSourceStop((int)this.source);
                SoundManager.checkAlError();
            }
            AL10.alDeleteSources((int)this.source);
            SoundManager.checkAlError();
            AL10.alDeleteBuffers((IntBuffer)this.buffers);
            SoundManager.checkAlError();
        }
        this.source = 0;
        this.executor.shutdown();
    }

    public void checkBufferEmpty(Runnable onEmpty) {
        this.runInContext(() -> {
            if (this.getStateSync() == 4116 || this.getQueuedBuffersSync() <= 0) {
                onEmpty.run();
            }
        });
    }

    protected void removeProcessedBuffersSync() {
        int processed = AL10.alGetSourcei((int)this.source, (int)4118);
        SoundManager.checkAlError();
        for (int i = 0; i < processed; ++i) {
            AL10.alSourceUnqueueBuffers((int)this.source);
            SoundManager.checkAlError();
        }
    }

    protected int getStateSync() {
        int state = AL10.alGetSourcei((int)this.source, (int)4112);
        SoundManager.checkAlError();
        return state;
    }

    protected int getQueuedBuffersSync() {
        int buffers = AL10.alGetSourcei((int)this.source, (int)4117);
        SoundManager.checkAlError();
        return buffers;
    }

    protected boolean hasValidSourceSync() {
        boolean validSource = AL10.alIsSource((int)this.source);
        SoundManager.checkAlError();
        return validSource;
    }

    public void runInContext(Runnable runnable) {
        this.soundManager.runInContext(this.executor, runnable);
    }
}

