/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class PositionalAudioUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();

    private static float[] getStereoVolume(Vec3d cameraPos, float yRot, Vec3d soundPos) {
        float rot;
        Vec3d d = soundPos.func_178788_d(cameraPos).func_72432_b();
        Vec2f diff = new Vec2f((float)d.field_72450_a, (float)d.field_72449_c);
        float diffAngle = Utils.angle(diff, new Vec2f(-1.0f, 0.0f));
        float angle = Utils.normalizeAngle(diffAngle - yRot % 360.0f);
        float dif = (float)(Math.abs(cameraPos.field_72448_b - soundPos.field_72448_b) / 32.0);
        float perc = rot = angle / 180.0f;
        if (rot < -0.5f) {
            perc = -(0.5f + (rot + 0.5f));
        } else if (rot > 0.5f) {
            perc = 0.5f - (rot - 0.5f);
        }
        float minVolume = 0.3f;
        float left = perc < 0.0f ? Math.abs((perc *= 1.0f - dif) * 1.4f) + minVolume : minVolume;
        float right = perc >= 0.0f ? perc * 1.4f + minVolume : minVolume;
        float fill = 1.0f - Math.max(left, right);
        return new float[]{left += fill, right += fill};
    }

    private static float[] getStereoVolume(Vec3d soundPos) {
        return PositionalAudioUtils.getStereoVolume(PositionalAudioUtils.getCameraPosition(), ActiveRenderInfo.func_178809_c(), soundPos);
    }

    public static float getDistanceVolume(float maxDistance, Vec3d pos) {
        return PositionalAudioUtils.getDistanceVolume(maxDistance, PositionalAudioUtils.getCameraPosition(), pos);
    }

    public static float getDistanceVolume(float maxDistance, Vec3d listenerPos, Vec3d pos) {
        float distance = (float)pos.func_72438_d(listenerPos);
        distance = Math.min(distance, maxDistance);
        return 1.0f - distance / maxDistance;
    }

    public static short[] convertToStereo(short[] audio, @Nullable Vec3d soundPos) {
        if (soundPos == null) {
            return PositionalAudioUtils.convertToStereo(audio);
        }
        return PositionalAudioUtils.convertToStereo(audio, PositionalAudioUtils.getStereoVolume(soundPos));
    }

    public static short[] convertToStereo(short[] audio, Vec3d cameraPos, float yRot, @Nullable Vec3d soundPos) {
        if (soundPos == null) {
            return PositionalAudioUtils.convertToStereo(audio);
        }
        return PositionalAudioUtils.convertToStereo(audio, PositionalAudioUtils.getStereoVolume(cameraPos, yRot, soundPos));
    }

    public static short[] convertToStereo(short[] audio) {
        short[] stereo = new short[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            stereo[i * 2] = audio[i];
            stereo[i * 2 + 1] = audio[i];
        }
        return stereo;
    }

    private static short[] convertToStereo(short[] audio, float volumeLeft, float volumeRight) {
        short[] stereo = new short[audio.length * 2];
        for (int i = 0; i < audio.length; ++i) {
            short left = (short)((float)audio[i] * volumeLeft);
            short right = (short)((float)audio[i] * volumeRight);
            stereo[i * 2] = left;
            stereo[i * 2 + 1] = right;
        }
        return stereo;
    }

    private static short[] convertToStereo(short[] audio, float[] volumes) {
        return PositionalAudioUtils.convertToStereo(audio, volumes[0], volumes[1]);
    }

    public static short[] convertToStereoForRecording(float maxDistance, Vec3d pos, short[] monoData) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, PositionalAudioUtils.getCameraPosition(), ActiveRenderInfo.func_178809_c(), pos, monoData);
    }

    public static short[] convertToStereoForRecording(float maxDistance, Vec3d pos, short[] monoData, float volume) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, PositionalAudioUtils.getCameraPosition(), ActiveRenderInfo.func_178809_c(), pos, monoData, volume);
    }

    public static short[] convertToStereoForRecording(float maxDistance, Vec3d cameraPos, float yRot, Vec3d pos, short[] monoData) {
        return PositionalAudioUtils.convertToStereoForRecording(maxDistance, cameraPos, yRot, pos, monoData, 1.0f);
    }

    public static short[] convertToStereoForRecording(float maxDistance, Vec3d cameraPos, float yRot, Vec3d pos, short[] monoData, float volume) {
        float distanceVolume = PositionalAudioUtils.getDistanceVolume(maxDistance, cameraPos, pos) * volume;
        if (!VoicechatClient.CLIENT_CONFIG.audioType.get().equals((Object)AudioType.OFF)) {
            float[] stereoVolume = PositionalAudioUtils.getStereoVolume(cameraPos, yRot, pos);
            return PositionalAudioUtils.convertToStereo(monoData, distanceVolume * stereoVolume[0], distanceVolume * stereoVolume[1]);
        }
        return PositionalAudioUtils.convertToStereo(monoData, distanceVolume, distanceVolume);
    }

    public static Vec3d getCameraPosition() {
        return ActiveRenderInfo.getCameraPosition().func_178787_e(PositionalAudioUtils.mc.field_71439_g == null ? Vec3d.field_186680_a : PositionalAudioUtils.mc.field_71439_g.func_174791_d());
    }
}

