/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.CategoryVolumeEntry;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;

public class AdjustVolumeList
extends ListScreenListBase<VolumeEntry> {
    protected AdjustVolumesScreen screen;
    protected final List<VolumeEntry> entries;
    protected String filter;

    public AdjustVolumeList(int width, int height, int x, int y, int size, AdjustVolumesScreen screen) {
        super(width, height, x, y, size);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.updateEntryList();
    }

    public static void update() {
        if (Minecraft.func_71410_x().field_71462_r instanceof AdjustVolumesScreen) {
            ((AdjustVolumesScreen)Minecraft.func_71410_x().field_71462_r).volumeList.updateEntryList();
        }
    }

    public void updateEntryList() {
        List<PlayerState> onlinePlayers = ClientManager.getPlayerStateManager().getPlayerStates(false);
        this.entries.clear();
        for (VolumeCategoryImpl category : ClientManager.getCategoryManager().getCategories()) {
            this.entries.add(new CategoryVolumeEntry(category, this.screen));
        }
        for (PlayerState state : onlinePlayers) {
            this.entries.add(new PlayerVolumeEntry(state, this.screen));
        }
        if (VoicechatClient.CLIENT_CONFIG.offlinePlayerVolumeAdjustment.get().booleanValue()) {
            this.addOfflinePlayers(onlinePlayers);
        }
        this.updateFilter();
    }

    private void addOfflinePlayers(Collection<PlayerState> onlinePlayers) {
        for (UUID uuid : VoicechatClient.VOLUME_CONFIG.getPlayerVolumes().keySet()) {
            String name;
            if (uuid.equals(new UUID(0L, 0L)) || onlinePlayers.stream().anyMatch(state -> uuid.equals(state.getUuid())) || (name = VoicechatClient.USERNAME_CACHE.getUsername(uuid)) == null) continue;
            this.entries.add(new PlayerVolumeEntry(new PlayerState(uuid, name, false, true), this.screen));
        }
    }

    public void updateFilter() {
        this.clearEntries();
        ArrayList<VolumeEntry> filteredEntries = new ArrayList<VolumeEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(volumeEntry -> {
                if (volumeEntry instanceof PlayerVolumeEntry) {
                    PlayerVolumeEntry playerVolumeEntry = (PlayerVolumeEntry)volumeEntry;
                    return playerVolumeEntry.getState() == null || !playerVolumeEntry.getState().getName().toLowerCase(Locale.ROOT).contains(this.filter);
                }
                if (volumeEntry instanceof CategoryVolumeEntry) {
                    CategoryVolumeEntry categoryVolumeEntry = (CategoryVolumeEntry)volumeEntry;
                    return !categoryVolumeEntry.getCategory().getName().toLowerCase(Locale.ROOT).contains(this.filter);
                }
                return true;
            });
        }
        filteredEntries.sort((e1, e2) -> {
            if (!e1.getClass().equals(e2.getClass())) {
                if (e1 instanceof PlayerVolumeEntry) {
                    return 1;
                }
                return -1;
            }
            return this.volumeEntryToString((VolumeEntry)e1).compareToIgnoreCase(this.volumeEntryToString((VolumeEntry)e2));
        });
        if (this.filter.isEmpty()) {
            filteredEntries.add(0, new PlayerVolumeEntry(null, this.screen));
        }
        this.replaceEntries(filteredEntries);
    }

    private String volumeEntryToString(VolumeEntry entry) {
        if (entry instanceof PlayerVolumeEntry) {
            PlayerVolumeEntry playerVolumeEntry = (PlayerVolumeEntry)entry;
            return playerVolumeEntry.getState() == null ? "" : playerVolumeEntry.getState().getName();
        }
        if (entry instanceof CategoryVolumeEntry) {
            CategoryVolumeEntry categoryVolumeEntry = (CategoryVolumeEntry)entry;
            return categoryVolumeEntry.getCategory().getName();
        }
        return "";
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    @Override
    public boolean isEmpty() {
        return this.children().isEmpty();
    }
}

