/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;

public abstract class VoiceChatScreenBase
extends GuiScreen {
    public static final int FONT_COLOR = 0x404040;
    protected List<HoverArea> hoverAreas;
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected ITextComponent title;

    protected VoiceChatScreenBase(ITextComponent title, int xSize, int ySize) {
        this.title = title;
        this.xSize = xSize;
        this.ySize = ySize;
        this.hoverAreas = new ArrayList<HoverArea>();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float delta) {
        this.func_146276_q_();
        this.renderBackground(mouseX, mouseY, delta);
        super.func_73863_a(mouseX, mouseY, delta);
        this.renderForeground(mouseX, mouseY, delta);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof ButtonBase)) continue;
            ((ButtonBase)button).renderTooltips(mouseX, mouseY, delta);
        }
    }

    public void renderBackground(int mouseX, int mouseY, float delta) {
    }

    public void renderForeground(int mouseX, int mouseY, float delta) {
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (!(button instanceof ButtonBase)) {
            return;
        }
        ButtonBase b = (ButtonBase)button;
        b.onPress();
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    protected boolean isIngame() {
        return this.field_146297_k.field_71441_e != null;
    }

    protected int getFontColor() {
        return this.isIngame() ? 0x404040 : 0xFFFFFF;
    }

    public void drawHoverAreas(int mouseX, int mouseY) {
        for (HoverArea hoverArea : this.hoverAreas) {
            if (hoverArea.tooltip == null || !hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            this.func_146283_a((List)hoverArea.tooltip.get(), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static class HoverArea {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        @Nullable
        private final Supplier<List<String>> tooltip;

        public HoverArea(int posX, int posY, int width, int height) {
            this(posX, posY, width, height, null);
        }

        public HoverArea(int posX, int posY, int width, int height, Supplier<List<String>> tooltip) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.tooltip = tooltip;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public Supplier<List<String>> getTooltip() {
            return this.tooltip;
        }

        public boolean isHovered(int guiLeft, int guiTop, int mouseX, int mouseY) {
            return mouseX >= guiLeft + this.posX && mouseX < guiLeft + this.posX + this.width && mouseY >= guiTop + this.posY && mouseY < guiTop + this.posY + this.height;
        }
    }
}

