/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.worldGen;

import com.google.common.collect.Lists;
import com.unoriginal.ancientbeasts.worldGen.JungleVillagePieces;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class JungleVillageWorldGen
extends WorldGenerator {
    public static List<Biome> VALID_BIOMES = Arrays.asList(Biomes.field_76782_w, Biomes.field_76792_x);
    private int separation = 15;
    private int spacing = 40;

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        this.spacing = 40;
        boolean canSpawn = this.canSpawnStructureAtCoords(world, position.func_177958_n() >> 4, position.func_177952_p() >> 4);
        if (new Random().nextInt(9) == 0) {
            int new_size = 32;
            this.getStructureStart(world, position.func_177958_n() >> 4, position.func_177952_p() >> 4, rand).func_75068_a(world, rand, new StructureBoundingBox(position.func_177958_n() - new_size, position.func_177952_p() - new_size, position.func_177958_n() + new_size, position.func_177952_p() + new_size));
        }
        return canSpawn;
    }

    public String getStructureName() {
        return "Jungle Tribal Village";
    }

    protected boolean canSpawnStructureAtCoords(World world, int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int k = chunkX / this.spacing;
        int l = chunkZ / this.spacing;
        Random random = world.func_72843_D(k, l, 10387312);
        k *= this.spacing;
        l *= this.spacing;
        if (i == (k += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && j == (l += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            return world.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 0, VALID_BIOMES);
        }
        return false;
    }

    protected StructureStart getStructureStart(World world, int chunkX, int chunkZ, Random rand) {
        return new Start(world, rand, chunkX, chunkZ, 1);
    }

    public static class Start
    extends StructureStart {
        private boolean valid;

        public Start() {
        }

        public Start(World worldIn, Random rand, int x, int z, int size) {
            super(x, z);
            this.create(worldIn, rand, x, z, size);
        }

        public void create(World worldIn, Random rand, int x, int z, int size) {
            Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
            BlockPos pos = new BlockPos(x * 16 + 8, Start.getGroundFromAbove(worldIn, x * 16 + 8, z * 16 + 8), z * 16 + 8);
            LinkedList houses = Lists.newLinkedList();
            JungleVillagePieces.generateVillage(worldIn.func_72860_G().func_186340_h(), pos, rotation, houses, rand, worldIn, this.field_75075_a);
            this.field_75075_a.addAll(houses);
            this.func_75072_c();
            this.valid = true;
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            super.func_75068_a(worldIn, rand, structurebb);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructureComponent structurecomponent : this.field_75075_a) {
                        if (!structurecomponent.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                }
            }
        }

        public static int getGroundFromAbove(World world, int x, int z) {
            int y = 255;
            boolean foundGround = false;
            while (!foundGround && y-- >= 31) {
                Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                foundGround = blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150433_aE || blockAt == Blocks.field_150431_aC || blockAt == Blocks.field_150391_bh;
            }
            return y;
        }

        public boolean func_75069_d() {
            return this.valid;
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.valid);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.valid = tagCompound.func_74767_n("Valid");
        }
    }
}

