/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSpawnParticle
implements IMessage {
    private boolean messageValid;
    private double x;
    private double y;
    private double z;
    private double xspeed;
    private double yspeed;
    private double zspeed;
    private EnumParticleTypes particleIn;

    public MessageSpawnParticle() {
        this.messageValid = false;
    }

    public MessageSpawnParticle(EnumParticleTypes types, double x, double y, double z, double xspeed, double yspeed, double zspeed) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xspeed = xspeed;
        this.yspeed = yspeed;
        this.zspeed = zspeed;
        this.particleIn = types;
        this.messageValid = true;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.xspeed = buf.readDouble();
            this.yspeed = buf.readDouble();
            this.zspeed = buf.readDouble();
        }
        catch (IndexOutOfBoundsException ioe) {
            return;
        }
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xspeed);
        buf.writeDouble(this.yspeed);
        buf.writeDouble(this.zspeed);
    }

    public static class Handler
    implements IMessageHandler<MessageSpawnParticle, IMessage> {
        public IMessage onMessage(MessageSpawnParticle message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            WorldClient worldClient = minecraft.field_71441_e;
            minecraft.func_152344_a(() -> this.processMessage(message, worldClient));
            return null;
        }

        void processMessage(MessageSpawnParticle message, WorldClient worldClient) {
            worldClient.func_175688_a(message.particleIn, message.x, message.y, message.z, message.xspeed, message.yspeed, message.zspeed, new int[0]);
        }
    }
}

