/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityBall;
import com.unoriginal.ancientbeasts.entity.Entities.EntityFakeDuplicate;
import com.unoriginal.ancientbeasts.entity.Entities.EntityGhost;
import com.unoriginal.ancientbeasts.entity.Entities.EntityVesselHead;
import com.unoriginal.ancientbeasts.entity.Entities.ai.AIMoveControl;
import com.unoriginal.ancientbeasts.entity.Entities.ai.AIMoveRandom;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityVessel
extends EntitySpellcasterIllager {
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Vessel");
    private static final DataParameter<Integer> ENTITY = EntityDataManager.func_187226_a(EntityVessel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> INACTIVE = EntityDataManager.func_187226_a(EntityVessel.class, (DataSerializer)DataSerializers.field_187198_h);
    private float previousYaw = -1.0f;
    private float previousPitch = -1.0f;
    private EntityVesselHead headShot;
    private int inactTicks;
    private int inactPhase;

    public EntityVessel(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.5f);
        this.field_70765_h = new AIMoveControl((EntityMob)this);
        this.field_70728_aV = 30;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIShootHead());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBallin());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIDuplicateHideNSeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityMob.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(100));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false).func_190882_b(100));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((60.0 + AncientBeastsConfig.VesselHealthBonus) * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalArmor);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENTITY, (Object)0);
        this.field_70180_af.func_187214_a(INACTIVE, (Object)false);
    }

    private void setHeadShoot(int entityId) {
        this.field_70180_af.func_187227_b(ENTITY, (Object)entityId);
    }

    public boolean hasShotHead() {
        return (Integer)this.field_70180_af.func_187225_a(ENTITY) != 0;
    }

    @Nullable
    public EntityVesselHead getHeadShoot() {
        if (!this.hasShotHead()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.headShot != null) {
                return this.headShot;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(ENTITY)).intValue());
            if (entity instanceof EntityVesselHead) {
                this.headShot = (EntityVesselHead)entity;
                return this.headShot;
            }
            return null;
        }
        return this.headShot;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
        if (this.getHeadShoot() != null && this.getHeadShoot().field_70173_aa >= 60 && this.field_70170_p.field_72995_K) {
            this.setHeadShoot(0);
        }
        if (this.isInactive()) {
            this.func_70661_as().func_75484_a(null, 0.0);
            if (!this.field_70122_E) {
                if (this.isInactive()) {
                    this.field_70181_x -= (double)0.06f;
                }
            } else {
                this.func_94061_f(true);
            }
            this.func_174810_b(true);
            if (this.previousYaw == -1.0f) {
                this.previousYaw = this.field_70177_z;
                this.previousPitch = this.field_70125_A;
            }
            this.func_70101_b(this.previousYaw, this.previousPitch);
            this.setHeadShoot(0);
        } else {
            this.func_94061_f(false);
            this.func_174810_b(false);
            this.previousYaw = -1.0f;
            this.previousPitch = -1.0f;
        }
    }

    public void func_70636_d() {
        List list;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.setInactive(this.field_70170_p.func_72935_r() || this.inactTicks > 0);
        }
        if (this.inactTicks > 0) {
            --this.inactTicks;
        }
        if (this.func_110143_aJ() == this.func_110138_aP() && this.inactPhase != 0) {
            this.inactPhase = 0;
        }
        if (this.inactTicks < 20 && this.isInactive() && !(list = this.field_70170_p.func_72872_a(EntityGhost.class, this.func_174813_aQ().func_186662_g(7.0))).isEmpty()) {
            for (EntityGhost oOo : list) {
                double d0 = (this.field_70165_t - oOo.field_70165_t) * 0.1;
                double d2 = (this.field_70163_u - oOo.field_70163_u) * 0.1;
                double d1 = (this.field_70161_v - oOo.field_70161_v) * 0.1;
                oOo.func_70024_g(d0, d2, d1);
            }
        }
        if (this.inactTicks == 0 && this.isInactive() && !this.field_70170_p.field_72995_K && !(list = this.field_70170_p.func_72872_a(EntityGhost.class, this.func_174813_aQ().func_186662_g(7.0))).isEmpty()) {
            for (EntityGhost oOo : list) {
                oOo.func_70106_y();
                this.func_70691_i(this.func_110138_aP() / 12.0f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.4, 0.4, 0.4, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, (double)oOo.func_180425_c().func_177958_n(), (double)oOo.func_180425_c().func_177956_o(), (double)oOo.func_180425_c().func_177952_p(), 0.4, 0.4, 0.4, new int[0]);
            }
        }
    }

    protected SoundEvent func_193086_dk() {
        return null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.isInactive()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityGhost ghost;
            BlockPos blockpos;
            List list = this.field_70170_p.func_72872_a(EntityFakeDuplicate.class, this.func_174813_aQ().func_186662_g(20.0));
            if (!list.isEmpty()) {
                for (EntityFakeDuplicate fakeDuplicate : list) {
                    if (fakeDuplicate.getCreator() != this) continue;
                    fakeDuplicate.func_70097_a(DamageSource.field_76376_m, 1.0f);
                }
            }
            if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f * 2.0f && this.inactPhase == 0) {
                this.inactPhase = 1;
                this.inactTicks = 400;
                for (int i = 0; i < 5; ++i) {
                    blockpos = new BlockPos((Entity)this).func_177982_a(-2 + this.field_70146_Z.nextInt(5), 1, -2 + this.field_70146_Z.nextInt(5));
                    ghost = new EntityGhost(this.field_70170_p);
                    ghost.func_174828_a(blockpos, 0.0f, 0.0f);
                    ghost.func_180482_a(this.field_70170_p.func_175649_E(blockpos), null);
                    this.func_184185_a(ModSounds.GHOST_POSSESS, 1.0f, 1.0f);
                    this.field_70170_p.func_72838_d((Entity)ghost);
                }
            }
            if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f && this.inactPhase == 1) {
                this.inactPhase = 2;
                this.inactTicks = 400;
                for (int i = 0; i < 5; ++i) {
                    blockpos = new BlockPos((Entity)this).func_177982_a(-2 + this.field_70146_Z.nextInt(5), 1, -2 + this.field_70146_Z.nextInt(5));
                    ghost = new EntityGhost(this.field_70170_p);
                    ghost.func_174828_a(blockpos, 0.0f, 0.0f);
                    ghost.func_180482_a(this.field_70170_p.func_175649_E(blockpos), null);
                    this.func_184185_a(ModSounds.GHOST_POSSESS, 1.0f, 1.0f);
                    this.field_70170_p.func_72838_d((Entity)ghost);
                }
            }
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (ENTITY.equals(key)) {
            this.headShot = null;
        }
    }

    public float func_70047_e() {
        return 0.9f;
    }

    public void setInactive(boolean i) {
        this.field_70180_af.func_187227_b(INACTIVE, (Object)i);
    }

    public boolean isInactive() {
        return (Boolean)this.field_70180_af.func_187225_a(INACTIVE);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Inactive", this.isInactive());
        compound.func_74768_a("InactPhase", this.inactPhase);
        compound.func_74768_a("InactTicks", this.inactTicks);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInactive(compound.func_74767_n("Inactive"));
        this.inactPhase = compound.func_74762_e("InactPhase");
        this.inactTicks = compound.func_74762_e("InactTicks");
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.VESSEL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.VESSEL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.VESSEL_DEATH;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    class AIShootHead
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIShootHead() {
            super((EntitySpellcasterIllager)EntityVessel.this);
        }

        protected void func_190868_j() {
            EntityLivingBase entitylivingbase = EntityVessel.this.func_70638_az();
            if (entitylivingbase != null) {
                double d1 = entitylivingbase.field_70165_t - EntityVessel.this.field_70165_t;
                double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (EntityVessel.this.field_70163_u + (double)(EntityVessel.this.field_70131_O / 2.0f));
                double d3 = entitylivingbase.field_70161_v - EntityVessel.this.field_70161_v;
                EntityVesselHead vesselHead = new EntityVesselHead(EntityVessel.this.field_70170_p, (EntityLivingBase)EntityVessel.this, d1, d2, d3);
                vesselHead.func_70107_b(EntityVessel.this.field_70165_t, EntityVessel.this.field_70163_u + (double)EntityVessel.this.func_70047_e(), EntityVessel.this.field_70161_v);
                EntityVessel.this.setHeadShoot(vesselHead.func_145782_y());
                EntityVessel.this.field_70170_p.func_72838_d((Entity)vesselHead);
            }
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 140;
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return null;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.SUMMON_VEX;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityVessel.this.func_193081_a(EntitySpellcasterIllager.SpellType.NONE);
        }
    }

    class AIBallin
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIBallin() {
            super((EntitySpellcasterIllager)EntityVessel.this);
        }

        protected void func_190868_j() {
            double d0 = 10.0 - EntityVessel.this.field_70165_t;
            double d1 = EntityVessel.this.field_70163_u + (double)EntityVessel.this.field_70131_O;
            double d2 = 10.0 - EntityVessel.this.field_70161_v;
            float f = (float)MathHelper.func_181159_b((double)(10.0 - EntityVessel.this.field_70161_v), (double)(10.0 - EntityVessel.this.field_70165_t));
            for (int i = 0; i < 5; ++i) {
                float f2 = f + (float)i * (float)Math.PI * 0.6f + 1.8849558f;
                EntityBall ball = new EntityBall(EntityVessel.this.field_70170_p, (EntityLivingBase)EntityVessel.this);
                ball.func_70186_c(d0 + (double)MathHelper.func_76134_b((float)f2) * ((double)i + 10000.0), d1, d2 + (double)MathHelper.func_76126_a((float)f2) * ((double)i + 10000.0), 0.8f, 0.0f);
                ball.setVariant(EntityVessel.this.field_70170_p.field_73012_v.nextInt(4));
                if (EntityVessel.this.field_70170_p.field_72995_K) continue;
                EntityVessel.this.field_70170_p.func_72838_d((Entity)ball);
            }
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 400;
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.WOLOLO;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityVessel.this.func_193081_a(EntitySpellcasterIllager.SpellType.NONE);
        }
    }

    class AIDuplicateHideNSeek
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIDuplicateHideNSeek() {
            super((EntitySpellcasterIllager)EntityVessel.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (EntityVessel.this.func_110143_aJ() > EntityVessel.this.func_110138_aP() / 2.0f) {
                return false;
            }
            int i = EntityVessel.this.field_70170_p.func_72872_a(EntityFakeDuplicate.class, EntityVessel.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntityVessel.this.field_70146_Z.nextInt(12) + 1 > i;
        }

        protected void func_190868_j() {
            for (int i = 0; i < 8; ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntityVessel.this).func_177982_a(-2 + EntityVessel.this.field_70146_Z.nextInt(5), 1, -2 + EntityVessel.this.field_70146_Z.nextInt(5));
                EntityFakeDuplicate illusion = new EntityFakeDuplicate(EntityVessel.this.field_70170_p);
                illusion.func_174828_a(blockpos, 0.0f, 0.0f);
                illusion.setCreator(EntityVessel.this);
                illusion.setLimitedLife(400);
                illusion.func_180482_a(EntityVessel.this.field_70170_p.func_175649_E(blockpos), null);
                EntityVessel.this.field_70170_p.func_72838_d((Entity)illusion);
            }
        }

        protected int func_190869_f() {
            return 100;
        }

        protected int func_190872_i() {
            return 800;
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.FANGS;
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityVessel.this.func_193081_a(EntitySpellcasterIllager.SpellType.NONE);
        }
    }
}

