/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntitySandSpit;
import com.unoriginal.ancientbeasts.entity.Entities.EntityTornado;
import com.unoriginal.ancientbeasts.entity.Entities.ai.EntityAIMeleeConditional;
import com.unoriginal.ancientbeasts.entity.Entities.magic.CastingMagic;
import com.unoriginal.ancientbeasts.entity.Entities.magic.MagicType;
import com.unoriginal.ancientbeasts.entity.Entities.magic.UseMagic;
import com.unoriginal.ancientbeasts.init.ModSounds;
import com.unoriginal.ancientbeasts.util.IMagicUser;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySandy
extends EntityTameable
implements IMagicUser,
IEntityMultiPart,
IMob {
    private int attackTicks;
    private int buriedTicks;
    private int buriedCooldown;
    private boolean didBurrow;
    private static final DataParameter<Byte> MAGIC = EntityDataManager.func_187226_a(EntitySandy.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final UUID BURIED_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier BURIED_SPEED_BOOST = new AttributeModifier(BURIED_SPEED_BOOST_ID, "Buried speed boost", 0.15, 0).func_111168_a(false);
    private MagicType activeMagic = MagicType.NONE;
    private int magicUseTicks;
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Sandmonster");
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_179558_bo, Items.field_151147_al, Items.field_151082_bd, Items.field_151078_bh, Items.field_179561_bm, Items.field_151076_bf});
    public MultiPartEntityPart[] sandyPartArray;
    public MultiPartEntityPart sandyPartMain = new MultiPartEntityPart((IEntityMultiPart)this, "main", 1.4f, 3.5f);
    public MultiPartEntityPart sandyPartBody = new MultiPartEntityPart((IEntityMultiPart)this, "body1", 1.2f, 1.2f);
    public MultiPartEntityPart sandyPartBody2 = new MultiPartEntityPart((IEntityMultiPart)this, "body2", 1.0f, 1.1f);
    public MultiPartEntityPart sandyPartBody3 = new MultiPartEntityPart((IEntityMultiPart)this, "body3", 0.8f, 0.8f);
    public MultiPartEntityPart sandyPartTail1 = new MultiPartEntityPart((IEntityMultiPart)this, "tail1", 0.6f, 0.6f);
    public MultiPartEntityPart sandyPartTail2 = new MultiPartEntityPart((IEntityMultiPart)this, "tail2", 0.4f, 0.4f);
    public boolean didjump;
    private int dodgeTicks;
    private int avoidTicks;

    public EntitySandy(World worldIn) {
        super(worldIn);
        this.sandyPartArray = new MultiPartEntityPart[]{this.sandyPartMain, this.sandyPartBody, this.sandyPartBody2, this.sandyPartBody3, this.sandyPartTail1, this.sandyPartTail2};
        this.func_70105_a(1.5f, 3.5f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 50;
        this.field_70145_X = false;
        this.field_70158_ak = true;
        this.field_175506_bl = Blocks.field_150354_m;
        this.func_70903_f(false);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public float func_70047_e() {
        return 2.8f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new CastingMagic<EntitySandy>(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new UseSandMagic(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMeleeConditional((EntityCreature)this, 1.0, false, (Predicate<? super EntityLivingBase>)((Predicate)Predicate2 -> this.avoidTicks <= 0)));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new SummonSandShooter(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractIllager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVex.class, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySandy.class, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityLivingBase.class, false, entity -> entity instanceof EntityVillager || entity instanceof EntityIronGolem));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityLivingBase.class, false, entity -> entity instanceof EntityPlayer));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, Predicate2 -> this.avoidTicks > 0, 2.0f, 1.0, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((80.0 + AncientBeastsConfig.SandyTamedHealthBonus) * AncientBeastsConfig.GlobalHealthMultiplier);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((80.0 + AncientBeastsConfig.SandyHealthBonus) * AncientBeastsConfig.GlobalHealthMultiplier);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0 + AncientBeastsConfig.GlobalArmor);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MAGIC, (Object)0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.magicUseTicks > 0) {
            --this.magicUseTicks;
        }
    }

    public void func_70636_d() {
        List entities;
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        if (this.isUsingMagic()) {
            IMagicUser.spawnMagicParticles(this);
        } else {
            this.field_70180_af.func_187227_b(MAGIC, (Object)0);
        }
        float f1 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180) + (float)Math.PI));
        float f2 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        this.sandyPartMain.func_70071_h_();
        this.sandyPartMain.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        this.sandyPartBody.func_70071_h_();
        this.sandyPartBody2.func_70071_h_();
        this.sandyPartBody3.func_70071_h_();
        this.sandyPartTail1.func_70071_h_();
        this.sandyPartTail2.func_70071_h_();
        if (this.func_70906_o()) {
            this.sandyPartBody.func_70012_b(this.field_70165_t - (double)(f1 * 0.8f), this.field_70163_u, this.field_70161_v - (double)f2, 0.0f, 0.0f);
            this.sandyPartBody2.func_70012_b(this.field_70165_t - (double)(f1 * 1.4f), this.field_70163_u, this.field_70161_v - (double)(f2 * 1.9f), 0.0f, 0.0f);
            this.sandyPartBody3.func_70012_b(this.field_70165_t - (double)(f1 * 0.8f), this.field_70163_u, this.field_70161_v - (double)(f2 * 2.6f), 0.0f, 0.0f);
            this.sandyPartTail1.func_70012_b(this.field_70165_t - (double)(f1 * 0.6f), this.field_70163_u, this.field_70161_v - (double)(f2 * 2.9f), 0.0f, 0.0f);
            this.sandyPartTail2.func_70012_b(this.field_70165_t - (double)(f1 * 1.2f), this.field_70163_u, this.field_70161_v - (double)(f2 * 2.1f), 0.0f, 0.0f);
        } else {
            this.sandyPartBody.func_70012_b(this.field_70165_t - (double)(f1 * 1.4f), this.field_70163_u, this.field_70161_v - (double)(f2 * 1.4f), 0.0f, 0.0f);
            this.sandyPartBody2.func_70012_b(this.field_70165_t - (double)(f1 * 2.5f), this.field_70163_u, this.field_70161_v - (double)(f2 * 2.5f), 0.0f, 0.0f);
            this.sandyPartBody3.func_70012_b(this.field_70165_t - (double)(f1 * 3.5f), this.field_70163_u, this.field_70161_v - (double)(f2 * 3.5f), 0.0f, 0.0f);
            this.sandyPartTail1.func_70012_b(this.field_70165_t - (double)(f1 * 4.2f), this.field_70163_u, this.field_70161_v - (double)(f2 * 4.2f), 0.0f, 0.0f);
            this.sandyPartTail2.func_70012_b(this.field_70165_t - (double)(f1 * 5.1f), this.field_70163_u, this.field_70161_v - (double)(f2 * 5.1f), 0.0f, 0.0f);
        }
        if (!this.isBuried()) {
            this.collideWithPart(this.field_70170_p.func_72839_b((Entity)this, this.sandyPartBody.func_174813_aQ()));
            this.collideWithPart(this.field_70170_p.func_72839_b((Entity)this, this.sandyPartBody2.func_174813_aQ()));
            this.collideWithPart(this.field_70170_p.func_72839_b((Entity)this, this.sandyPartBody3.func_174813_aQ()));
            this.collideWithPart(this.field_70170_p.func_72839_b((Entity)this, this.sandyPartTail1.func_174813_aQ()));
            this.collideWithPart(this.field_70170_p.func_72839_b((Entity)this, this.sandyPartTail2.func_174813_aQ()));
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.isAngry()) {
            this.setAngry(false);
        }
        if (this.avoidTicks >= 0) {
            --this.avoidTicks;
        }
        if (this.avoidTicks == 0) {
            this.func_70661_as().func_75499_g();
        }
        if (this.attackTicks > 0) {
            --this.attackTicks;
        }
        if (this.dodgeTicks > 0) {
            --this.dodgeTicks;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.isBuried() && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            for (int x = 0; x < 4; ++x) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.1, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 150 == 0) {
                this.func_184185_a(iblockstate.func_177230_c().func_185467_w().func_185845_c(), 1.0f, 1.0f);
            }
        }
        if (this.func_70638_az() != null && !this.func_70906_o() && !this.isAttacking() && !this.isUsingMagic() && this.field_70122_E && this.buriedCooldown <= 0) {
            if (!this.didBurrow) {
                this.buriedTicks = 200;
                this.setBuried(true);
                this.didBurrow = true;
                this.didjump = false;
            }
        } else if ((this.func_70906_o() || this.isAttacking() || this.field_70171_ac) && this.isBuried()) {
            this.buriedTicks = 0;
            this.buriedCooldown = 200 + this.field_70146_Z.nextInt(300);
            this.didBurrow = false;
            this.setBuried(false);
            if (!this.didjump) {
                this.func_70024_g(0.0, 0.4, 0.0);
                this.didjump = true;
            }
        }
        if (this.buriedTicks > 0) {
            --this.buriedTicks;
        }
        if (this.buriedTicks <= 0 && this.didBurrow) {
            this.buriedCooldown = 200 + this.field_70146_Z.nextInt(300);
            this.didBurrow = false;
            this.setBuried(false);
            if (!this.didjump) {
                this.func_70024_g(0.0, 0.4, 0.0);
                this.didjump = true;
            }
        }
        if (this.buriedCooldown > 0) {
            --this.buriedCooldown;
        }
        if (this.buriedTicks <= 0 && !this.isBuried() && this.buriedCooldown <= 0 && this.func_70638_az() != null) {
            this.buriedTicks = 200;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 150 == 0 && this.func_70909_n() && !(entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(15.0))).isEmpty()) {
            for (Entity entity : entities) {
                if (!(entity instanceof EntitySandy) || ((EntitySandy)entity).func_70902_q() != this.func_70902_q()) continue;
                ((EntitySandy)entity).func_70624_b((EntityLivingBase)this);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTicks = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            entityIn.field_70181_x += (double)0.4f;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        if (!(part != this.sandyPartMain && part != this.sandyPartBody && part != this.sandyPartBody2 && part != this.sandyPartBody3 && part != this.sandyPartTail1 && part != this.sandyPartTail2 || this.isBuried())) {
            this.attackSandyFrom(source, damage);
        }
        return true;
    }

    private void collideWithPart(List<Entity> list) {
        for (Entity entity : list) {
            double d1;
            double d0;
            double d2;
            if (!(entity instanceof EntityLivingBase) || !((d2 = MathHelper.func_76132_a((double)(d0 = entity.field_70165_t - this.field_70165_t), (double)(d1 = entity.field_70161_v - this.field_70161_v))) >= (double)0.01f)) continue;
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            entity.func_70024_g(d0 *= (double)(1.0f - this.field_70144_Y), 0.0, d1 *= (double)(1.0f - this.field_70144_Y));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.isBuried()) {
            return false;
        }
        if (this.field_70146_Z.nextInt(3) == 0 && !this.isBuried() && !this.isUsingMagic() && source.func_76346_g() instanceof EntityLivingBase) {
            double d0 = this.field_70165_t - source.func_76364_f().field_70165_t;
            double d1 = this.field_70161_v - source.func_76364_f().field_70161_v;
            this.dodgeTicks = 10;
            this.avoidTicks = 10 + this.field_70146_Z.nextInt(20);
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
            this.func_70024_g(d0 * 0.5, 0.25, d1 * 0.5);
            this.field_70699_by.func_75499_g();
            if (this.field_70911_d != null) {
                this.field_70911_d.func_75270_a(false);
            }
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        this.avoidTicks = 10 + this.field_70146_Z.nextInt(20);
        return super.func_70097_a(source, amount);
    }

    protected boolean attackSandyFrom(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public Entity[] func_70021_al() {
        return this.sandyPartArray;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood) {
                ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                if (itemstack.func_190916_E() == AncientBeastsConfig.sandmonsterTameStackSize && this.func_110143_aJ() < 80.0f && TAME_ITEMS.contains(itemstack.func_77973_b())) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(AncientBeastsConfig.sandmonsterTameStackSize);
                    }
                    this.func_70691_i((float)itemfood.func_150905_g(itemstack) * 10.0f);
                    this.func_70908_e(true);
                    return true;
                }
            }
            if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (itemstack.func_77973_b() instanceof ItemFood && itemstack.func_190916_E() == AncientBeastsConfig.sandmonsterTameStackSize && !this.func_70909_n() && TAME_ITEMS.contains(itemstack.func_77973_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(AncientBeastsConfig.sandmonsterTameStackSize);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(80.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntitySandy sandy;
            EntityWolf entitywolf;
            if (target instanceof EntityWolf && (entitywolf = (EntityWolf)target).func_70909_n() && entitywolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntitySandy && (sandy = (EntitySandy)target).func_70909_n() && sandy.func_70902_q() != owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
        this.setAngry(entitylivingbaseIn != null);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74757_a("Buried", this.isBuried());
        compound.func_74768_a("MagicUseTicks", this.magicUseTicks);
        compound.func_74768_a("Dodge", this.dodgeTicks);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAngry(compound.func_74767_n("Angry"));
        this.setBuried(compound.func_74767_n("Buried"));
        this.magicUseTicks = compound.func_74762_e("MagicUseTicks");
        this.dodgeTicks = compound.func_74762_e("Dodge");
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(b0 & 0xFFFFFFFD)));
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_72911_I() && this.field_70146_Z.nextInt(AncientBeastsConfig.sandmonsterSpawnChance) == 0 && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Override
    public boolean isUsingMagic() {
        if (this.field_70170_p.field_72995_K) {
            return (Byte)this.field_70180_af.func_187225_a(MAGIC) > 0;
        }
        return this.magicUseTicks > 0;
    }

    @Override
    public int getMagicUseTicks() {
        return this.magicUseTicks;
    }

    @Override
    public void setMagicUseTicks(int magicUseTicksIn) {
        this.magicUseTicks = magicUseTicksIn;
    }

    @Override
    public MagicType getMagicType() {
        return !this.field_70170_p.field_72995_K ? this.activeMagic : MagicType.getFromId(((Byte)this.field_70180_af.func_187225_a(MAGIC)).byteValue());
    }

    @Override
    public void setMagicType(MagicType magicType) {
        this.activeMagic = magicType;
        this.field_70180_af.func_187227_b(MAGIC, (Object)((byte)magicType.getId()));
    }

    public boolean isAttacking() {
        return this.attackTicks > 0;
    }

    public boolean isBuried() {
        return this.buriedTicks > 0;
    }

    public void setBuried(boolean buried) {
        if (!this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (buried) {
                if (!iattributeinstance.func_180374_a(BURIED_SPEED_BOOST)) {
                    iattributeinstance.func_111121_a(BURIED_SPEED_BOOST);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)10);
            } else {
                iattributeinstance.func_111124_b(BURIED_SPEED_BOOST);
                this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTicks = 10;
        }
        if (id == 10) {
            this.buriedTicks = 200;
        }
        if (id == 11) {
            this.dodgeTicks = 10;
        }
        if (id == 12) {
            this.buriedTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTicks;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.SANDMONSTER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.SANDMONSTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SANDMONSTER_DEATH;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn instanceof EntitySandy) {
            return false;
        }
        return super.func_184191_r(entityIn);
    }

    protected void func_82167_n(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.field_70165_t - this.field_70165_t), (double)(d1 = entityIn.field_70161_v - this.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getDodgeTicks() {
        return this.dodgeTicks;
    }

    class SummonSandShooter
    extends UseMagic<EntitySandy> {
        protected SummonSandShooter(EntitySandy magicUserMob) {
            super(magicUserMob);
        }

        @Override
        protected void useMagic() {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = new BlockPos((Entity)EntitySandy.this).func_177982_a(-8 + EntitySandy.this.field_70146_Z.nextInt(20), 1, -8 + EntitySandy.this.field_70146_Z.nextInt(20));
                double d0 = 10.0 - (double)blockpos.func_177958_n();
                double d1 = blockpos.func_177956_o();
                double d2 = 10.0 - (double)blockpos.func_177958_n();
                float f = (float)MathHelper.func_181159_b((double)(10.0f - (float)blockpos.func_177952_p()), (double)(10.0f - (float)blockpos.func_177958_n()));
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    EntitySandSpit entitySandSpit = new EntitySandSpit(EntitySandy.this.field_70170_p, EntitySandy.this);
                    entitySandSpit.func_174828_a(blockpos, 0.0f, 0.0f);
                    entitySandSpit.func_70186_c(d0 + (double)MathHelper.func_76134_b((float)f2) * ((double)k + 10000.0), d1, d2 + (double)MathHelper.func_76126_a((float)f2) * ((double)k + 10000.0), 1.2f, 0.0f);
                    EntitySandy.this.field_70170_p.func_72838_d((Entity)entitySandSpit);
                }
            }
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !EntitySandy.this.isBuried() && EntitySandy.this.dodgeTicks <= 0;
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 400;
        }

        @Override
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_191244_bn;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON;
        }
    }

    class UseSandMagic
    extends UseMagic<EntitySandy> {
        protected UseSandMagic(EntitySandy magicUserMob) {
            super(magicUserMob);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !EntitySandy.this.isBuried() && EntitySandy.this.dodgeTicks <= 0 && !(EntitySandy.this.func_70638_az() instanceof EntitySandy);
        }

        @Override
        protected void useMagic() {
            EntityLivingBase entitylivingbase = EntitySandy.this.func_70638_az();
            double d0 = Math.min(entitylivingbase.field_70163_u, EntitySandy.this.field_70163_u);
            double d1 = Math.max(entitylivingbase.field_70163_u, EntitySandy.this.field_70163_u) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - EntitySandy.this.field_70161_v), (double)(entitylivingbase.field_70165_t - EntitySandy.this.field_70165_t));
            if (EntitySandy.this.func_70068_e((Entity)entitylivingbase) < 9.0) {
                for (int k = 0; k < 8; ++k) {
                    float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnTornadoes(EntitySandy.this.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.5, EntitySandy.this.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.5, d0, d1, f2);
                }
            } else if (EntitySandy.this.func_70068_e((Entity)entitylivingbase) > 18.0 && EntitySandy.this.field_70146_Z.nextInt(5) == 0) {
                for (int i = 0; i < 7; ++i) {
                    float f2 = f + (float)i * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.spawnTornadoes(entitylivingbase.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 4.0, entitylivingbase.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 4.0, d0, d1, f2);
                }
            } else {
                for (int l = 0; l < 4; ++l) {
                    double d2 = 5.0 * (double)(l + 1);
                    float f3 = f + 12.0f;
                    float f4 = f - 12.0f;
                    this.spawnTornadoes(EntitySandy.this.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, EntitySandy.this.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f);
                    this.spawnTornadoes(EntitySandy.this.field_70165_t + (double)MathHelper.func_76134_b((float)f3) * d2, EntitySandy.this.field_70161_v + (double)MathHelper.func_76126_a((float)f3) * d2, d0, d1, f3);
                    this.spawnTornadoes(EntitySandy.this.field_70165_t + (double)MathHelper.func_76134_b((float)f4) * d2, EntitySandy.this.field_70161_v + (double)MathHelper.func_76126_a((float)f4) * d2, d0, d1, f4);
                }
            }
        }

        private void spawnTornadoes(double x, double z, double y, double p_190876_7_, float rotation) {
            BlockPos blockpos = new BlockPos(x, p_190876_7_, z);
            boolean flag = false;
            double d0 = 0.0;
            do {
                IBlockState iblockstate;
                AxisAlignedBB axisalignedbb;
                if (EntitySandy.this.field_70170_p.func_175677_d(blockpos, true) || !EntitySandy.this.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
                if (!EntitySandy.this.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = EntitySandy.this.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)EntitySandy.this.field_70170_p, blockpos)) != null) {
                    d0 = axisalignedbb.field_72337_e;
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)y) - 1);
            if (flag) {
                EntityTornado entityTornado = new EntityTornado(EntitySandy.this.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotation, (EntityLivingBase)EntitySandy.this);
                EntitySandy.this.field_70170_p.func_72838_d((Entity)entityTornado);
            }
        }

        @Override
        protected int getMagicUseTime() {
            return 100;
        }

        @Override
        protected int getMagicUseInterval() {
            return 600;
        }

        @Override
        protected SoundEvent getMagicPrepareSound() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected MagicType getMagicType() {
            return MagicType.SUMMON;
        }
    }
}

