/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.google.common.collect.Sets;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityIceDart;
import com.unoriginal.ancientbeasts.entity.Entities.EntityNetherhound;
import com.unoriginal.ancientbeasts.entity.Entities.ai.EntityAISleep;
import com.unoriginal.ancientbeasts.init.ModItems;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFrostashFox
extends EntityTameable {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityFrostashFox.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityFrostashFox.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SECONDGEN = EntityDataManager.func_187226_a(EntityFrostashFox.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean didShoot;
    protected EntityAISleep entityAISleep;
    private EntityAIAvoidEntity<EntityPlayer> avoidEntity;
    private static final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_179558_bo, Items.field_151076_bf, Items.field_151077_bg, Items.field_179559_bp});
    public int spikeTimer;
    public int spikeShedTime;
    public int i;
    public int lastSleepTimer;
    public int sitTimer;
    private EntityAITempt aiTempt;

    public EntityFrostashFox(World worldIn) {
        super(worldIn);
        this.i = 400 + this.field_70146_Z.nextInt(200);
        this.func_70105_a(0.6f, 0.9f);
        this.spikeShedTime = this.field_70146_Z.nextInt(6000) + 4000;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.entityAISleep = new EntityAISleep(this);
        this.aiTempt = new EntityAITempt((EntityCreature)this, 0.6, true, TAME_ITEMS);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAISleep);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, this.randJump()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPolarBear.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityWolf.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityNetherhound.class, 16.0f, 0.8, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIFrostashFollow(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityChicken.class, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRabbit.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalArmor);
    }

    public float randJump() {
        return this.field_70146_Z.nextInt(10) == 0 ? 0.7f : 0.4f;
    }

    public void func_70636_d() {
        List baseList;
        super.func_70636_d();
        if (!(this.field_70170_p.field_72995_K || this.didShoot || this.spikeTimer > 0 || this.field_70146_Z.nextInt(8) >= 4 || this.func_70909_n() || (baseList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(2.0))).isEmpty())) {
            EntityLivingBase base = (EntityLivingBase)baseList.get(this.field_70170_p.field_73012_v.nextInt(baseList.size()));
            if (base instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)base;
                if (!this.func_70631_g_() && !p.field_71075_bZ.field_75098_d) {
                    this.shootDart();
                    this.spikeTimer = this.i;
                    this.didShoot = true;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                    if (this.entityAISleep != null) {
                        this.entityAISleep.setSleeping(false);
                    }
                }
            } else if ((base instanceof EntityVillager || base instanceof EntityMob || base instanceof EntityWolf || base instanceof EntityPolarBear) && !this.func_70631_g_()) {
                this.shootDart();
                this.spikeTimer = this.i;
                this.didShoot = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                if (this.entityAISleep != null) {
                    this.entityAISleep.setSleeping(false);
                }
            }
        }
        if ((!this.field_70170_p.func_72935_r() || this.field_70170_p.func_72935_r() && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) && this.entityAISleep != null) {
            this.entityAISleep.setSleeping(false);
        }
        if (this.spikeTimer > 0) {
            --this.spikeTimer;
        }
        if (this.didShoot && this.spikeTimer <= 0) {
            this.didShoot = false;
        }
        if (this.entityAISleep != null && this.entityAISleep.nextSleepTicks > 0) {
            --this.entityAISleep.nextSleepTicks;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.spikeTimer <= 0 && --this.spikeShedTime <= 0) {
            this.func_184185_a(ModSounds.ICE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (this.isRed()) {
                this.func_70099_a(new ItemStack(ModItems.ICE_DART, this.field_70170_p.field_73012_v.nextInt(3), 1), 0.0f);
            } else if (this.getVariant() == 2) {
                this.func_70099_a(new ItemStack(ModItems.ICE_DART, this.field_70170_p.field_73012_v.nextInt(3), this.field_70170_p.field_73012_v.nextInt(1)), 0.0f);
            } else {
                this.func_70099_a(new ItemStack(ModItems.ICE_DART, this.field_70170_p.field_73012_v.nextInt(3), 0), 0.0f);
            }
            this.spikeShedTime = this.field_70146_Z.nextInt(6000) + 4000;
        }
        if (!this.field_70170_p.field_72995_K && ++this.lastSleepTimer >= 24000 && this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(true);
            this.sitTimer = 400;
            this.lastSleepTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K && --this.sitTimer <= 0 && this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(SECONDGEN, (Object)Boolean.FALSE);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        this.func_184185_a(ModSounds.FROSTASH_FOX_BITE, 1.0f, 1.0f);
        return flag;
    }

    public static int getRandVariant(Random rand) {
        int i = rand.nextInt(100);
        if (i < 5) {
            return 0;
        }
        if (i < 15) {
            return 3;
        }
        if (i < 18) {
            return 4;
        }
        return rand.nextInt(300) == 0 ? 2 : 1;
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)4);
    }

    public void setVariant(int variantIn) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variantIn);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Sleeping", this.isSleeping());
        compound.func_74757_a("SecondGen", this.isSecondGen());
        compound.func_74768_a("IceShedTime", this.spikeShedTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        if (this.entityAISleep != null) {
            this.entityAISleep.setSleeping(compound.func_74767_n("Sleeping"));
        }
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.setSecondGen(compound.func_74767_n("SecondGen"));
        if (compound.func_74764_b("IceShedTime")) {
            this.spikeShedTime = compound.func_74762_e("IceShedTime");
        }
    }

    public boolean isRed() {
        return this.getVariant() > 2;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179558_bo;
    }

    public EntityFrostashFox createChild(EntityAgeable ageable) {
        EntityFrostashFox frostashFox = new EntityFrostashFox(this.field_70170_p);
        EntityFrostashFox fox = (EntityFrostashFox)ageable;
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            frostashFox.func_184754_b(uuid);
            frostashFox.func_70903_f(true);
            frostashFox.setSecondGen(true);
        }
        frostashFox.setVariant(this.getParentsMix(this, fox));
        return frostashFox;
    }

    private int getParentsMix(EntityFrostashFox father, EntityFrostashFox mother) {
        int j;
        int i = father.getVariant();
        int k = i + (j = mother.getVariant());
        int l = k > 6 ? 4 : (k >= 5 ? 3 : (k == 4 ? 2 : (k >= 2 ? 1 : 0)));
        return l;
    }

    public boolean isSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public boolean isSecondGen() {
        return (Boolean)this.field_70180_af.func_187225_a(SECONDGEN);
    }

    public void setSecondGen(boolean secondGen) {
        this.field_70180_af.func_187227_b(SECONDGEN, (Object)secondGen);
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityFrostashFox)) {
            return false;
        }
        EntityFrostashFox frostashFox = (EntityFrostashFox)otherAnimal;
        if (!frostashFox.func_70909_n()) {
            return false;
        }
        if (frostashFox.isSleeping()) {
            return false;
        }
        return this.func_70880_s() && frostashFox.func_70880_s();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemFood itemfood;
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_70909_n() && TAME_ITEMS.contains(itemstack.func_77973_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.FROSTASH_FOX_EAT, this.func_184176_by(), 1.0f, 1.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(2) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (this.func_70909_n() && itemstack.func_77973_b() instanceof ItemFood && TAME_ITEMS.contains(itemfood = (ItemFood)itemstack.func_77973_b()) && this.func_110143_aJ() < 14.0f) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.FROSTASH_FOX_EAT, this.func_184176_by(), 1.0f, 1.0f);
            }
            this.func_70691_i(itemfood.func_150905_g(itemstack));
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void shootDart() {
        double d0 = 10.0 - this.field_70165_t;
        double d1 = this.field_70163_u + (double)this.field_70131_O;
        double d2 = 10.0 - this.field_70161_v;
        float f = (float)MathHelper.func_181159_b((double)(10.0 - this.field_70161_v), (double)(10.0 - this.field_70165_t));
        this.func_184185_a(ModSounds.ICE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        for (int k = 0; k < 4; ++k) {
            float f2 = f + (float)k * (float)Math.PI * 3.0f / 8.0f + 1.8849556f;
            EntityIceDart iceDart = new EntityIceDart(this.field_70170_p, (EntityLivingBase)this, this.isRed());
            iceDart.func_70186_c(d0 + (double)MathHelper.func_76134_b((float)f2) * ((double)k + 10000.0), d1, d2 + (double)MathHelper.func_76126_a((float)f2) * ((double)k + 10000.0), 1.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)iceDart);
        }
        EntityIceDart iceDart1 = new EntityIceDart(this.field_70170_p, (EntityLivingBase)this, this.isRed());
        iceDart1.func_70186_c(0.0, 10000.0, 0.0, 1.0f, 0.0f);
    }

    protected void func_175544_ck() {
        if (this.avoidEntity == null) {
            this.avoidEntity = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 1.0, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.avoidEntity);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.avoidEntity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.spikeTimer = this.i;
        } else {
            super.func_70103_a(id);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextInt(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                EntityFrostashFox fox = new EntityFrostashFox(this.field_70170_p);
                fox.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                fox.func_70873_a(-24000);
                this.field_70170_p.func_72838_d((Entity)fox);
            }
        }
        this.setVariant(EntityFrostashFox.getRandVariant(this.field_70170_p.field_73012_v));
        return livingdata;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (this.entityAISleep != null) {
            this.entityAISleep.setSleeping(false);
        }
        if (!(this.field_70170_p.field_72995_K || this.func_70631_g_() || this.didShoot || this.spikeTimer > 0)) {
            this.shootDart();
            this.spikeTimer = this.i;
            this.didShoot = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
        if (source.func_76347_k()) {
            amount *= 3.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    protected SoundEvent func_184639_G() {
        if (this.isSleeping()) {
            return ModSounds.FROSTASH_FOX_SLEEP;
        }
        if (!this.func_70909_n() && !this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(500) == 0) {
            return ModSounds.FROSTASH_FOX_SCREECH;
        }
        return ModSounds.FROSTASH_FOX_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.FROSTASH_FOX_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.FROSTASH_FOX_DEATH;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    class AIFrostashFollow
    extends EntityAIFollowOwner {
        public AIFrostashFollow(EntityTameable tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
            super((EntityTameable)EntityFrostashFox.this, followSpeedIn, minDistIn, maxDistIn);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && EntityFrostashFox.this.isSecondGen();
        }
    }
}

