/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFleeBattle;
import fossilsarcheology.server.entity.ai.DinoAIFlockWander;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricFlocking;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class EntityMammoth
extends EntityPrehistoricFlocking
implements IShearable {
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityMammoth.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final PotionEffect BIOME_EFFECT = new PotionEffect(MobEffects.field_76437_t, 60, 1);
    protected boolean isSheared;
    private int eatGrassTimes = 0;

    public EntityMammoth(World world) {
        super(world, PrehistoricEntityType.MAMMOTH, 2.0, 12.0, 10.0, 66.0, 0.2, 0.25, 0.0, 10.0);
        this.setActualSize(1.2f, 0.7f);
        this.pediaScale = 60.0f;
        this.minSize = 1.1f;
        this.maxSize = 3.6f;
        this.teenAge = 7;
        this.developsResistance = true;
        this.breaksBlocks = true;
        this.ridingY = 1.25f;
        this.eatGrassTimes = 0;
        this.setSheared(false);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFleeBattle(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIFlockWander(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.MAMMOTH_LOOT;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
    }

    @Override
    public int getAttackLength() {
        return 35;
    }

    @Override
    public int getSpeakLength() {
        return 35;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.isSheared() && !this.func_70631_g_() && !this.isSkeleton();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> var7 = new ArrayList<ItemStack>();
        int var8 = 1 + this.field_70146_Z.nextInt(20);
        for (int var9 = 0; var9 < var8; ++var9) {
            var7.add(new ItemStack(Blocks.field_150325_L, 1, 12));
        }
        this.setSheared(true);
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return var7;
    }

    @Override
    public String getTexture() {
        String sleeping;
        String gender;
        String toggle;
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        String string = this.hasFeatherToggle ? (!this.featherToggle ? "feathered/" : "scaled/") : (toggle = "");
        String string2 = this.func_70631_g_() ? "_baby" : (gender = this.getGender() == 0 ? "_female" : "_male");
        String string3 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping = "_sleeping");
        String toggleList = this.hasFeatherToggle ? (!this.featherToggle ? "_feathered" : "_scaled") : "";
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender + toggleList + sleeping + (this.isSheared() ? "_sheared" : "") + ".png";
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public void func_70014_b(NBTTagCompound var1) {
        super.func_70014_b(var1);
        var1.func_74768_a("GrassTicks", this.eatGrassTimes);
        var1.func_74757_a("Sheared", this.isSheared());
    }

    @Override
    public void func_70037_a(NBTTagCompound var1) {
        super.func_70037_a(var1);
        this.setSheared(var1.func_74767_n("Sheared"));
        this.eatGrassTimes = var1.func_74762_e("GrassTicks");
    }

    @Override
    public void doFoodEffect(Item item) {
        super.doFoodEffect(item);
        if (this.isSheared()) {
            ++this.eatGrassTimes;
            if (this.eatGrassTimes >= 5) {
                this.setSheared(false);
                this.eatGrassTimes = 0;
            }
        }
    }

    @Override
    public void func_70636_d() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (!this.func_70644_a(MobEffects.field_76437_t)) {
            BlockPos blockPos = new BlockPos(i, 0, k);
            BlockPos blockPos2 = new BlockPos(i, j, k);
            if ((double)this.field_70170_p.func_180494_b(blockPos).func_180626_a(blockPos2) > 1.0 && !this.isSheared() && !this.isSkeleton()) {
                this.func_70690_d(BIOME_EFFECT);
            }
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 17 && this.func_70638_az() != null) {
            this.doAttack();
            this.doAttackKnockback(2.0f);
        }
        super.func_70636_d();
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.KNOCKUP;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.TERITORIAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.IMPRINTING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.ATTACK;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.WALK;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.NONE;
    }

    @Override
    public boolean doesFlock() {
        return true;
    }

    @Override
    protected int getMaxGroupSize() {
        return 7;
    }

    @Override
    public Item getOrderItem() {
        return Items.field_151055_y;
    }

    @Override
    public int getAdultAge() {
        return 14;
    }

    @Override
    public float getMaleSize() {
        return 1.15f;
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() != this.ATTACK_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    public int getMaxHunger() {
        return 150;
    }

    public boolean isSheared() {
        if (this.field_70170_p.field_72995_K) {
            boolean isStanding;
            this.isSheared = isStanding = ((Boolean)this.field_70180_af.func_187225_a(SHEARED)).booleanValue();
            return isStanding;
        }
        return this.isSheared;
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
        if (!this.field_70170_p.field_72995_K) {
            this.isSheared = sheared;
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.MAMMOTH_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.MAMMOTH_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.MAMMOTH_DEATH;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }
}

